/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.session;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.internal.lttng2.control.core.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.lttng2.control.core.session.SessionConfigGenerator;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionConfigGeneratorTest {
    private static final File VALID_SESSION_FILE = new File("../../lttng/org.eclipse.tracecompass.lttng2.control.core.tests/test_session_config_files/test_valid.lttng");
    private static final File INVALID_SESSION_FILE = new File("../../lttng/org.eclipse.tracecompass.lttng2.control.core.tests/test_session_config_files/test_invalid.lttng");
    private static final String SESSION_FILENAME = "test_session.lttng";
    private static final IPath SESSION_FILE_PATH = Activator.getDefault().getStateLocation().addTrailingSeparator().append("test_session.lttng");
    private static final String TRACE_SESSION_PATH = "/home/user/folder";
    private static final String SESSION_NAME_1 = "session1";
    private static final String SESSION_NAME_2 = "session2";
    private static final String SESSION_NAME_3 = "session3";
    private ISessionInfo fValidSessionInfo = null;
    private ISessionInfo fValidSessionSnapshotInfo = null;
    private ISessionInfo fInvalidSessionInfo = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        IDomainInfo domain = factory.getDomainInfo1();
        domain.setBufferType(BufferType.BUFFER_SHARED);
        this.fValidSessionInfo = new SessionInfo(SESSION_NAME_1);
        this.fValidSessionInfo.setSessionPath(TRACE_SESSION_PATH);
        this.fValidSessionInfo.setSessionState(TraceSessionState.ACTIVE);
        this.fValidSessionInfo.addDomain(domain);
        this.fValidSessionSnapshotInfo = new SessionInfo(SESSION_NAME_2);
        this.fValidSessionSnapshotInfo.setSessionPath(TRACE_SESSION_PATH);
        this.fValidSessionSnapshotInfo.setSessionState(TraceSessionState.ACTIVE);
        this.fValidSessionSnapshotInfo.addDomain(domain);
        this.fValidSessionSnapshotInfo.setSnapshotInfo(factory.getSnapshotInfo1());
        this.fInvalidSessionInfo = factory.getSessionInfo2();
        this.fInvalidSessionInfo.setName(SESSION_NAME_3);
    }

    @After
    public void tearUp() {
        File sessionConfigurationFile = SESSION_FILE_PATH.toFile();
        if (sessionConfigurationFile.exists()) {
            sessionConfigurationFile.delete();
        }
    }

    @Test
    public void testSessionValidate() {
        IStatus status;
        File testSessionFile = VALID_SESSION_FILE;
        if (testSessionFile == null || !testSessionFile.exists()) {
            Assert.fail((String)"Session test file does not exist");
        }
        if (!(status = SessionConfigGenerator.sessionValidate((File)testSessionFile)).isOK()) {
            Assert.fail((String)status.getMessage());
        }
        if ((testSessionFile = INVALID_SESSION_FILE) == null || !testSessionFile.exists()) {
            Assert.fail((String)"Session test file does not exist");
        }
        Assert.assertFalse((boolean)SessionConfigGenerator.sessionValidate((File)testSessionFile).isOK());
    }

    @Test
    public void testGenerateSessionConfig() {
        HashSet<ISessionInfo> sessions = new HashSet<ISessionInfo>();
        Assert.assertFalse((boolean)SessionConfigGenerator.generateSessionConfig(sessions, (IPath)SESSION_FILE_PATH).isOK());
        sessions.add(this.fValidSessionInfo);
        Assert.assertTrue((boolean)SessionConfigGenerator.generateSessionConfig(sessions, (IPath)SESSION_FILE_PATH).isOK());
        Assert.assertTrue((boolean)SessionConfigGenerator.sessionValidate((File)SESSION_FILE_PATH.toFile()).isOK());
        sessions.add(this.fValidSessionSnapshotInfo);
        Assert.assertTrue((boolean)SessionConfigGenerator.generateSessionConfig(sessions, (IPath)SESSION_FILE_PATH).isOK());
        Assert.assertTrue((boolean)SessionConfigGenerator.sessionValidate((File)SESSION_FILE_PATH.toFile()).isOK());
        sessions.add(this.fInvalidSessionInfo);
        Assert.assertFalse((boolean)SessionConfigGenerator.generateSessionConfig(sessions, (IPath)SESSION_FILE_PATH).isOK());
    }
}

