/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.perf.views;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.perf.views.ViewsResponseTest;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class UiResponseTest
extends ViewsResponseTest {
    private static final @NonNull Map<OsLinuxViews, String> VIEW_IDS = ImmutableMap.of((Object)((Object)OsLinuxViews.CONTROL_FLOW), (Object)"org.eclipse.tracecompass.analysis.os.linux.views.controlflow", (Object)((Object)OsLinuxViews.RESOURCES), (Object)"org.eclipse.tracecompass.analysis.os.linux.views.resources", (Object)((Object)OsLinuxViews.CPU_USAGE), (Object)"org.eclipse.tracecompass.analysis.os.linux.views.cpuusage", (Object)((Object)OsLinuxViews.DISK_IO_ACTIVITY), (Object)"org.eclipse.tracecompass.analysis.os.linux.views.diskioactivity", (Object)((Object)OsLinuxViews.KERNEL_MEMORY_USAGE), (Object)"org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview");

    protected void beforeRunningTest(ITmfTrace trace) {
        ArrayList<IAnalysisModule> modules = new ArrayList<IAnalysisModule>(3);
        modules.add(trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.cpuusage"));
        modules.add(trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.kernel"));
        modules.add(trace.getAnalysisModule("org.eclipse.tracecompass.analysis.os.linux.inputoutput"));
        for (IAnalysisModule module : modules) {
            if (module == null) continue;
            module.schedule();
        }
        for (IAnalysisModule module : modules) {
            if (module == null) continue;
            Assert.assertTrue((boolean)module.waitForCompletion());
        }
    }

    protected void runTestWithTrace(String tracePath, String traceType, EnumSet<OsLinuxViews> views) {
        ArrayList<String> viewIDs = new ArrayList<String>();
        for (OsLinuxViews view : views) {
            viewIDs.add(VIEW_IDS.get((Object)view));
        }
        this.runTestWithTrace(tracePath, traceType, viewIDs);
    }

    protected static enum OsLinuxViews {
        CONTROL_FLOW,
        RESOURCES,
        CPU_USAGE,
        DISK_IO_ACTIVITY,
        KERNEL_MEMORY_USAGE;

    }
}

