/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.stubs;

import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphBuilder;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.TmfGraphLegacyWrapper;

public class GraphFactory {
    public static final IGraphWorker Actor0 = new TestGraphWorker(0);
    public static final TestGraphWorker Actor1 = new TestGraphWorker(1);
    private static final String LINK_QUALIFIER = "testLinkQualifier";
    public static final GraphBuilder GRAPH_BASIC = new GraphBuilder("basic"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0 = graph.createVertex(Actor0, 0L);
            graph.add(v0);
            ITmfVertex v1 = graph.createVertex(Actor0, 1L);
            graph.append(v1, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            return this.build();
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            return this.build();
        }
    };
    public static final GraphBuilder GRAPH_WAKEUP_SELF = new GraphBuilder("wakeup_self"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            ITmfVertex vStart = graph.createVertex(Actor0, 1L);
            graph.append(vStart, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            ITmfVertex vEnd = graph.createVertex(Actor0, 3L);
            graph.append(vEnd, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edgeVertical(vStart, vEnd, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.TIMER), null);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 1L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.append(graph.createVertex(Actor0, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.TIMER));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 1L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.TIMER));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            return graph;
        }
    };
    public static final GraphBuilder GRAPH_WAKEUP_MISSING = new GraphBuilder("wakeup_missing"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED), GraphFactory.LINK_QUALIFIER);
            graph.append(graph.createVertex(Actor0, 6L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED), GraphFactory.LINK_QUALIFIER);
            graph.append(graph.createVertex(Actor0, 6L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static final GraphBuilder GRAPH_WAKEUP_UNKNOWN = new GraphBuilder("wakeup_unknown"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex vIn = graph.createVertex(Actor0, 4L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(vIn, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 6L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex vNet = graph.createVertex((IGraphWorker)Actor1, 3L);
            graph.add(vNet);
            graph.edge(vNet, vIn, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            ITmfVertex vStartBlock = graph.createVertex(Actor0, 2L);
            ITmfVertex vEndBlock = graph.createVertex(Actor0, 4L);
            graph.append(vStartBlock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(vEndBlock);
            graph.append(graph.createVertex(Actor0, 6L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex vStartOther = graph.createVertex((IGraphWorker)Actor1, 2L);
            ITmfVertex vEndOther = graph.createVertex((IGraphWorker)Actor1, 3L);
            graph.add(vStartOther);
            graph.appendUnknown(vEndOther);
            graph.edge(vStartBlock, vStartOther);
            graph.edge(vEndOther, vEndBlock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            ITmfVertex vStartBlock = graph.createVertex(Actor0, 3L);
            ITmfVertex vEndBlock = graph.createVertex(Actor0, 4L);
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.appendUnknown(vStartBlock);
            graph.add(vEndBlock);
            graph.append(graph.createVertex(Actor0, 6L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edgeVertical(vStartBlock, vEndBlock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), null);
            return graph;
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_NEW = new GraphBuilder("wakeup_new"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex vSrcLink = graph.createVertex(Actor0, 2L);
            ITmfVertex vBlockEnd = graph.createVertex(Actor0, 6L);
            ITmfVertex vDstLink = graph.createVertex((IGraphWorker)Actor1, 3L);
            ITmfVertex vWakeup = graph.createVertex((IGraphWorker)Actor1, 6L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(vSrcLink, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.append(vBlockEnd, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 8L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.add(vDstLink);
            graph.append(vWakeup, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.edge(vSrcLink, vDstLink);
            graph.edge(vWakeup, vBlockEnd);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex vBlockStart = graph.createVertex(Actor0, 4L);
            ITmfVertex vBlockEnd = graph.createVertex(Actor0, 6L);
            ITmfVertex vDstLink = graph.createVertex((IGraphWorker)Actor1, 4L);
            ITmfVertex vWakeup = graph.createVertex((IGraphWorker)Actor1, 6L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(vBlockStart, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.add(vBlockEnd);
            graph.append(graph.createVertex(Actor0, 8L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.add(vDstLink);
            graph.append(vWakeup, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.edge(vBlockStart, vDstLink);
            graph.edge(vWakeup, vBlockEnd);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex vSrcLink = graph.createVertex(Actor0, 2L);
            ITmfVertex vBlockEnd = graph.createVertex(Actor0, 6L);
            ITmfVertex vDstLink = graph.createVertex((IGraphWorker)Actor1, 3L);
            ITmfVertex vWakeup = graph.createVertex((IGraphWorker)Actor1, 6L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(vSrcLink, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(vBlockEnd);
            graph.append(graph.createVertex(Actor0, 8L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.add(vDstLink);
            graph.append(vWakeup, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING), GraphFactory.LINK_QUALIFIER);
            graph.edge(vSrcLink, vDstLink);
            graph.edge(vWakeup, vBlockEnd);
            return graph;
        }
    };
    public static GraphBuilder GRAPH_OPENED_DELAY = new GraphBuilder("opened"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex v1 = graph.createVertex(Actor0, 6L);
            graph.append(v1, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 9L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(graph.createVertex((IGraphWorker)Actor1, 0L));
            ITmfVertex v2 = graph.createVertex((IGraphWorker)Actor1, 2L);
            graph.append(v2, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex((IGraphWorker)Actor1, 5L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v2, v1);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            ITmfVertex v1 = graph.createVertex(Actor0, 3L);
            graph.append(v1, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex v2 = graph.createVertex((IGraphWorker)Actor1, 3L);
            ITmfVertex v3 = graph.createVertex(Actor0, 6L);
            graph.add(v2);
            graph.add(v3);
            graph.edge(v1, v2);
            graph.edge(v2, v3);
            graph.append(graph.createVertex(Actor0, 9L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_OPENED = new GraphBuilder("opened"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex v1 = graph.createVertex(Actor0, 6L);
            graph.append(v1, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 9L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(graph.createVertex((IGraphWorker)Actor1, 0L));
            ITmfVertex v2 = graph.createVertex((IGraphWorker)Actor1, 6L);
            graph.append(v2, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex((IGraphWorker)Actor1, 9L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v2, v1);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            graph.add(graph.createVertex(Actor0, 0L));
            ITmfVertex v1 = graph.createVertex(Actor0, 3L);
            graph.append(v1, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex v2 = graph.createVertex((IGraphWorker)Actor1, 3L);
            ITmfVertex v3 = graph.createVertex((IGraphWorker)Actor1, 6L);
            graph.add(v2);
            graph.append(v3, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            ITmfVertex v4 = graph.createVertex(Actor0, 6L);
            graph.add(v4);
            graph.edge(v1, v2);
            graph.edge(v3, v4);
            graph.append(graph.createVertex(Actor0, 9L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_MUTUAL = new GraphBuilder("wakeup_mutual"){

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0Wakeup = graph.createVertex(Actor0, 2L);
            ITmfVertex v0Unblock = graph.createVertex(Actor0, 4L);
            ITmfVertex v1Unblock = graph.createVertex((IGraphWorker)Actor1, 2L);
            ITmfVertex v1Wakeup = graph.createVertex((IGraphWorker)Actor1, 4L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 1L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0Wakeup, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0Unblock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 5L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(graph.createVertex((IGraphWorker)Actor1, 0L));
            graph.append(graph.createVertex((IGraphWorker)Actor1, 1L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v1Unblock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex((IGraphWorker)Actor1, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v1Wakeup, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex((IGraphWorker)Actor1, 5L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0Wakeup, v1Unblock);
            graph.edge(v1Wakeup, v0Unblock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0StartBlock = graph.createVertex(Actor0, 3L);
            ITmfVertex v0EndBlock = graph.createVertex(Actor0, 4L);
            ITmfVertex v1StartBlock = graph.createVertex((IGraphWorker)Actor1, 3L);
            ITmfVertex v1EndBlock = graph.createVertex((IGraphWorker)Actor1, 4L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 1L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0StartBlock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v0EndBlock);
            graph.append(graph.createVertex(Actor0, 5L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1StartBlock);
            graph.append(v1EndBlock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0StartBlock, v1StartBlock);
            graph.edge(v1EndBlock, v0EndBlock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0Wakeup = graph.createVertex(Actor0, 2L);
            ITmfVertex v0Unblock = graph.createVertex(Actor0, 4L);
            ITmfVertex v1Unblock = graph.createVertex((IGraphWorker)Actor1, 2L);
            ITmfVertex v1Wakeup = graph.createVertex((IGraphWorker)Actor1, 4L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 1L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0Wakeup, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v0Unblock);
            graph.append(graph.createVertex(Actor0, 5L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1Unblock);
            graph.append(graph.createVertex((IGraphWorker)Actor1, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v1Wakeup, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0Wakeup, v1Unblock);
            graph.edge(v1Wakeup, v0Unblock);
            return graph;
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_EMBEDDED = new GraphBuilder("wakeup_embeded"){
        private TestGraphWorker fActor2 = new TestGraphWorker(2);

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0FirstFork = graph.createVertex(Actor0, 2L);
            ITmfVertex v0SecondFork = graph.createVertex(Actor0, 4L);
            ITmfVertex v0FirstUnblock = graph.createVertex(Actor0, 8L);
            ITmfVertex v0SecondUnblock = graph.createVertex(Actor0, 10L);
            ITmfVertex v1In = graph.createVertex((IGraphWorker)Actor1, 4L);
            ITmfVertex v1Out = graph.createVertex((IGraphWorker)Actor1, 8L);
            ITmfVertex v2In = graph.createVertex((IGraphWorker)this.fActor2, 2L);
            ITmfVertex v2Out = graph.createVertex((IGraphWorker)this.fActor2, 10L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(v0FirstFork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0SecondFork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 6L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0FirstUnblock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(v0SecondUnblock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 12L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1In);
            graph.append(v1Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2In);
            graph.append(v2Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0FirstFork, v2In);
            graph.edge(v0SecondFork, v1In);
            graph.edge(v1Out, v0FirstUnblock);
            graph.edge(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0StartBlock = graph.createVertex(Actor0, 6L);
            ITmfVertex v0FirstUnblock = graph.createVertex(Actor0, 8L);
            ITmfVertex v0SecondUnblock = graph.createVertex(Actor0, 10L);
            ITmfVertex v1In = graph.createVertex((IGraphWorker)Actor1, 6L);
            ITmfVertex v1Out = graph.createVertex((IGraphWorker)Actor1, 8L);
            ITmfVertex v2In = graph.createVertex((IGraphWorker)this.fActor2, 8L);
            ITmfVertex v2Out = graph.createVertex((IGraphWorker)this.fActor2, 10L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0StartBlock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v0FirstUnblock);
            graph.add(v0SecondUnblock);
            graph.append(graph.createVertex(Actor0, 12L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1In);
            graph.append(v1Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2In);
            graph.append(v2Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0StartBlock, v1In);
            graph.edge(v1Out, v0FirstUnblock);
            graph.edge(v0FirstUnblock, v2In);
            graph.edge(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_WAKEUP_INTERLEAVE = new GraphBuilder("wakeup_interleave"){
        private TestGraphWorker fActor2 = new TestGraphWorker(2);

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0FirstFork = graph.createVertex(Actor0, 2L);
            ITmfVertex v0SecondFork = graph.createVertex(Actor0, 4L);
            ITmfVertex v0FirstUnblock = graph.createVertex(Actor0, 8L);
            ITmfVertex v0SecondUnblock = graph.createVertex(Actor0, 10L);
            ITmfVertex v1In = graph.createVertex((IGraphWorker)Actor1, 2L);
            ITmfVertex v1Out = graph.createVertex((IGraphWorker)Actor1, 8L);
            ITmfVertex v2In = graph.createVertex((IGraphWorker)this.fActor2, 4L);
            ITmfVertex v2Out = graph.createVertex((IGraphWorker)this.fActor2, 10L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(v0FirstFork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0SecondFork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 6L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0FirstUnblock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(v0SecondUnblock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 12L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1In);
            graph.append(v1Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2In);
            graph.append(v2Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0FirstFork, v1In);
            graph.edge(v0SecondFork, v2In);
            graph.edge(v1Out, v0FirstUnblock);
            graph.edge(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0StartBlock = graph.createVertex(Actor0, 6L);
            ITmfVertex v0FirstUnblock = graph.createVertex(Actor0, 8L);
            ITmfVertex v0SecondUnblock = graph.createVertex(Actor0, 10L);
            ITmfVertex v1In = graph.createVertex((IGraphWorker)Actor1, 6L);
            ITmfVertex v1Out = graph.createVertex((IGraphWorker)Actor1, 8L);
            ITmfVertex v2In = graph.createVertex((IGraphWorker)this.fActor2, 8L);
            ITmfVertex v2Out = graph.createVertex((IGraphWorker)this.fActor2, 10L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 2L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex(Actor0, 4L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0StartBlock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v0FirstUnblock);
            graph.add(v0SecondUnblock);
            graph.append(graph.createVertex(Actor0, 12L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1In);
            graph.append(v1Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2In);
            graph.append(v2Out, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0StartBlock, v1In);
            graph.edge(v1Out, v0FirstUnblock);
            graph.edge(v0FirstUnblock, v2In);
            graph.edge(v2Out, v0SecondUnblock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
    public static GraphBuilder GRAPH_NESTED = new GraphBuilder("wakeup_nested"){
        private final TestGraphWorker fActor2 = new TestGraphWorker(2);
        private final TestGraphWorker fActor3 = new TestGraphWorker(3);

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0Fork = graph.createVertex(Actor0, 1L);
            ITmfVertex v0Return = graph.createVertex(Actor0, 6L);
            ITmfVertex v1In = graph.createVertex((IGraphWorker)Actor1, 1L);
            ITmfVertex v1Fork = graph.createVertex((IGraphWorker)Actor1, 2L);
            ITmfVertex v1Return = graph.createVertex((IGraphWorker)Actor1, 5L);
            ITmfVertex v1End = graph.createVertex((IGraphWorker)Actor1, 6L);
            ITmfVertex v2In = graph.createVertex((IGraphWorker)this.fActor2, 2L);
            ITmfVertex v2Fork = graph.createVertex((IGraphWorker)this.fActor2, 3L);
            ITmfVertex v2Return = graph.createVertex((IGraphWorker)this.fActor2, 4L);
            ITmfVertex v2End = graph.createVertex((IGraphWorker)this.fActor2, 5L);
            ITmfVertex v3In = graph.createVertex((IGraphWorker)this.fActor3, 3L);
            ITmfVertex v3End = graph.createVertex((IGraphWorker)this.fActor3, 4L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(v0Fork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0Return, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 7L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1In);
            graph.append(v1Fork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v1Return, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(v1End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2In);
            graph.append(v2Fork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v2Return, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(v2End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v3In);
            graph.append(v3End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0Fork, v1In);
            graph.edge(v1Fork, v2In);
            graph.edge(v2Fork, v3In);
            graph.edge(v3End, v2Return);
            graph.edge(v2End, v1Return);
            graph.edge(v1End, v0Return);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0Fork = graph.createVertex(Actor0, 1L);
            ITmfVertex v0Return = graph.createVertex(Actor0, 6L);
            ITmfVertex v1In = graph.createVertex((IGraphWorker)Actor1, 1L);
            ITmfVertex v1Fork = graph.createVertex((IGraphWorker)Actor1, 2L);
            ITmfVertex v1Return = graph.createVertex((IGraphWorker)Actor1, 5L);
            ITmfVertex v1End = graph.createVertex((IGraphWorker)Actor1, 6L);
            ITmfVertex v2In = graph.createVertex((IGraphWorker)this.fActor2, 2L);
            ITmfVertex v2Fork = graph.createVertex((IGraphWorker)this.fActor2, 3L);
            ITmfVertex v2Return = graph.createVertex((IGraphWorker)this.fActor2, 4L);
            ITmfVertex v2End = graph.createVertex((IGraphWorker)this.fActor2, 5L);
            ITmfVertex v3In = graph.createVertex((IGraphWorker)this.fActor3, 3L);
            ITmfVertex v3End = graph.createVertex((IGraphWorker)this.fActor3, 4L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(v0Fork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v0Return);
            graph.append(graph.createVertex(Actor0, 7L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1In);
            graph.append(v1Fork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1Return);
            graph.append(v1End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2In);
            graph.append(v2Fork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2Return);
            graph.append(v2End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v3In);
            graph.append(v3End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0Fork, v1In);
            graph.edge(v1Fork, v2In);
            graph.edge(v2Fork, v3In);
            graph.edge(v3End, v2Return);
            graph.edge(v2End, v1Return);
            graph.edge(v1End, v0Return);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            return this.criticalPathBounded();
        }
    };
    public static final GraphBuilder GRAPH_NET1 = new GraphBuilder("wakeup_net1"){
        private TestGraphWorker fActor2 = new TestGraphWorker(2);
        private TestGraphWorker fActor3 = new TestGraphWorker(3);

        @Override
        public ITmfGraph build() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0Unblock = graph.createVertex(Actor0, 11L);
            ITmfVertex v1Send = graph.createVertex((IGraphWorker)Actor1, 4L);
            ITmfVertex v2Rcv = graph.createVertex((IGraphWorker)this.fActor2, 7L);
            ITmfVertex v2Send = graph.createVertex((IGraphWorker)this.fActor2, 8L);
            ITmfVertex v3Rcv = graph.createVertex((IGraphWorker)this.fActor3, 10L);
            ITmfVertex v3End = graph.createVertex((IGraphWorker)this.fActor3, 11L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(graph.createVertex(Actor0, 1L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v0Unblock, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.BLOCKED));
            graph.append(graph.createVertex(Actor0, 12L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(graph.createVertex((IGraphWorker)Actor1, 3L));
            graph.append(v1Send, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(graph.createVertex((IGraphWorker)Actor1, 5L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(graph.createVertex((IGraphWorker)this.fActor2, 6L));
            graph.append(v2Rcv, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v2Send, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(graph.createVertex((IGraphWorker)this.fActor3, 9L));
            graph.append(v3Rcv, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.append(v3End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v1Send, v2Rcv, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
            graph.edge(v2Send, v3Rcv, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
            graph.edge(v3End, v0Unblock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathBounded() {
            TmfGraphLegacyWrapper graph = new TmfGraphLegacyWrapper();
            ITmfVertex v0Fork = graph.createVertex(Actor0, 1L);
            ITmfVertex v0Unblock = graph.createVertex(Actor0, 11L);
            ITmfVertex v1Start = graph.createVertex((IGraphWorker)Actor1, 1L);
            ITmfVertex v1Send = graph.createVertex((IGraphWorker)Actor1, 4L);
            ITmfVertex v2Rcv = graph.createVertex((IGraphWorker)this.fActor2, 7L);
            ITmfVertex v2Send = graph.createVertex((IGraphWorker)this.fActor2, 8L);
            ITmfVertex v3Rcv = graph.createVertex((IGraphWorker)this.fActor3, 10L);
            ITmfVertex v3End = graph.createVertex((IGraphWorker)this.fActor3, 11L);
            graph.add(graph.createVertex(Actor0, 0L));
            graph.append(v0Fork, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v0Unblock);
            graph.append(graph.createVertex(Actor0, 12L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v1Start);
            graph.append(graph.createVertex((IGraphWorker)Actor1, 3L), (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.UNKNOWN));
            graph.append(v1Send, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v2Rcv);
            graph.append(v2Send, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.add(v3Rcv);
            graph.append(v3End, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
            graph.edge(v0Fork, v1Start);
            graph.edge(v1Send, v2Rcv, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
            graph.edge(v2Send, v3Rcv, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
            graph.edge(v3End, v0Unblock);
            return graph;
        }

        @Override
        public ITmfGraph criticalPathUnbounded() {
            throw new UnsupportedOperationException();
        }
    };
}

