/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.graph.IEdgeContextStateFactory;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfEdge;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfVertex;

public abstract class TmfEdgeInterval
implements IHTInterval {
    private final long fStart;
    protected long fEnd;
    private int fWorkerId;

    public static final TmfEdgeInterval readBuffer(ISafeByteBufferReader buffer, IEdgeContextStateFactory contextStateFactory) {
        byte b = buffer.get();
        switch (b) {
            case 0: {
                return new TmfNullEdgeInterval(buffer.getLong(), buffer.getLong(), buffer.getInt());
            }
            case 1: {
                return new TmfHorizontalEdgeInterval(buffer.getLong(), buffer.getLong(), buffer.getInt(), contextStateFactory.createContextState(buffer.getInt()), buffer.getString());
            }
            case 2: {
                return new TmfVerticalEdgeInterval(buffer.getLong(), buffer.getLong(), buffer.getInt(), buffer.getInt(), contextStateFactory.createContextState(buffer.getInt()), buffer.getString());
            }
            case 3: {
                return new TmfFillerInterval(buffer.getLong(), buffer.getLong(), buffer.getInt());
            }
        }
        throw new IllegalArgumentException("Type of data " + b + " cannot be read");
    }

    public static TmfEdgeInterval nullEdge(TmfVertex vertexFrom, TmfVertex vertexTo) {
        return new TmfNullEdgeInterval(vertexFrom.getTimestamp(), vertexTo.getTimestamp(), vertexFrom.getWorkerId());
    }

    public static TmfEdgeInterval horizontalEdge(TmfVertex vertexFrom, TmfVertex vertexTo, ITmfEdgeContextState contextState, @Nullable String edgeQualifier) {
        return new TmfHorizontalEdgeInterval(vertexFrom.getTimestamp(), vertexTo.getTimestamp(), vertexFrom.getWorkerId(), contextState, edgeQualifier);
    }

    public static TmfEdgeInterval verticalEdge(TmfVertex vertexFrom, TmfVertex vertexTo, ITmfEdgeContextState contextState, @Nullable String edgeQualifier) {
        return new TmfVerticalEdgeInterval(vertexFrom.getTimestamp(), vertexTo.getTimestamp(), vertexFrom.getWorkerId(), vertexTo.getWorkerId(), contextState, edgeQualifier);
    }

    public static TmfEdgeInterval fillerEdge(TmfVertex vertex, long otherTime) {
        return new TmfFillerInterval(Math.min(vertex.getTimestamp(), otherTime), Math.max(vertex.getTimestamp(), otherTime), vertex.getWorkerId());
    }

    protected TmfEdgeInterval(long start, long end, int workerId) {
        this.fStart = start;
        this.fEnd = end;
        this.fWorkerId = workerId;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public abstract @Nullable TmfEdge getEdge();

    public abstract EdgeIntervalType getIntervalType();

    public int getFromWorkerId() {
        return this.fWorkerId;
    }

    public int getToWorkerId() {
        return this.fWorkerId;
    }

    public ITmfVertex getVertexFrom() {
        return new TmfVertex(this.getStart(), this.getFromWorkerId());
    }

    public ITmfVertex getVertexTo() {
        return new TmfVertex(this.getEnd(), this.getToWorkerId());
    }

    protected abstract void updateVertexTo(TmfVertex var1);

    static enum EdgeIntervalType {
        NULL,
        VERTICAL,
        HORIZONTAL,
        FILLER;

    }

    private static class TmfFillerInterval
    extends TmfEdgeInterval {
        public TmfFillerInterval(long start, long end, int attribute) {
            super(start, end, attribute);
        }

        public int getSizeOnDisk() {
            return 21;
        }

        public void writeSegment(ISafeByteBufferWriter buffer) {
            buffer.put((byte)3);
            buffer.putLong(this.getStart());
            buffer.putLong(this.getEnd());
            buffer.putInt(this.getFromWorkerId());
        }

        @Override
        public @Nullable TmfEdge getEdge() {
            return null;
        }

        @Override
        public EdgeIntervalType getIntervalType() {
            return EdgeIntervalType.FILLER;
        }

        @Override
        protected void updateVertexTo(TmfVertex vertexTo) {
            throw new IllegalArgumentException("Can't update a filler edge.");
        }

        public String toString() {
            return "Start or end filler edge [" + this.getStart() + "," + this.getEnd() + "] for " + this.getFromWorkerId();
        }
    }

    private static class TmfHorizontalEdgeInterval
    extends TmfEdgeInterval {
        protected final ITmfEdgeContextState fContextState;
        protected final @Nullable String fQualifier;

        public TmfHorizontalEdgeInterval(long start, long end, int attributeFrom, ITmfEdgeContextState contextState, @Nullable String linkQualifier) {
            super(start, end, attributeFrom);
            this.fContextState = contextState;
            this.fQualifier = linkQualifier;
        }

        public int getSizeOnDisk() {
            return 25 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.getQualifier());
        }

        protected String getQualifier() {
            String linkQualifier = this.fQualifier;
            return linkQualifier == null ? "" : linkQualifier;
        }

        public void writeSegment(ISafeByteBufferWriter buffer) {
            buffer.put((byte)1);
            buffer.putLong(this.getStart());
            buffer.putLong(this.getEnd());
            buffer.putInt(this.getFromWorkerId());
            buffer.putInt(this.fContextState.serialize());
            buffer.putString(this.getQualifier());
        }

        @Override
        public @Nullable TmfEdge getEdge() {
            String qualifier = this.fQualifier;
            TmfVertex fromVertex = new TmfVertex(this.getStart(), this.getFromWorkerId());
            TmfVertex toVertex = new TmfVertex(this.getEnd(), this.getToWorkerId());
            return qualifier == null || qualifier.isEmpty() ? new TmfEdge(fromVertex, toVertex, this.fContextState) : new TmfEdge(fromVertex, toVertex, this.fContextState, qualifier);
        }

        @Override
        public EdgeIntervalType getIntervalType() {
            return EdgeIntervalType.HORIZONTAL;
        }

        @Override
        protected void updateVertexTo(TmfVertex vertexTo) {
            if (vertexTo.getWorkerId() != this.getFromWorkerId()) {
                throw new IllegalArgumentException("Can't update end vertex to another attribute, the edge is not horizontal anymore");
            }
            this.fEnd = vertexTo.getTimestamp();
        }

        public String toString() {
            return "Horizontal edge [" + this.getStart() + "," + this.getEnd() + "] from " + this.getFromWorkerId() + ": " + String.valueOf(this.fContextState) + (String)(this.fQualifier != null ? "(" + this.fQualifier + ")" : "");
        }
    }

    private static class TmfNullEdgeInterval
    extends TmfEdgeInterval {
        public TmfNullEdgeInterval(long start, long end, int attribute) {
            super(start, end, attribute);
        }

        public int getSizeOnDisk() {
            return 21;
        }

        public void writeSegment(ISafeByteBufferWriter buffer) {
            buffer.put((byte)0);
            buffer.putLong(this.getStart());
            buffer.putLong(this.getEnd());
            buffer.putInt(this.getFromWorkerId());
        }

        @Override
        public @Nullable TmfEdge getEdge() {
            return null;
        }

        @Override
        public EdgeIntervalType getIntervalType() {
            return EdgeIntervalType.NULL;
        }

        @Override
        protected void updateVertexTo(TmfVertex vertexTo) {
            throw new IllegalArgumentException("Can't update a null edge");
        }

        public String toString() {
            return "Null edge [" + this.getStart() + "," + this.getEnd() + "] for " + this.getFromWorkerId();
        }
    }

    private static class TmfVerticalEdgeInterval
    extends TmfHorizontalEdgeInterval {
        private int fAttributeTo;

        public TmfVerticalEdgeInterval(long start, long end, int attributeFrom, int attributeTo, ITmfEdgeContextState contextState, @Nullable String linkQualifier) {
            super(start, end, attributeFrom, contextState, linkQualifier);
            this.fAttributeTo = attributeTo;
        }

        @Override
        public int getSizeOnDisk() {
            return 29 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.getQualifier());
        }

        @Override
        public void writeSegment(ISafeByteBufferWriter buffer) {
            buffer.put((byte)2);
            buffer.putLong(this.getStart());
            buffer.putLong(this.getEnd());
            buffer.putInt(this.getFromWorkerId());
            buffer.putInt(this.fAttributeTo);
            buffer.putInt(this.fContextState.serialize());
            buffer.putString(this.getQualifier());
        }

        @Override
        public EdgeIntervalType getIntervalType() {
            return EdgeIntervalType.VERTICAL;
        }

        @Override
        public int getToWorkerId() {
            return this.fAttributeTo;
        }

        @Override
        protected void updateVertexTo(TmfVertex vertexTo) {
            this.fEnd = vertexTo.getTimestamp();
            this.fAttributeTo = vertexTo.getWorkerId();
        }

        @Override
        public String toString() {
            return "Vertical edge [" + this.getStart() + "," + this.getEnd() + "] from " + this.getFromWorkerId() + " to " + this.getToWorkerId() + ": " + String.valueOf(this.fContextState) + (String)(this.fQualifier != null ? "(" + this.fQualifier + ")" : "");
        }
    }
}

