/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics;

import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvAction;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public abstract class AbstractSegmentsStatisticsView
extends TmfView {
    private final Action fExportAction = new ExportToTsvAction(){

        protected void exportToTsv(@Nullable OutputStream stream) {
            AbstractSegmentsStatisticsView.this.exportToTsv(stream);
        }

        protected @Nullable Shell getShell() {
            return AbstractSegmentsStatisticsView.this.getViewSite().getShell();
        }
    };
    private @Nullable AbstractTmfTreeViewer fStatsViewer = null;

    public AbstractSegmentsStatisticsView() {
        super("StatisticsView");
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        AbstractTmfTreeViewer statsViewer = this.createSegmentStoreStatisticsViewer((Composite)NonNullUtils.checkNotNull((Object)parent));
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            statsViewer.loadTrace(trace);
        }
        this.fStatsViewer = statsViewer;
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.fExportAction);
    }

    public void setFocus() {
        AbstractTmfTreeViewer statsViewer = this.fStatsViewer;
        if (statsViewer != null) {
            statsViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        AbstractTmfTreeViewer statsViewer = this.fStatsViewer;
        if (statsViewer != null) {
            statsViewer.dispose();
        }
    }

    protected abstract AbstractTmfTreeViewer createSegmentStoreStatisticsViewer(Composite var1);

    @VisibleForTesting
    protected void exportToTsv(@Nullable OutputStream stream) {
        AbstractTmfTreeViewer statsViewer = this.fStatsViewer;
        if (statsViewer == null) {
            return;
        }
        Tree tree = statsViewer.getTreeViewer().getTree();
        ExportToTsvUtils.exportTreeToTsv((Tree)tree, (OutputStream)stream);
    }
}

