/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.ContentTypeMatcher;
import org.eclipse.core.internal.content.ContentTypeVisitor;
import org.eclipse.core.internal.content.FileSpec;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.internal.content.LowLevelIOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.core.runtime.content.XMLRootElementContentDescriber;
import org.eclipse.core.runtime.content.XMLRootElementContentDescriber2;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;

public final class ContentTypeCatalog {
    private static final IContentType[] NO_CONTENT_TYPES = new IContentType[0];
    private final Map<ContentType, ContentType[]> allChildren = new HashMap<ContentType, ContentType[]>();
    private final Map<String, IContentType> contentTypes = new HashMap<String, IContentType>();
    private final Map<String, Set<ContentType>> fileExtensions = new HashMap<String, Set<ContentType>>();
    private final Map<String, Set<ContentType>> fileNames = new HashMap<String, Set<ContentType>>();
    private final Map<String, Pattern> compiledRegexps = new HashMap<String, Pattern>();
    private final Map<Pattern, String> initialPatternForRegexp = new HashMap<Pattern, String>();
    private final Map<Pattern, Set<ContentType>> fileRegexps = new HashMap<Pattern, Set<ContentType>>();
    private int generation;
    private ContentTypeManager manager;
    private final Comparator<IContentType> policyConstantGeneralIsBetter = (o1, o2) -> {
        ContentType type1 = (ContentType)o1;
        ContentType type2 = (ContentType)o2;
        int depthCriteria = type1.getDepth() - type2.getDepth();
        if (depthCriteria != 0) {
            return depthCriteria;
        }
        int priorityCriteria = type1.getPriority() - type2.getPriority();
        if (priorityCriteria != 0) {
            return -priorityCriteria;
        }
        return type1.getId().compareTo(type2.getId());
    };
    private Comparator<IContentType> policyConstantSpecificIsBetter = (o1, o2) -> {
        ContentType type1 = (ContentType)o1;
        ContentType type2 = (ContentType)o2;
        int depthCriteria = type1.getDepth() - type2.getDepth();
        if (depthCriteria != 0) {
            return -depthCriteria;
        }
        int priorityCriteria = type1.getPriority() - type2.getPriority();
        if (priorityCriteria != 0) {
            return -priorityCriteria;
        }
        return type1.getId().compareTo(type2.getId());
    };
    private Comparator<IContentType> policyGeneralIsBetter = (o1, o2) -> {
        ContentType type1 = (ContentType)o1;
        ContentType type2 = (ContentType)o2;
        int depthCriteria = type1.getDepth() - type2.getDepth();
        if (depthCriteria != 0) {
            return depthCriteria;
        }
        int priorityCriteria = type1.getPriority() - type2.getPriority();
        if (priorityCriteria != 0) {
            return -priorityCriteria;
        }
        return 0;
    };
    private Comparator<IContentType> policyLexicographical = (o1, o2) -> {
        ContentType type1 = (ContentType)o1;
        ContentType type2 = (ContentType)o2;
        return type1.getId().compareTo(type2.getId());
    };
    private Comparator<IContentType> policySpecificIsBetter = (o1, o2) -> {
        ContentType type1 = (ContentType)o1;
        ContentType type2 = (ContentType)o2;
        int depthCriteria = type1.getDepth() - type2.getDepth();
        if (depthCriteria != 0) {
            return -depthCriteria;
        }
        int priorityCriteria = type1.getPriority() - type2.getPriority();
        if (priorityCriteria != 0) {
            return -priorityCriteria;
        }
        return 0;
    };

    private static IContentType[] concat(IContentType[][] types) {
        int size = 0;
        IContentType[] nonEmptyOne = NO_CONTENT_TYPES;
        IContentType[][] iContentTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType[] array = iContentTypeArray[n2];
            size += array.length;
            if (array.length > 0) {
                nonEmptyOne = array;
            }
            ++n2;
        }
        if (nonEmptyOne.length == size) {
            return nonEmptyOne;
        }
        IContentType[] result = new IContentType[size];
        int currentIndex = 0;
        IContentType[][] iContentTypeArray2 = types;
        int n3 = types.length;
        int n4 = 0;
        while (n4 < n3) {
            IContentType[] array = iContentTypeArray2[n4];
            System.arraycopy(array, 0, result, currentIndex, array.length);
            currentIndex += array.length;
            ++n4;
        }
        return result;
    }

    public ContentTypeCatalog(ContentTypeManager manager, int generation) {
        this.manager = manager;
        this.generation = generation;
    }

    synchronized void addContentType(IContentType contentType) {
        this.contentTypes.put(contentType.getId(), contentType);
    }

    private IContentType[] applyPolicy(final IContentTypeManager.ISelectionPolicy policy, final IContentType[] candidates, final boolean fileName, final boolean contents) {
        final IContentType[][] result = new IContentType[][]{candidates};
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                result[0] = policy.select(candidates, fileName, contents);
            }
        });
        return result[0];
    }

    private void associate(ContentType contentType) {
        String[] builtInFilePatterns;
        String[] builtInFileExtensions;
        String[] builtInFileNames;
        String[] stringArray = builtInFileNames = contentType.getFileSpecs(6);
        int n = builtInFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String builtInFileName = stringArray[n2];
            this.associate(contentType, builtInFileName, 4);
            ++n2;
        }
        String[] stringArray2 = builtInFileExtensions = contentType.getFileSpecs(10);
        int n3 = builtInFileExtensions.length;
        n = 0;
        while (n < n3) {
            String builtInFileExtension = stringArray2[n];
            this.associate(contentType, builtInFileExtension, 8);
            ++n;
        }
        String[] stringArray3 = builtInFilePatterns = contentType.getFileSpecs(18);
        int n4 = builtInFilePatterns.length;
        n3 = 0;
        while (n3 < n4) {
            String builtInFilePattern = stringArray3[n3];
            this.associate(contentType, builtInFilePattern, 16);
            ++n3;
        }
    }

    String toRegexp(String filePattern) {
        return filePattern.replace(".", "\\.").replace('?', '.').replace("*", ".*");
    }

    synchronized void associate(ContentType contentType, String text, int type) {
        Map<String, Set<ContentType>> fileSpecMap = null;
        if ((type & 4) != 0) {
            fileSpecMap = this.fileNames;
        } else if ((type & 8) != 0) {
            fileSpecMap = this.fileExtensions;
        }
        if (fileSpecMap != null) {
            String mappingKey = FileSpec.getMappingKeyFor(text);
            Set<ContentType> existing = fileSpecMap.get(mappingKey);
            if (existing == null) {
                existing = new HashSet<ContentType>();
                fileSpecMap.put(mappingKey, existing);
            }
            existing.add(contentType);
        } else if ((type & 0x10) != 0) {
            Pattern compiledPattern = this.compiledRegexps.get(text);
            if (compiledPattern == null) {
                compiledPattern = Pattern.compile(this.toRegexp(text));
                this.compiledRegexps.put(text, compiledPattern);
                this.initialPatternForRegexp.put(compiledPattern, text);
                this.fileRegexps.put(compiledPattern, new HashSet());
            }
            this.fileRegexps.get(compiledPattern).add(contentType);
        }
    }

    private int collectMatchingByContents(int valid, IContentType[] subset, List<ContentType> destination, ILazySource contents, Map<String, Object> properties) throws IOException {
        IContentType[] iContentTypeArray = subset;
        int n = subset.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType element = iContentTypeArray[n2];
            ContentType current = (ContentType)element;
            IContentDescriber describer = current.getDescriber();
            int status = 1;
            if (describer == null || (!contents.isText() || describer instanceof ITextContentDescriber) && (status = this.describe(current, contents, null, properties)) != 0) {
                if (status == 2) {
                    destination.add(valid++, current);
                } else {
                    destination.add(current);
                }
            }
            ++n2;
        }
        return valid;
    }

    int describe(ContentType type, ILazySource contents, ContentDescription description, Map<String, Object> properties) throws IOException {
        IContentDescriber describer = type.getDescriber();
        try {
            if (contents.isText()) {
                if (describer instanceof XMLRootElementContentDescriber2) {
                    int n = ((XMLRootElementContentDescriber2)describer).describe((Reader)((Object)contents), (IContentDescription)description, properties);
                    return n;
                }
                if (describer instanceof XMLRootElementContentDescriber) {
                    int n = ((XMLRootElementContentDescriber)describer).describe((Reader)((Object)contents), (IContentDescription)description, properties);
                    return n;
                }
                int n = ((ITextContentDescriber)describer).describe((Reader)((Object)contents), (IContentDescription)description);
                return n;
            }
            if (describer instanceof XMLRootElementContentDescriber2) {
                int n = ((XMLRootElementContentDescriber2)describer).describe((InputStream)((Object)contents), (IContentDescription)description, properties);
                return n;
            }
            if (describer instanceof XMLRootElementContentDescriber) {
                int n = ((XMLRootElementContentDescriber)describer).describe((InputStream)((Object)contents), (IContentDescription)description, properties);
                return n;
            }
            int n = describer.describe((InputStream)((Object)contents), description);
            return n;
        }
        catch (RuntimeException re) {
            type.invalidateDescriber(re);
        }
        catch (Error e) {
            type.invalidateDescriber(e);
            throw e;
        }
        catch (LowLevelIOException llioe) {
            throw llioe.getActualException();
        }
        catch (IOException ioe) {
            String message = NLS.bind((String)ContentMessages.content_errorReadingContents, (Object)type.getId());
            ContentType.log(message, ioe);
            return 1;
        }
        finally {
            contents.rewind();
        }
        return 0;
    }

    synchronized void dissociate(ContentType contentType, String text, int type) {
        String mappingKey;
        Map<String, Set<ContentType>> fileSpecMap = (type & 4) != 0 ? this.fileNames : this.fileExtensions;
        Set<ContentType> existing = fileSpecMap.get(mappingKey = FileSpec.getMappingKeyFor(text));
        if (existing == null) {
            return;
        }
        existing.remove(contentType);
    }

    private boolean ensureValid(ContentType type) {
        if (type.getValidation() != 0) {
            return type.isValid();
        }
        type.setValidation((byte)2);
        if (type.isAlias()) {
            return false;
        }
        ContentType baseType = null;
        if (type.getBaseTypeId() != null) {
            baseType = (ContentType)this.contentTypes.get(type.getBaseTypeId());
            if (baseType == null) {
                return false;
            }
            baseType = baseType.getAliasTarget(true);
            this.ensureValid(baseType);
            if (baseType.getValidation() != 1) {
                return false;
            }
        }
        type.setValidation((byte)1);
        type.setBaseType(baseType);
        return true;
    }

    IContentType[] findContentTypesFor(ContentTypeMatcher matcher, InputStream contents, String fileName) throws IOException {
        ILazySource buffer = ContentTypeManager.readBuffer(contents);
        IContentType[] selected = this.internalFindContentTypesFor(matcher, buffer, fileName, true);
        IContentTypeManager.ISelectionPolicy policy = matcher.getPolicy();
        if (policy != null) {
            selected = this.applyPolicy(policy, selected, fileName != null, true);
        }
        return selected;
    }

    IContentType[] findContentTypesFor(ContentTypeMatcher matcher, String fileName) {
        IContentType[] selected = ContentTypeCatalog.concat(this.internalFindContentTypesFor(matcher, fileName, this.policyConstantGeneralIsBetter));
        IContentTypeManager.ISelectionPolicy policy = matcher.getPolicy();
        if (policy != null) {
            selected = this.applyPolicy(policy, selected, true, false);
        }
        return selected;
    }

    public synchronized IContentType[] getAllContentTypes() {
        ArrayList<ContentType> result = new ArrayList<ContentType>(this.contentTypes.size());
        for (IContentType iContentType : this.contentTypes.values()) {
            ContentType type = (ContentType)iContentType;
            if (!type.isValid() || type.isAlias()) continue;
            result.add(type);
        }
        return result.toArray(new IContentType[result.size()]);
    }

    private ContentType[] getChildren(ContentType parent) {
        ContentType[] children = this.allChildren.get(parent);
        if (children != null) {
            return children;
        }
        ArrayList<ContentType> result = new ArrayList<ContentType>(5);
        for (IContentType iContentType : this.contentTypes.values()) {
            ContentType next = (ContentType)iContentType;
            if (next.getBaseType() != parent) continue;
            result.add(next);
        }
        children = result.toArray(new ContentType[result.size()]);
        this.allChildren.put(parent, children);
        return children;
    }

    public ContentType getContentType(String contentTypeIdentifier) {
        ContentType type = this.internalGetContentType(contentTypeIdentifier);
        return type != null && type.isValid() && !type.isAlias() ? type : null;
    }

    private IContentDescription getDescriptionFor(ContentTypeMatcher matcher, ILazySource contents, String fileName, QualifiedName[] options) throws IOException {
        IContentType[] selected = this.internalFindContentTypesFor(matcher, contents, fileName, false);
        if (selected.length == 0) {
            return null;
        }
        IContentTypeManager.ISelectionPolicy policy = matcher.getPolicy();
        if (policy != null && (selected = this.applyPolicy(policy, selected, fileName != null, true)).length == 0) {
            return null;
        }
        return matcher.getSpecificDescription(((ContentType)selected[0]).internalGetDescriptionFor(contents, options));
    }

    public IContentDescription getDescriptionFor(ContentTypeMatcher matcher, InputStream contents, String fileName, QualifiedName[] options) throws IOException {
        return this.getDescriptionFor(matcher, ContentTypeManager.readBuffer(contents), fileName, options);
    }

    public IContentDescription getDescriptionFor(ContentTypeMatcher matcher, Reader contents, String fileName, QualifiedName[] options) throws IOException {
        return this.getDescriptionFor(matcher, ContentTypeManager.readBuffer(contents), fileName, options);
    }

    public int getGeneration() {
        return this.generation;
    }

    public ContentTypeManager getManager() {
        return this.manager;
    }

    private boolean internalAccept(ContentTypeVisitor visitor, ContentType root) {
        if (!root.isValid() || root.isAlias()) {
            return true;
        }
        int result = visitor.visit(root);
        switch (result) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        ContentType[] children = this.getChildren(root);
        if (children == null) {
            return true;
        }
        ContentType[] contentTypeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ContentType c = contentTypeArray[n2];
            if (!this.internalAccept(visitor, c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private IContentType[] internalFindContentTypesFor(ILazySource buffer, IContentType[][] subset, Comparator<IContentType> validPolicy, Comparator<IContentType> indeterminatePolicy) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<ContentType> appropriate = new ArrayList<ContentType>(5);
        int validFullName = this.collectMatchingByContents(0, subset[0], appropriate, buffer, properties);
        int appropriateFullName = appropriate.size();
        int validExtension = this.collectMatchingByContents(validFullName, subset[1], appropriate, buffer, properties) - validFullName;
        int appropriateExtension = appropriate.size() - appropriateFullName;
        int validPattern = this.collectMatchingByContents(validExtension, subset[2], appropriate, buffer, properties) - validExtension;
        int appropriatePattern = appropriate.size() - appropriateFullName - appropriateExtension;
        IContentType[] result = appropriate.toArray(new IContentType[appropriate.size()]);
        if (validFullName > 1) {
            Arrays.sort(result, 0, validFullName, validPolicy);
        }
        if (validExtension > 1) {
            Arrays.sort(result, validFullName, validFullName + validExtension, validPolicy);
        }
        if (validPattern > 1) {
            Arrays.sort(result, validFullName + validExtension, validFullName + validExtension + validPattern, validPolicy);
        }
        if (appropriateFullName - validFullName > 1) {
            Arrays.sort(result, validFullName + validExtension, appropriateFullName + validExtension, indeterminatePolicy);
        }
        if (appropriateExtension - validExtension > 1) {
            Arrays.sort(result, appropriateFullName + validExtension, appropriate.size() - validPattern, indeterminatePolicy);
        }
        if (appropriatePattern - validPattern > 1) {
            Arrays.sort(result, appropriate.size() - validPattern, appropriate.size(), indeterminatePolicy);
        }
        return result;
    }

    private IContentType[] internalFindContentTypesFor(ContentTypeMatcher matcher, ILazySource buffer, String fileName, boolean forceValidation) throws IOException {
        Comparator<IContentType> validPolicy;
        Comparator<IContentType> indeterminatePolicy;
        IContentType[][] subset;
        if (fileName == null) {
            subset = new IContentType[][]{this.getAllContentTypes(), NO_CONTENT_TYPES, NO_CONTENT_TYPES};
            indeterminatePolicy = this.policyConstantGeneralIsBetter;
            validPolicy = this.policyConstantSpecificIsBetter;
        } else {
            subset = this.internalFindContentTypesFor(matcher, fileName, this.policyLexicographical);
            indeterminatePolicy = this.policyGeneralIsBetter;
            validPolicy = this.policySpecificIsBetter;
        }
        int total = subset[0].length + subset[1].length + subset[2].length;
        if (total == 0) {
            return NO_CONTENT_TYPES;
        }
        if (!forceValidation && total == 1) {
            IContentType[] found;
            IContentType[] iContentTypeArray = subset[0].length == 1 ? subset[0] : (found = subset[1].length == 1 ? subset[1] : subset[2]);
            if (!buffer.isText()) {
                return found;
            }
            IContentDescriber describer = ((ContentType)found[0]).getDescriber();
            if (describer == null || describer instanceof ITextContentDescriber) {
                return found;
            }
            return NO_CONTENT_TYPES;
        }
        return this.internalFindContentTypesFor(buffer, subset, validPolicy, indeterminatePolicy);
    }

    private synchronized IContentType[][] internalFindContentTypesFor(ContentTypeMatcher matcher, String fileName, Comparator<IContentType> sortingPolicy) {
        Set<ContentType> allByFilePattern;
        String fileExtension;
        Set<ContentType> allByFileName;
        IScopeContext context = matcher.getContext();
        IContentType[][] result = new IContentType[][]{NO_CONTENT_TYPES, NO_CONTENT_TYPES, NO_CONTENT_TYPES};
        HashSet<ContentType> existing = new HashSet<ContentType>();
        if (context.equals(this.manager.getContext())) {
            allByFileName = this.getDirectlyAssociated(fileName, 4);
        } else {
            allByFileName = new HashSet<ContentType>(this.getDirectlyAssociated(fileName, 6));
            allByFileName.addAll(matcher.getDirectlyAssociated(this, fileName, 4));
        }
        Set<ContentType> selectedByName = this.selectMatchingByName(context, allByFileName, Collections.emptySet(), fileName, 4);
        existing.addAll(selectedByName);
        result[0] = selectedByName.toArray(new IContentType[selectedByName.size()]);
        if (result[0].length > 1) {
            Arrays.sort(result[0], sortingPolicy);
        }
        if ((fileExtension = ContentTypeManager.getFileExtension(fileName)) != null) {
            Set<ContentType> allByFileExtension;
            if (context.equals(this.manager.getContext())) {
                allByFileExtension = this.getDirectlyAssociated(fileExtension, 8);
            } else {
                allByFileExtension = new HashSet<ContentType>(this.getDirectlyAssociated(fileExtension, 10));
                allByFileExtension.addAll(matcher.getDirectlyAssociated(this, fileExtension, 8));
            }
            Set<ContentType> selectedByExtension = this.selectMatchingByName(context, allByFileExtension, selectedByName, fileExtension, 8);
            existing.addAll(selectedByExtension);
            if (!selectedByExtension.isEmpty()) {
                result[1] = selectedByExtension.toArray(new IContentType[selectedByExtension.size()]);
            }
        }
        if (result[1].length > 1) {
            Arrays.sort(result[1], sortingPolicy);
        }
        if (context.equals(this.manager.getContext())) {
            allByFilePattern = this.getMatchingRegexpAssociated(fileName, 16);
        } else {
            allByFilePattern = new HashSet<ContentType>(this.getMatchingRegexpAssociated(fileName, 18));
            allByFilePattern.addAll(matcher.getMatchingRegexpAssociated(this, fileName, 16));
        }
        existing.addAll(allByFilePattern);
        if (!allByFilePattern.isEmpty()) {
            result[2] = allByFilePattern.toArray(new IContentType[allByFilePattern.size()]);
        }
        return result;
    }

    private Set<ContentType> getMatchingRegexpAssociated(String fileName, int typeMask) {
        if ((typeMask & 0x10) == 0) {
            throw new IllegalArgumentException("This method requires FILE_PATTERN_SPEC.");
        }
        HashSet<ContentType> res = new HashSet<ContentType>();
        for (Map.Entry<Pattern, Set<ContentType>> spec : this.fileRegexps.entrySet()) {
            if (!spec.getKey().matcher(fileName).matches()) continue;
            res.addAll(this.filterOnDefinitionSource(this.initialPatternForRegexp.get(spec.getKey()), typeMask, spec.getValue()));
        }
        return res;
    }

    private Set<ContentType> getDirectlyAssociated(String text, int typeMask) {
        if ((typeMask & 0x10) != 0) {
            throw new IllegalArgumentException("This method don't allow FILE_REGEXP_SPEC.");
        }
        Map<String, Set<ContentType>> associations = (typeMask & 4) != 0 ? this.fileNames : this.fileExtensions;
        Set<ContentType> result = associations.get(FileSpec.getMappingKeyFor(text));
        if ((typeMask & 3) != 0) {
            result = this.filterOnDefinitionSource(text, typeMask, result);
        }
        return result == null ? Collections.EMPTY_SET : result;
    }

    private Set<ContentType> filterOnDefinitionSource(String text, int typeMask, Set<ContentType> contentTypes) {
        if ((typeMask & 3) == 0) {
            return contentTypes;
        }
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentTypes = new HashSet<ContentType>(contentTypes);
            typeMask ^= 3;
            Iterator<ContentType> i = contentTypes.iterator();
            while (i.hasNext()) {
                ContentType contentType = i.next();
                if (contentType.hasFileSpec(text, typeMask, true)) continue;
                i.remove();
            }
        }
        return contentTypes;
    }

    synchronized ContentType internalGetContentType(String contentTypeIdentifier) {
        return (ContentType)this.contentTypes.get(contentTypeIdentifier);
    }

    private void makeAliases() {
        for (IContentType iContentType : this.contentTypes.values()) {
            ContentType target;
            ContentType type = (ContentType)iContentType;
            String targetId = type.getAliasTargetId();
            if (targetId == null || (target = this.internalGetContentType(targetId)) == null) continue;
            type.setAliasTarget(target);
        }
    }

    protected synchronized void organize() {
        ContentType type;
        this.makeAliases();
        for (IContentType iContentType : this.contentTypes.values()) {
            type = (ContentType)iContentType;
            if (!this.ensureValid(type)) continue;
            this.associate(type);
        }
        if (ContentTypeManager.DebuggingHolder.DEBUGGING) {
            for (IContentType iContentType : this.contentTypes.values()) {
                type = (ContentType)iContentType;
                if (type.isValid()) continue;
                ContentMessages.message("Invalid: " + type);
            }
        }
    }

    private Set<ContentType> selectMatchingByName(final IScopeContext context, Collection<ContentType> source, final Collection<ContentType> existing, final String fileSpecText, final int fileSpecType) {
        if (source == null || source.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        final HashSet<ContentType> destination = new HashSet<ContentType>(5);
        for (final ContentType root : source) {
            this.internalAccept(new ContentTypeVisitor(){

                @Override
                public int visit(ContentType type) {
                    if (type != root && type.hasBuiltInAssociations()) {
                        return 1;
                    }
                    if (type == root && !type.hasFileSpec(context, fileSpecText, fileSpecType)) {
                        return 1;
                    }
                    if (!existing.contains(type)) {
                        destination.add(type);
                    }
                    return 0;
                }
            }, root);
        }
        return destination;
    }

    void removeContentType(String contentTypeIdentifier) throws CoreException {
        ContentType contentType = this.getContentType(contentTypeIdentifier);
        if (contentType == null) {
            return;
        }
        if (!contentType.isUserDefined()) {
            throw new IllegalArgumentException("Content type must be user-defined.");
        }
        this.contentTypes.remove(contentType.getId());
    }
}

