/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.impl.Claim;
import org.eclipse.trace4cps.core.impl.Dependency;
import org.eclipse.trace4cps.core.impl.Resource;
import org.eclipse.trace4cps.core.impl.Trace;
import org.eclipse.trace4cps.core.io.conv.Attribute;
import org.eclipse.trace4cps.core.io.conv.ClaimType;
import org.eclipse.trace4cps.core.io.conv.Configuration;
import org.eclipse.trace4cps.core.io.conv.DependencyType;
import org.eclipse.trace4cps.core.io.conv.ESIFormatParser;
import org.eclipse.trace4cps.core.io.conv.LimitationsType;
import org.eclipse.trace4cps.core.io.conv.ParserException;

public class ESIFormatTraceParser
extends ESIFormatParser {
    protected static final String FORMAT_VERSION = "V0.1";
    protected static final String TRACEFORMATVERSION_TAG = "TraceFormatVersion";
    protected static final String TRACEVERSION_TAG = "TraceVersion";
    protected static final String TRACENAME_TAG = "TraceName";
    protected static final String TRACEABSOLUTESTARTTIME_TAG = "TraceAbsoluteStartTime";
    protected static final String TRACESTARTTIME_TAG = "TraceStartTime";
    protected static final String RESOURCE_TAG = "R";
    protected static final String CLAIM_TAG = "C";
    protected static final String DEPENDENCY_TAG = "D";
    protected HashMap<Integer, Resource> idResourceMap = new HashMap();
    protected HashMap<Integer, Claim> idClaimMap = new HashMap();
    private Set<Resource> resourceFullInstances = new HashSet<Resource>();
    private Map<Resource, Double> resourceOffsets = new HashMap<Resource, Double>();
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$ClaimType;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$DependencyType;

    private Resource getResource(Integer aId) {
        return this.idResourceMap.get(aId);
    }

    private void addResource(Resource r, int id) {
        this.idResourceMap.put(id, r);
    }

    protected boolean addClaim(Trace aTrace, Integer aId, Claim aClaim) {
        boolean result = false;
        if (!this.idClaimMap.containsKey(aId)) {
            aTrace.add(aClaim);
            this.idClaimMap.put(aId, aClaim);
            result = true;
        }
        return result;
    }

    protected Claim getClaim(Integer aId) {
        return this.idClaimMap.get(aId);
    }

    protected void addDependency(Trace aTrace, Dependency aDependency) {
        aTrace.add(aDependency);
    }

    public Trace parseTraceV0(File traceFile, Configuration aConfig) throws IOException, ParserException {
        Trace trace = new Trace();
        trace.setTimeUnit(aConfig.getTimeScaleUnit());
        trace.setOffset(0L);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream in = new FileInputStream(traceFile);){
            this.parse(traceFile.getAbsolutePath(), in, aConfig, trace);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return trace;
    }

    private double getTimeMultiplier(Configuration aConfig) {
        return Math.pow(10.0, aConfig.getTimeScaleShift());
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(String src, FileInputStream in, Configuration aConfig, Trace aTrace) throws IOException, ParserException {
        PARSE_TIME_MULTIPLIER = this.getTimeMultiplier(aConfig);
        n_TRACEVERSION = 0;
        n_CONFIGURATIONID = 0;
        n_TRACENAME = 0;
        n_TRACESTARTTIME = 0;
        var11_10 = null;
        var12_12 = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in));
            try {
                line = null;
                linenr = 0;
                while (n_TRACEVERSION == 0 && (line = reader.readLine()) != null) {
                    ++linenr;
                    tok = line.split("\t", -1);
                    if (tok.length < 2) continue;
                    var17_18 = tok[0];
                    tmp = -1;
                    switch (var17_18.hashCode()) {
                        case 779161587: {
                            if (!var17_18.equals("TraceVersion")) break;
                            tmp = 1;
                            break;
                        }
                        case 1463688124: {
                            if (!var17_18.equals("TraceFormatVersion")) break;
                            tmp = 2;
                            break;
                        }
                    }
                    switch (tmp) {
                        case 2: {
                            System.err.println("TraceFormatVersion is deprecated; use TraceVersion instead");
                        }
                        case 1: {
                            if (!tok[1].equalsIgnoreCase("V0.1")) {
                                throw new ParserException("Trace version not supported " + tok[1], src, linenr);
                            }
                            ++n_TRACEVERSION;
                            break;
                        }
                        default: {
                            throw new ParserException("Trace version missing as first element", src, linenr);
                        }
                    }
                }
                while ((line = reader.readLine()) != null) {
                    block84: while (true) {
                        ++linenr;
                        tok = line.split("\t", -1);
                        if (tok.length < 2) ** GOTO lbl357
                        contextId = 0;
                        context = null;
                        var20_24 = tok[0];
                        tmp = -1;
                        switch (var20_24.hashCode()) {
                            case -1566911152: {
                                if (!var20_24.equals("TraceName")) break;
                                tmp = 1;
                                break;
                            }
                            case -1324359693: {
                                if (!var20_24.equals("TraceAbsoluteStartTime")) break;
                                tmp = 2;
                                break;
                            }
                            case 67: {
                                if (!var20_24.equals("C")) break;
                                tmp = 3;
                                break;
                            }
                            case 68: {
                                if (!var20_24.equals("D")) break;
                                tmp = 4;
                                break;
                            }
                            case 82: {
                                if (!var20_24.equals("R")) break;
                                tmp = 5;
                                break;
                            }
                            case 129138833: {
                                if (!var20_24.equals("ConfigurationSource")) break;
                                tmp = 6;
                                break;
                            }
                            case 727786154: {
                                if (!var20_24.equals("TraceStartTime")) break;
                                tmp = 7;
                                break;
                            }
                            case 951898225: {
                                if (!var20_24.equals("ConfigurationID")) break;
                                tmp = 8;
                                break;
                            }
                        }
                        switch (tmp) {
                            case 8: {
                                if (n_CONFIGURATIONID > 0) {
                                    throw new ParserException("ConfigurationID allready declared", src, linenr);
                                }
                                if (!aConfig.getConfigurationID().equalsIgnoreCase(tok[1])) {
                                    throw new ParserException("The Configuration required is notequal to actual Configuration", src, linenr);
                                }
                                ++n_CONFIGURATIONID;
                                break block84;
                            }
                            case 1: {
                                if (n_TRACENAME > 0) {
                                    throw new ParserException("Trace name already declared", src, linenr);
                                }
                                aTrace.setAttribute("TraceName", tok[1]);
                                ++n_TRACENAME;
                                break block84;
                            }
                            case 2: {
                                System.err.println("TraceAbsoluteStartTime is deprecated; use TraceStartTime instead");
                            }
                            case 7: {
                                if (n_TRACESTARTTIME > 0) {
                                    throw new ParserException("TraceStartTime already declared", src, linenr);
                                }
                                ++n_TRACESTARTTIME;
                                break block84;
                            }
                            case 5: {
                                index = 1;
                                try {
                                    rid = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("ResourceID has illegal value " + tok[index], src, linenr);
                                }
                                if (this.idResourceMap.containsKey(rid)) {
                                    throw new ParserException("Resource(ID) already exists " + tok[index], src, linenr);
                                }
                                if (tok.length <= ++index) {
                                    throw new ParserException("Resource Capacity expected for resource id " + rid, src, linenr);
                                }
                                try {
                                    capacity = Double.parseDouble(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Resource Capacity has illegal value " + tok[index], src, linenr);
                                }
                                if (tok.length <= ++index) {
                                    throw new ParserException("Resource Unit expected for resource id " + rid, src, linenr);
                                }
                                unit = tok[index];
                                if (tok.length <= ++index) {
                                    throw new ParserException("Claim type expected for resource id " + rid, src, linenr);
                                }
                                resource = null;
                                try {
                                    ict = Integer.parseInt(tok[index]);
                                    claimtype = ClaimType.get(ict);
                                    if (claimtype == null) {
                                        throw new ParserException("Claim type has unknown value " + tok[index], src, linenr);
                                    }
                                    switch (ESIFormatTraceParser.$SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$ClaimType()[claimtype.ordinal()]) {
                                        case 1: {
                                            resource = new Resource(1, false);
                                            this.resourceFullInstances.add(resource);
                                            break;
                                        }
                                        case 2: {
                                            resource = new Resource(capacity, false);
                                            break;
                                        }
                                        case 3: {
                                            resource = new Resource(capacity, true);
                                            if (tok.length <= ++index) {
                                                throw new ParserException("ResourceOffset expected for resource id " + rid, src, linenr);
                                            }
                                            try {
                                                offset = Double.parseDouble(tok[index]);
                                                this.resourceOffsets.put(resource, offset);
                                                break;
                                            }
                                            catch (NumberFormatException e) {
                                                throw new ParserException("ResourceOffset has illegal value " + tok[index], src, linenr);
                                            }
                                        }
                                    }
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("ClaimType has illegal value " + tok[index], src, linenr);
                                }
                                resource.setAttribute("unit", unit);
                                if (tok.length <= ++index) {
                                    throw new ParserException("Context expected for resource id " + rid, src, linenr);
                                }
                                try {
                                    contextId = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Context has illegal value " + tok[index], src, linenr);
                                }
                                context = aConfig.getContext(contextId);
                                if (context == null) {
                                    throw new ParserException("Resource context not defined in configuration: " + tok[index], src, linenr);
                                }
                                if (tok.length <= index + context.getAttributes().size()) {
                                    throw new ParserException("Invalid number of context arguments: " + context.getContextName(), src, linenr);
                                }
                                claimtype = context.getAttributes().iterator();
                                while (true) {
                                    if (!claimtype.hasNext()) {
                                        this.addResource(resource, rid);
                                        break block84;
                                    }
                                    att = (Attribute)claimtype.next();
                                    resource.setAttribute(att.getAttributeName(), tok[++index]);
                                }
                            }
                            case 3: {
                                index = 1;
                                try {
                                    cid = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("ClaimID has illegal value " + tok[index], src, linenr);
                                }
                                if (this.idClaimMap.containsKey(cid)) {
                                    throw new ParserException("Claim(ID) already exists " + tok[index], src, linenr);
                                }
                                if (tok.length <= ++index) {
                                    throw new ParserException("Resource expected for claim id " + cid, src, linenr);
                                }
                                claim = null;
                                try {
                                    rid = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("ResourceID has illegal value " + tok[index], src, linenr);
                                }
                                resource = this.getResource(rid);
                                if (resource == null) {
                                    throw new ParserException("Resource not known " + tok[index], src, linenr);
                                }
                                amount = NaN;
                                offset = NaN;
                                if (this.resourceFullInstances.contains(resource)) {
                                    amount = 1.0;
                                } else {
                                    if (!this.resourceOffsets.keySet().contains(resource)) {
                                        if (tok.length <= ++index) {
                                            throw new ParserException("Amount expected for claim id " + cid, src, linenr);
                                        }
                                        try {
                                            amount = Double.parseDouble(tok[index]);
                                        }
                                        catch (NumberFormatException e) {
                                            throw new ParserException("Amount has illegal value " + tok[index], src, linenr);
                                        }
                                    }
                                    if (tok.length <= ++index) {
                                        throw new ParserException("Amount expected for claim id " + cid, src, linenr);
                                    }
                                    try {
                                        amount = Double.parseDouble(tok[index]);
                                    }
                                    catch (NumberFormatException e) {
                                        throw new ParserException("Aount has illegal value " + tok[index], src, linenr);
                                    }
                                    if (tok.length <= ++index) {
                                        throw new ParserException("Offset expected for claim id " + cid, src, linenr);
                                    }
                                    try {
                                        offset = Double.parseDouble(tok[index]) + this.resourceOffsets.get(resource);
                                    }
                                    catch (NumberFormatException e) {
                                        throw new ParserException("Offset has illegal value " + tok[index], src, linenr);
                                    }
                                }
                                if (tok.length <= ++index) {
                                    throw new ParserException("Start time expected for claim id " + cid, src, linenr);
                                }
                                try {
                                    starttime = PARSE_TIME_MULTIPLIER * Double.parseDouble(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Start time has illegal value " + tok[index], src, linenr);
                                }
                                if (tok.length <= ++index) {
                                    throw new ParserException("Stop time expected for claim id " + cid, src, linenr);
                                }
                                try {
                                    stoptime = PARSE_TIME_MULTIPLIER * Double.parseDouble(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Stop time has illegal value " + tok[index], src, linenr);
                                }
                                if (starttime > stoptime) {
                                    throw new ParserException("Stop time is before start time for claim id " + cid, src, linenr);
                                }
                                claim = Double.isNaN(offset) != false ? new Claim(starttime, stoptime, resource, amount) : new Claim((Number)starttime, (Number)stoptime, (IResource)resource, (Number)offset, amount);
                                if (tok.length <= ++index) {
                                    throw new ParserException("Limitations type expected for claim id " + cid, src, linenr);
                                }
                                ilt = Integer.parseInt(tok[index]);
                                lt = LimitationsType.get(ilt);
                                if (lt == null) {
                                    throw new ParserException("Period limitations type has unknown value " + tok[index], src, linenr);
                                }
                                if (ilt == 0) ** GOTO lbl264
                                if ((ilt & 1) != 0 && tok.length <= ++index) {
                                    throw new ParserException("MinStarttime expected for claim id " + cid, src, linenr);
                                }
                                if ((ilt & 2) != 0 && tok.length <= ++index) {
                                    throw new ParserException("MaxStoptime expected for Claim id " + cid, src, linenr);
                                }
                                if ((ilt & 4) == 0) ** GOTO lbl264
                                if (tok.length <= ++index) {
                                    throw new ParserException("MaxDuration expected for claim id " + cid, src, linenr);
                                }
                                try {
                                    max_duration = Math.round(PARSE_TIME_MULTIPLIER * Double.parseDouble(tok[index]));
                                    if (max_duration < 0L) {
                                        throw new ParserException("Negative value for claim limitation MaxDuration is not allowed for claim id " + cid, src, linenr);
                                    }
                                    ** GOTO lbl264
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Claim limitation MaxDuration has illegal value " + tok[index], src, linenr);
                                }
                            }
                            catch (NumberFormatException e) {
                                throw new ParserException("Limitations type has illegal value " + tok[index], src, linenr);
                            }
lbl264:
                            // 3 sources

                            if (tok.length <= ++index) {
                                throw new ParserException("Context expected for claim id " + cid, src, linenr);
                            }
                            try {
                                contextId = Integer.parseInt(tok[index]);
                            }
                            catch (NumberFormatException e) {
                                throw new ParserException("Context has illegal value " + tok[index], src, linenr);
                            }
                            context = aConfig.getContext(contextId);
                            if (context == null) {
                                throw new ParserException("Claim context not defined in configuration: " + tok[index], src, linenr);
                            }
                            if (tok.length <= index + context.getAttributes().size()) {
                                throw new ParserException("Invalid number of context arguments: " + context.getContextName(), src, linenr);
                            }
                            lt = context.getAttributes().iterator();
                            while (true) {
                                if (!lt.hasNext()) {
                                    this.addClaim(aTrace, cid, claim);
                                    break block84;
                                }
                                att = (Attribute)lt.next();
                                claim.setAttribute(att.getAttributeName(), tok[++index]);
                            }
                            case 4: {
                                index = 1;
                                sourceId = 0;
                                try {
                                    sourceId = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Source ID has illegal value " + tok[index], src, linenr);
                                }
                                claim = this.getClaim(sourceId);
                                if (claim == null) {
                                    throw new ParserException("Source claim not known" + sourceId, src, linenr);
                                }
                                sinkId = 0;
                                if (tok.length <= ++index) {
                                    throw new ParserException("Sink ID expected ", src, linenr);
                                }
                                try {
                                    sinkId = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Sink ID has illegal value " + tok[index], src, linenr);
                                }
                                claim = this.getClaim(sinkId);
                                if (claim == null) {
                                    throw new ParserException("Sink claim not known" + sinkId, src, linenr);
                                }
                                if (tok.length <= ++index) {
                                    throw new ParserException("Dependency type expected ", src, linenr);
                                }
                                try {
                                    dependencyType = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Dependency type has illegal value " + tok[index], src, linenr);
                                }
                                dType = DependencyType.get(dependencyType);
                                if (dType == null) {
                                    throw new ParserException("Dependency type not known " + dependencyType, src, linenr);
                                }
                                if (tok.length <= ++index) {
                                    throw new ParserException("Context expected for dependency ", src, linenr);
                                }
                                try {
                                    contextId = Integer.parseInt(tok[index]);
                                }
                                catch (NumberFormatException e) {
                                    throw new ParserException("Context has illegal value " + tok[index], src, linenr);
                                }
                                context = aConfig.getContext(contextId);
                                if (context == null) {
                                    throw new ParserException("Dependency context not defined in configuration: " + tok[index], src, linenr);
                                }
                                if (tok.length <= index + context.getAttributes().size()) {
                                    throw new ParserException("Invalid number of context arguments: " + context.getContextName(), src, linenr);
                                }
                                srcClaim = this.getClaim(sourceId);
                                dstClaim = this.getClaim(sinkId);
                                dependency = null;
                                switch (ESIFormatTraceParser.$SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$DependencyType()[dType.ordinal()]) {
                                    case 3: {
                                        dependency = new Dependency(srcClaim.getStartEvent(), dstClaim.getStartEvent());
                                        break;
                                    }
                                    case 4: {
                                        dependency = new Dependency(srcClaim.getStartEvent(), dstClaim.getEndEvent());
                                        break;
                                    }
                                    case 1: {
                                        dependency = new Dependency(srcClaim.getEndEvent(), dstClaim.getStartEvent());
                                        break;
                                    }
                                    case 2: {
                                        dependency = new Dependency(srcClaim.getEndEvent(), dstClaim.getEndEvent());
                                        break;
                                    }
                                }
                                var44_69 = context.getAttributes().iterator();
                                while (true) {
                                    if (!var44_69.hasNext()) {
                                        this.addDependency(aTrace, dependency);
                                        break block84;
                                    }
                                    att = var44_69.next();
                                    dependency.setAttribute(att.getAttributeName(), tok[++index]);
                                }
                            }
                            default: {
                                throw new ParserException("Token not recognised " + tok[0], src, linenr);
                            }
                            case 6: {
                                if ((line = reader.readLine()) != null) continue block84;
                            }
lbl357:
                            // 1 sources

                            if (tok[0].isEmpty()) break block84;
                            throw new ParserException("Expected another token after " + tok[0], src, linenr);
                        }
                        break;
                    }
                }
                if (n_CONFIGURATIONID != 0) return;
                throw new ParserException("Missing required ConfigurationID", src, 0);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable var12_13) {
            if (var11_10 == null) {
                var11_10 = var12_13;
                throw var11_10;
            }
            if (var11_10 == var12_13) throw var11_10;
            var11_10.addSuppressed(var12_13);
            throw var11_10;
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$ClaimType() {
        if ($SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$ClaimType != null) {
            return $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$ClaimType;
        }
        int[] nArray = new int[ClaimType.values().length];
        try {
            nArray[ClaimType.AMOUNT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClaimType.AMOUNT_OFFSET.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClaimType.FULL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$ClaimType = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$DependencyType() {
        if ($SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$DependencyType != null) {
            return $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$DependencyType;
        }
        int[] nArray = new int[DependencyType.values().length];
        try {
            nArray[DependencyType.SOURCE_START2_SINK_START.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DependencyType.SOURCE_START2_SINK_STOP.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DependencyType.SOURCE_STOP2_SINK_START.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[DependencyType.SOURCE_STOP2_SINK_STOP.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$trace4cps$core$io$conv$DependencyType = nArray;
        return nArray;
    }
}

