/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDoc2HTMLTextReader;

abstract class AbstractJavaDocConverter {
    private CoreJavaDoc2HTMLTextReader reader;
    private boolean read;
    private String result;

    public AbstractJavaDocConverter(Reader reader) {
        this.setJavaDoc2HTMLTextReader(reader);
    }

    public AbstractJavaDocConverter(String javadoc) {
        this.setJavaDoc2HTMLTextReader(javadoc == null ? null : new StringReader(javadoc));
    }

    private void setJavaDoc2HTMLTextReader(Reader reader) {
        this.reader = reader == null || reader instanceof JdtLsJavaDoc2HTMLTextReader ? (JdtLsJavaDoc2HTMLTextReader)((Object)reader) : new JdtLsJavaDoc2HTMLTextReader(reader);
    }

    public String getAsString() throws IOException {
        if (!this.read && this.reader != null) {
            String rawHtml = this.reader.getString();
            this.result = this.convert(rawHtml);
        }
        return this.result;
    }

    abstract String convert(String var1);

    private static class JdtLsJavaDoc2HTMLTextReader
    extends CoreJavaDoc2HTMLTextReader {
        private int preTagDepth = 0;
        private int codeTagDepth = 0;
        private StringBuilder tagBuffer = new StringBuilder();
        private boolean inTag = false;
        private boolean checkNextChar = false;
        private char quoteChar = '\u0000';
        private boolean inComment = false;
        private StringBuilder commentBuffer = new StringBuilder();

        public JdtLsJavaDoc2HTMLTextReader(Reader reader) {
            super(reader);
        }

        protected String computeSubstitution(int c) throws IOException {
            if (this.inComment) {
                String last3;
                this.commentBuffer.append((char)c);
                if (this.commentBuffer.length() >= 3 && "-->".equals(last3 = this.commentBuffer.substring(this.commentBuffer.length() - 3))) {
                    this.inComment = false;
                    this.commentBuffer.setLength(0);
                }
                return super.computeSubstitution(c);
            }
            if (this.checkNextChar) {
                this.checkNextChar = false;
                if (c == 33) {
                    this.commentBuffer.setLength(0);
                    this.commentBuffer.append("<!");
                } else if (Character.isLetter((char)c) || c == 47) {
                    this.inTag = true;
                    this.quoteChar = '\u0000';
                    this.tagBuffer.setLength(0);
                    this.tagBuffer.append('<');
                    this.tagBuffer.append((char)c);
                }
            } else if (this.commentBuffer.length() > 0) {
                this.commentBuffer.append((char)c);
                if ("<!--".equals(this.commentBuffer.toString())) {
                    this.inComment = true;
                } else if (this.commentBuffer.length() >= 4 || c == 62) {
                    this.commentBuffer.setLength(0);
                }
            } else if (this.inTag) {
                this.tagBuffer.append((char)c);
                if (this.quoteChar == '\u0000' && (c == 34 || c == 39)) {
                    this.quoteChar = (char)c;
                } else if (c == this.quoteChar) {
                    this.quoteChar = '\u0000';
                } else if (c == 62 && this.quoteChar == '\u0000') {
                    this.inTag = false;
                    this.updateTagDepth(this.tagBuffer.toString().toLowerCase());
                }
            } else if (c == 60) {
                this.checkNextChar = true;
            }
            if (!(this.preTagDepth <= 0 && this.codeTagDepth <= 0 || c != 64 && c != 123)) {
                return null;
            }
            return super.computeSubstitution(c);
        }

        private void updateTagDepth(String tag) {
            if (tag.startsWith("<pre") && (tag.equals("<pre>") || tag.charAt(4) == ' ')) {
                ++this.preTagDepth;
            } else if (tag.equals("</pre>")) {
                this.preTagDepth = Math.max(0, this.preTagDepth - 1);
            } else if (tag.startsWith("<code") && (tag.equals("<code>") || tag.charAt(5) == ' ')) {
                ++this.codeTagDepth;
            } else if (tag.equals("</code>")) {
                this.codeTagDepth = Math.max(0, this.codeTagDepth - 1);
            }
        }

        protected String getPrintSingleDefinitionStartTags() {
            return "<li>";
        }

        protected String getPrintSingleDefinitionEndTags() {
            return "</li>";
        }

        protected void print(StringBuilder buffer, String tag, List<String> elements, boolean firstword) {
            if (!elements.isEmpty()) {
                buffer.append("<li><b>");
                buffer.append(tag);
                buffer.append("</b><ul>");
                this.printDefinitions(buffer, elements, firstword);
                buffer.append("</ul></li>");
            }
        }

        protected void print(StringBuilder buffer, String tag, String content) {
            if (content != null) {
                buffer.append("<li><b>");
                buffer.append(tag);
                buffer.append("</b><ul><li>");
                buffer.append(content);
                buffer.append("</li></ul></li>");
            }
        }

        protected void printRest(StringBuilder buffer, List<CoreJavaDoc2HTMLTextReader.Pair> rest) {
            if (!rest.isEmpty()) {
                for (CoreJavaDoc2HTMLTextReader.Pair p : rest) {
                    buffer.append("<li>");
                    if (p.fTag() != null) {
                        buffer.append(p.fTag());
                    }
                    if (p.fContent() != null) {
                        buffer.append("<ul><li>");
                        buffer.append(p.fContent());
                        buffer.append("</li></ul>");
                    }
                    buffer.append("</li>");
                }
            }
        }

        protected String printSimpleTag(List<CoreJavaDoc2HTMLTextReader.Pair> rest) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<ul>");
            this.printTagAttributes(buffer);
            this.printRest(buffer, rest);
            buffer.append("</ul>");
            return buffer.toString();
        }
    }
}

