/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin.dependency;

import com.microsoft.java.bs.gradle.model.GradleModuleDependency;
import com.microsoft.java.bs.gradle.model.impl.DefaultArtifact;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleModuleDependency;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.specs.Specs;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.gradle.util.GradleVersion;

public class DependencyCollector {
    private static final String UNKNOWN = "unknown";

    public static Set<GradleModuleDependency> getModuleDependencies(Project project, Set<String> configurationNames) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.0")) < 0) {
            try {
                List configs = project.getConfigurations().stream().filter(configuration -> configurationNames.contains(configuration.getName())).map(Configuration::getResolvedConfiguration).collect(Collectors.toList());
                Stream<DefaultGradleModuleDependency> dependencies = configs.stream().flatMap(config -> config.getResolvedArtifacts().stream()).map(artifact -> DependencyCollector.getArtifact(project, artifact));
                Stream<DefaultGradleModuleDependency> directDependencies = configs.stream().flatMap(config -> config.getFiles(Specs.satisfyAll()).stream()).map(DependencyCollector::getFileDependency);
                return Stream.concat(dependencies, directDependencies).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            catch (GradleException ex) {
                return new HashSet<GradleModuleDependency>();
            }
        }
        return project.getConfigurations().stream().filter(configuration -> configurationNames.contains(configuration.getName())).filter(Configuration::isCanBeResolved).flatMap(configuration -> DependencyCollector.getConfigurationArtifacts(configuration).stream()).map(artifactResult -> DependencyCollector.getArtifact(project, artifactResult)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static DefaultGradleModuleDependency getArtifact(Project project, ResolvedArtifactResult artifactResult) {
        ComponentArtifactIdentifier id = artifactResult.getId();
        return DependencyCollector.getArtifact(project, id, artifactResult.getFile());
    }

    private static DefaultGradleModuleDependency getArtifact(Project project, ResolvedArtifact resolvedArtifact) {
        ComponentArtifactIdentifier id = resolvedArtifact.getId();
        return DependencyCollector.getArtifact(project, id, resolvedArtifact.getFile());
    }

    private static DefaultGradleModuleDependency getArtifact(Project project, ComponentArtifactIdentifier id, File artifactFile) {
        if (id instanceof ModuleComponentArtifactIdentifier) {
            return DependencyCollector.getModuleArtifactDependency(project, (ModuleComponentArtifactIdentifier)id, artifactFile);
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            return DependencyCollector.getFileArtifactDependency((OpaqueComponentArtifactIdentifier)id, artifactFile);
        }
        if (id instanceof ComponentFileArtifactIdentifier) {
            return DependencyCollector.getFileArtifactDependency((ComponentFileArtifactIdentifier)id, artifactFile);
        }
        return null;
    }

    private static List<ResolvedArtifactResult> getConfigurationArtifacts(Configuration config) {
        return new ArrayList<ResolvedArtifactResult>(config.getIncoming().artifactView(viewConfiguration -> {
            viewConfiguration.lenient(true);
            viewConfiguration.componentFilter(Specs.satisfyAll());
        }).getArtifacts().getArtifacts());
    }

    private static DefaultGradleModuleDependency getModuleArtifactDependency(Project project, ModuleComponentArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        File javaDocJar;
        Set resolvedComponents;
        File sourceJar;
        ArtifactResolutionResult resolutionResult = project.getDependencies().createArtifactResolutionQuery().forComponents(new ComponentIdentifier[]{artifactIdentifier.getComponentIdentifier()}).withArtifacts(JvmLibrary.class, new Class[]{JavadocArtifact.class, SourcesArtifact.class}).execute();
        LinkedList<com.microsoft.java.bs.gradle.model.Artifact> artifacts = new LinkedList<com.microsoft.java.bs.gradle.model.Artifact>();
        if (resolvedArtifactFile != null) {
            artifacts.add(new DefaultArtifact(resolvedArtifactFile.toURI(), null));
        }
        if ((sourceJar = DependencyCollector.getNonClassesArtifact(resolvedComponents = resolutionResult.getResolvedComponents(), SourcesArtifact.class)) != null) {
            artifacts.add(new DefaultArtifact(sourceJar.toURI(), "sources"));
        }
        if ((javaDocJar = DependencyCollector.getNonClassesArtifact(resolvedComponents, JavadocArtifact.class)) != null) {
            artifacts.add(new DefaultArtifact(javaDocJar.toURI(), "javadoc"));
        }
        return new DefaultGradleModuleDependency(artifactIdentifier.getComponentIdentifier().getGroup(), artifactIdentifier.getComponentIdentifier().getModule(), artifactIdentifier.getComponentIdentifier().getVersion(), artifacts);
    }

    private static File getNonClassesArtifact(Set<ComponentArtifactsResult> resolvedComponents, Class<? extends Artifact> artifactClass) {
        for (ComponentArtifactsResult component : resolvedComponents) {
            Set artifacts = component.getArtifacts(artifactClass);
            for (ArtifactResult artifact : artifacts) {
                if (!(artifact instanceof ResolvedArtifactResult)) continue;
                return ((ResolvedArtifactResult)artifact).getFile();
            }
        }
        return null;
    }

    private static DefaultGradleModuleDependency getFileDependency(File resolvedArtifactFile) {
        return DependencyCollector.getFileArtifactDependency(resolvedArtifactFile.getName(), resolvedArtifactFile);
    }

    private static DefaultGradleModuleDependency getFileArtifactDependency(ComponentFileArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        return DependencyCollector.getFileArtifactDependency(artifactIdentifier.getCapitalizedDisplayName(), resolvedArtifactFile);
    }

    private static DefaultGradleModuleDependency getFileArtifactDependency(OpaqueComponentArtifactIdentifier artifactIdentifier, File resolvedArtifactFile) {
        return DependencyCollector.getFileArtifactDependency(artifactIdentifier.getCapitalizedDisplayName(), resolvedArtifactFile);
    }

    private static DefaultGradleModuleDependency getFileArtifactDependency(String displayName, File resolvedArtifactFile) {
        LinkedList<com.microsoft.java.bs.gradle.model.Artifact> artifacts = new LinkedList<com.microsoft.java.bs.gradle.model.Artifact>();
        if (resolvedArtifactFile != null) {
            artifacts.add(new DefaultArtifact(resolvedArtifactFile.toURI(), null));
        }
        return new DefaultGradleModuleDependency(UNKNOWN, displayName, UNKNOWN, artifacts);
    }
}

