/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.m2e.core.internal.ExtensionReader;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.URLConnectionCaches;
import org.eclipse.m2e.core.internal.builder.BuildDebugHook;
import org.eclipse.m2e.core.internal.builder.BuildProblemInfo;
import org.eclipse.m2e.core.internal.builder.BuildResultCollector;
import org.eclipse.m2e.core.internal.builder.DeltaProvider;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant;
import org.eclipse.m2e.core.internal.builder.InternalBuildParticipant2;
import org.eclipse.m2e.core.internal.builder.MavenBuilder;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.AbstractEclipseBuildContext;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.EclipseResourceBuildDelta;
import org.eclipse.m2e.core.internal.builder.plexusbuildapi.PlexusBuildAPI;
import org.eclipse.m2e.core.internal.embedder.MavenProjectMutableState;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MavenBuilderImpl {
    private static Logger log = LoggerFactory.getLogger(MavenBuilderImpl.class);
    public static final QualifiedName BUILD_CONTEXT_KEY = new QualifiedName("org.eclipse.m2e.core", "BuildContext");
    private static final String BUILD_PARTICIPANT_ID_ATTR_NAME = "buildParticipantId";
    private final DeltaProvider deltaProvider;
    private final List<IIncrementalBuildFramework> incrementalBuildFrameworks;
    private final Map<IProject, ProjectBuildState> deltaState = new ConcurrentHashMap<IProject, ProjectBuildState>();

    public MavenBuilderImpl(DeltaProvider deltaProvider) {
        this.deltaProvider = deltaProvider;
        this.incrementalBuildFrameworks = this.loadIncrementalBuildFrameworks();
    }

    private List<IIncrementalBuildFramework> loadIncrementalBuildFrameworks() {
        ArrayList<IIncrementalBuildFramework> frameworks = new ArrayList<IIncrementalBuildFramework>();
        frameworks.add(new PlexusBuildAPI());
        frameworks.addAll(ExtensionReader.readIncrementalBuildFrameworks());
        return frameworks;
    }

    public MavenBuilderImpl() {
        this(project -> null);
    }

    /*
     * Unable to fully structure code
     */
    public Set<IProject> build(MavenSession session, IMavenProjectFacade projectFacade, int kind, Map<String, String> args, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IProgressMonitor monitor) throws CoreException {
        block10: {
            block9: {
                URLConnectionCaches.assertDisabled();
                debugHooks = MavenBuilder.getDebugHooks();
                dependencies = new HashSet<IProject>();
                mavenProject = projectFacade.getMavenProject();
                project = projectFacade.getProject();
                deltaProvider = this.getDeltaProvider();
                delta = deltaProvider.getDelta(project);
                deltaType = this.hasRelevantDelta(projectFacade, delta);
                if (deltaType == DeltaType.IRRELEVANT) {
                    return Set.of(project);
                }
                buildState = this.deltaState.computeIfAbsent(project, (Function<IProject, ProjectBuildState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(org.eclipse.core.resources.IProject ), (Lorg/eclipse/core/resources/IProject;)Lorg/eclipse/m2e/core/internal/builder/MavenBuilderImpl$ProjectBuildState;)());
                participantResults = new BuildResultCollector();
                incrementalContexts = this.setupProjectBuildContext(project, kind, delta, participantResults, buildState, deltaType);
                this.debugBuildStart(debugHooks, projectFacade, kind, args, participants, delta, monitor);
                buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
                snapshot = MavenProjectMutableState.takeSnapshot(mavenProject);
                try {
                    try {
                        participants.forEach((BiConsumer<MojoExecutionKey, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$2(java.util.Collection org.eclipse.m2e.core.internal.builder.BuildResultCollector org.eclipse.m2e.core.project.IMavenProjectFacade org.eclipse.m2e.core.internal.builder.DeltaProvider org.apache.maven.execution.MavenSession java.util.List java.util.Map java.util.Map int org.eclipse.core.resources.IResourceDelta org.eclipse.core.runtime.IProgressMonitor java.util.Set org.eclipse.m2e.core.project.configurator.MojoExecutionKey java.util.List ), (Lorg/eclipse/m2e/core/project/configurator/MojoExecutionKey;Ljava/util/List;)V)((MavenBuilderImpl)this, debugHooks, (BuildResultCollector)participantResults, (IMavenProjectFacade)projectFacade, (DeltaProvider)deltaProvider, (MavenSession)session, incrementalContexts, args, buildErrors, (int)kind, (IResourceDelta)delta, (IProgressMonitor)monitor, dependencies));
                        break block9;
                    }
                    catch (Exception e) {
                        MavenBuilderImpl.log.debug("Unexpected build exception", (Throwable)e);
                        buildErrors.put(e, null);
                        snapshot.restore(mavenProject);
                        ** for (context : incrementalContexts)
                    }
                }
                catch (Throwable var20_27) {
                    snapshot.restore(mavenProject);
                    ** for (context : incrementalContexts)
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
lbl29:
                    // 1 sources

                    break block10;
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
                }
lbl35:
                // 1 sources

                throw var20_27;
            }
            snapshot.restore(mavenProject);
            for (IIncrementalBuildFramework.BuildContext context : incrementalContexts) {
                context.release();
            }
        }
        this.refreshResources(project, participantResults.getFiles(), monitor);
        result = session.getResult();
        this.processBuildResults(project, mavenProject, result, participantResults, buildErrors);
        if (buildErrors.isEmpty()) {
            buildState.commit();
        }
        return dependencies;
    }

    private DeltaType hasRelevantDelta(IMavenProjectFacade projectFacade, IResourceDelta resourceDelta) throws CoreException {
        if (resourceDelta == null) {
            return DeltaType.FULL_BUILD;
        }
        IProject project = projectFacade.getProject();
        IPath buildOutputLocation = projectFacade.getBuildOutputLocation();
        if (project == null || buildOutputLocation == null) {
            return DeltaType.UNKOWN;
        }
        Predicate<IPath> isOutput = MavenBuilderImpl.toPrefixPredicate(projectFacade.getOutputLocation());
        Predicate<IPath> isTestOutput = MavenBuilderImpl.toPrefixPredicate(projectFacade.getTestOutputLocation());
        Predicate<IPath> isOutputOrTestOutput = isOutput.or(isTestOutput);
        IPath projectPath = project.getFullPath();
        List<IPath> moduleLocations = projectFacade.getMavenProjectModules().stream().map(module -> projectPath.append(module)).toList();
        AtomicReference<DeltaType> deltaType = new AtomicReference<DeltaType>(DeltaType.IRRELEVANT);
        resourceDelta.accept(delta -> {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IPath fullPath = delta.getFullPath();
                if (buildOutputLocation.isPrefixOf(fullPath)) {
                    if (isOutputOrTestOutput.test(fullPath) && !resource.exists()) {
                        deltaType.set(DeltaType.FULL_BUILD);
                        return false;
                    }
                    return true;
                }
                for (IPath modulePath : moduleLocations) {
                    if (!modulePath.isPrefixOf(fullPath)) continue;
                    return true;
                }
                deltaType.set(DeltaType.INCREMENTAL);
                return false;
            }
            return true;
        });
        return deltaType.get();
    }

    private static Predicate<IPath> toPrefixPredicate(IPath location) {
        if (location == null) {
            return p -> false;
        }
        return p -> location.isPrefixOf(p);
    }

    private List<IIncrementalBuildFramework.BuildContext> setupProjectBuildContext(IProject project, int kind, IResourceDelta delta, IIncrementalBuildFramework.BuildResultCollector results, ProjectBuildState buildState, DeltaType deltaType) throws CoreException {
        ArrayList<IIncrementalBuildFramework.BuildContext> contexts = new ArrayList<IIncrementalBuildFramework.BuildContext>();
        ProjectBuildStateDelta buildDelta = deltaType == DeltaType.FULL_BUILD || delta == null ? null : new ProjectBuildStateDelta(buildState, new EclipseResourceBuildDelta(delta));
        for (IIncrementalBuildFramework framework : this.incrementalBuildFrameworks) {
            contexts.add(framework.setupProjectBuildContext(project, kind, buildDelta, results));
        }
        return contexts;
    }

    private void debugBuildParticipant(Collection<BuildDebugHook> hooks, IMavenProjectFacade projectFacade, MojoExecutionKey mojoExecutionKey, AbstractBuildParticipant participant, Set<File> files, IProgressMonitor monitor) {
        for (BuildDebugHook hook : hooks) {
            hook.buildParticipant(projectFacade, mojoExecutionKey, participant, files, monitor);
        }
    }

    private Set<File> diff(Set<File> before, Set<File> after) {
        if (before == null) {
            return after;
        }
        LinkedHashSet<File> result = new LinkedHashSet<File>(after);
        result.removeAll(before);
        return result;
    }

    private void debugBuildStart(Collection<BuildDebugHook> hooks, IMavenProjectFacade projectFacade, int kind, Map<String, String> args, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IResourceDelta delta, IProgressMonitor monitor) {
        for (BuildDebugHook hook : hooks) {
            hook.buildStart(projectFacade, kind, args, participants, delta, monitor);
        }
    }

    protected boolean isApplicable(InternalBuildParticipant participant, int kind, IResourceDelta delta) {
        return 6 == kind || delta != null || participant.callOnEmptyDelta();
    }

    private void processMavenSessionErrors(MavenSession session, MojoExecutionKey mojoExecutionKey, Map<Throwable, MojoExecutionKey> buildErrors) {
        MavenExecutionResult result = session.getResult();
        if (result.hasExceptions()) {
            for (Throwable e : result.getExceptions()) {
                log.debug("Exception during execution {}", (Object)mojoExecutionKey, (Object)e);
                buildErrors.put(e, mojoExecutionKey);
            }
            result.getExceptions().clear();
        }
    }

    private void refreshResources(IProject project, Collection<File> resources, IProgressMonitor monitor) throws CoreException {
        if (this.isAutoRefresh()) {
            return;
        }
        project.refreshLocal(2, monitor);
        for (File file : resources) {
            IPath path = MavenProjectUtils.getProjectRelativePath(project, file.getAbsolutePath());
            if (path == null) {
                log.debug("Could not get relative path for file: {}", (Object)file.getAbsoluteFile());
                continue;
            }
            Object resource = path.isEmpty() ? project : (!file.exists() ? project.findMember(path) : (file.isDirectory() ? project.getFolder(path) : project.getFile(path)));
            if (resource == null) continue;
            resource.refreshLocal(2, monitor);
            if (!resource.exists()) continue;
            resource.touch(monitor);
        }
    }

    private boolean isAutoRefresh() {
        return ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("refresh.enabled");
    }

    private void processBuildResults(IProject project, MavenProject mavenProject, MavenExecutionResult result, BuildResultCollector results, Map<Throwable, MojoExecutionKey> buildErrors) {
        IMavenMarkerManager markerManager = MavenPluginActivator.getDefault().getMavenMarkerManager();
        results.getRemoveMessages().forEach((buildParticipantId, files) -> {
            for (File file : files) {
                this.deleteBuildParticipantMarkers(project, markerManager, file, (String)buildParticipantId);
            }
        });
        results.getMessages().forEach((buildParticipantId, messages) -> {
            for (BuildResultCollector.Message buildMessage : messages) {
                this.addBuildParticipantMarker(project, markerManager, buildMessage, (String)buildParticipantId);
                if (buildMessage.cause() == null) continue;
                buildErrors.remove(buildMessage.cause());
            }
        });
        buildErrors.forEach((error, mojoExecutionKey) -> {
            SourceLocation markerLocation = mojoExecutionKey != null ? SourceLocationHelper.findLocation(mavenProject, mojoExecutionKey) : new SourceLocation(1, 0, 0);
            BuildProblemInfo problem = new BuildProblemInfo((Throwable)error, (MojoExecutionKey)mojoExecutionKey, markerLocation);
            markerManager.addErrorMarker((IResource)project.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", problem);
        });
        if (result.hasExceptions()) {
            markerManager.addMarkers((IResource)project.getFile("pom.xml"), "org.eclipse.m2e.core.maven2Problem.build", result);
        }
    }

    private void deleteBuildParticipantMarkers(IProject project, IMavenMarkerManager markerManager, File file, String buildParticipantId) {
        IResource resource = MavenProjectUtils.getProjectResource(project, file);
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        try {
            markerManager.deleteMarkers(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", BUILD_PARTICIPANT_ID_ATTR_NAME, buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addBuildParticipantMarker(IProject project, IMavenMarkerManager markerManager, BuildResultCollector.Message buildMessage, String buildParticipantId) {
        IResource resource = MavenProjectUtils.getProjectResource(project, buildMessage.file());
        if (resource == null) {
            resource = project.getFile("pom.xml");
        }
        int at = buildParticipantId.lastIndexOf(45);
        String pluginExecutionKey = buildParticipantId.substring(0, at);
        String message = buildMessage.message() + " (" + pluginExecutionKey + ")";
        IMarker marker = markerManager.addMarker(resource, "org.eclipse.m2e.core.maven2Problem.build.participant", message, buildMessage.line(), buildMessage.severity());
        try {
            marker.setAttribute(BUILD_PARTICIPANT_ID_ATTR_NAME, (Object)buildParticipantId);
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void clean(MavenSession session, IMavenProjectFacade projectFacade, Map<MojoExecutionKey, List<AbstractBuildParticipant>> participants, IProgressMonitor monitor) throws CoreException {
        block8: {
            block7: {
                mavenProject = projectFacade.getMavenProject();
                project = projectFacade.getProject();
                participantResults = new BuildResultCollector();
                incrementalContexts = this.setupProjectBuildContext(project, 15, null, participantResults, null, DeltaType.UNKOWN);
                buildErrors = new LinkedHashMap<Throwable, MojoExecutionKey>();
                try {
                    try {
                        participants.forEach((BiConsumer<MojoExecutionKey, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$10(org.eclipse.m2e.core.internal.builder.BuildResultCollector org.eclipse.m2e.core.project.IMavenProjectFacade org.apache.maven.execution.MavenSession java.util.List java.util.Map org.eclipse.core.runtime.IProgressMonitor org.eclipse.m2e.core.project.configurator.MojoExecutionKey java.util.List ), (Lorg/eclipse/m2e/core/project/configurator/MojoExecutionKey;Ljava/util/List;)V)((MavenBuilderImpl)this, (BuildResultCollector)participantResults, (IMavenProjectFacade)projectFacade, (MavenSession)session, incrementalContexts, buildErrors, (IProgressMonitor)monitor));
                        break block7;
                    }
                    catch (Exception e) {
                        buildErrors.put(e, null);
                        ** for (context : incrementalContexts)
                    }
                }
                catch (Throwable var11_18) {
                    ** for (context : incrementalContexts)
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
lbl16:
                    // 1 sources

                    break block8;
                }
lbl-1000:
                // 1 sources

                {
                    context.release();
                    continue;
                }
lbl21:
                // 1 sources

                throw var11_18;
            }
            for (IIncrementalBuildFramework.BuildContext context : incrementalContexts) {
                context.release();
            }
        }
        this.refreshResources(project, participantResults.getFiles(), monitor);
        result = session.getResult();
        this.processBuildResults(project, mavenProject, result, participantResults, buildErrors);
    }

    DeltaProvider getDeltaProvider() {
        return this.deltaProvider;
    }

    private /* synthetic */ void lambda$2(Collection collection, BuildResultCollector buildResultCollector, IMavenProjectFacade iMavenProjectFacade, DeltaProvider deltaProvider, MavenSession mavenSession, List list, Map map, Map map2, int n, IResourceDelta iResourceDelta, IProgressMonitor iProgressMonitor, Set set, MojoExecutionKey mojoExecutionKey, List buildParticipants) {
        for (InternalBuildParticipant participant : buildParticipants) {
            LinkedHashSet<File> debugRefreshFiles;
            block12: {
                InternalBuildParticipant2 participant2;
                debugRefreshFiles = !collection.isEmpty() ? new LinkedHashSet<File>(buildResultCollector.getFiles()) : null;
                log.debug("Executing build participant {} for plugin execution {}", (Object)participant.getClass().getName(), (Object)mojoExecutionKey);
                buildResultCollector.setParticipantId(mojoExecutionKey.getKeyString() + "-" + participant.getClass().getName());
                participant.setMavenProjectFacade(iMavenProjectFacade);
                participant.setGetDeltaCallback(deltaProvider);
                participant.setSession(mavenSession);
                IIncrementalBuildFramework.BuildContext buildContext = (IIncrementalBuildFramework.BuildContext)list.get(0);
                if (buildContext instanceof BuildContext) {
                    BuildContext incremental = (BuildContext)buildContext;
                    participant.setBuildContext(incremental);
                }
                if (participant instanceof InternalBuildParticipant2) {
                    InternalBuildParticipant2 participant22 = (InternalBuildParticipant2)participant;
                    participant22.setArgs(map);
                }
                long executionStartTime = System.currentTimeMillis();
                try {
                    try {
                        Set<IProject> sub;
                        if (this.isApplicable(participant, n, iResourceDelta) && (sub = participant.build(n, iProgressMonitor)) != null) {
                            set.addAll(sub);
                        }
                    }
                    catch (Exception e) {
                        log.debug("Exception in build participant {}", (Object)participant.getClass().getName(), (Object)e);
                        map2.put(e, mojoExecutionKey);
                        log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{participant.getClass().getName(), mojoExecutionKey, System.currentTimeMillis() - executionStartTime});
                        participant.setMavenProjectFacade(null);
                        participant.setGetDeltaCallback(null);
                        participant.setSession(null);
                        participant.setBuildContext(null);
                        if (participant instanceof InternalBuildParticipant2) {
                            participant2 = (InternalBuildParticipant2)participant;
                            participant2.setArgs(Collections.emptyMap());
                        }
                        this.processMavenSessionErrors(mavenSession, mojoExecutionKey, map2);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{participant.getClass().getName(), mojoExecutionKey, System.currentTimeMillis() - executionStartTime});
                    participant.setMavenProjectFacade(null);
                    participant.setGetDeltaCallback(null);
                    participant.setSession(null);
                    participant.setBuildContext(null);
                    if (participant instanceof InternalBuildParticipant2) {
                        participant2 = (InternalBuildParticipant2)participant;
                        participant2.setArgs(Collections.emptyMap());
                    }
                    this.processMavenSessionErrors(mavenSession, mojoExecutionKey, map2);
                    throw throwable;
                }
                log.debug("Finished executing build participant {} for plugin execution {} in {} ms", new Object[]{participant.getClass().getName(), mojoExecutionKey, System.currentTimeMillis() - executionStartTime});
                participant.setMavenProjectFacade(null);
                participant.setGetDeltaCallback(null);
                participant.setSession(null);
                participant.setBuildContext(null);
                if (participant instanceof InternalBuildParticipant2) {
                    participant2 = (InternalBuildParticipant2)participant;
                    participant2.setArgs(Collections.emptyMap());
                }
                this.processMavenSessionErrors(mavenSession, mojoExecutionKey, map2);
            }
            this.debugBuildParticipant(collection, iMavenProjectFacade, mojoExecutionKey, (AbstractBuildParticipant)participant, this.diff(debugRefreshFiles, buildResultCollector.getFiles()), iProgressMonitor);
        }
    }

    private /* synthetic */ void lambda$10(BuildResultCollector buildResultCollector, IMavenProjectFacade iMavenProjectFacade, MavenSession mavenSession, List list, Map map, IProgressMonitor iProgressMonitor, MojoExecutionKey mojoExecutionKey, List buildParticipants) {
        for (InternalBuildParticipant participant : buildParticipants) {
            buildResultCollector.setParticipantId(mojoExecutionKey.getKeyString() + "-" + participant.getClass().getName());
            participant.setMavenProjectFacade(iMavenProjectFacade);
            participant.setGetDeltaCallback(this.getDeltaProvider());
            participant.setSession(mavenSession);
            participant.setBuildContext((AbstractEclipseBuildContext)list.get(0));
            try {
                try {
                    participant.clean(iProgressMonitor);
                }
                catch (Exception e) {
                    log.debug("Exception in build participant", (Throwable)e);
                    map.put(e, mojoExecutionKey);
                    participant.setMavenProjectFacade(null);
                    participant.setGetDeltaCallback(null);
                    participant.setSession(null);
                    participant.setBuildContext(null);
                    this.processMavenSessionErrors(mavenSession, mojoExecutionKey, map);
                    continue;
                }
            }
            catch (Throwable throwable) {
                participant.setMavenProjectFacade(null);
                participant.setGetDeltaCallback(null);
                participant.setSession(null);
                participant.setBuildContext(null);
                this.processMavenSessionErrors(mavenSession, mojoExecutionKey, map);
                throw throwable;
            }
            participant.setMavenProjectFacade(null);
            participant.setGetDeltaCallback(null);
            participant.setSession(null);
            participant.setBuildContext(null);
            this.processMavenSessionErrors(mavenSession, mojoExecutionKey, map);
        }
    }

    private static enum DeltaType {
        INCREMENTAL,
        IRRELEVANT,
        FULL_BUILD,
        UNKOWN;

    }

    private static final class ProjectBuildState {
        private long lastBuild;
        private IProject project;

        public ProjectBuildState(IProject project) {
            this.project = project;
        }

        public void commit() {
            this.lastBuild = System.currentTimeMillis();
        }

        public String toString() {
            return "BuildState for " + String.valueOf(this.project) + " lat reccorded timestamp " + DateFormat.getDateTimeInstance().format(new Date(this.lastBuild));
        }
    }

    private static final class ProjectBuildStateDelta
    implements IIncrementalBuildFramework.BuildDelta,
    IAdaptable {
        private ProjectBuildState buildState;
        private IIncrementalBuildFramework.BuildDelta delegate;

        public ProjectBuildStateDelta(ProjectBuildState buildState, IIncrementalBuildFramework.BuildDelta delegate) {
            this.buildState = buildState;
            this.delegate = delegate;
        }

        @Override
        public boolean hasDelta(File file) {
            long lastModified;
            if (this.delegate != null && this.delegate.hasDelta(file)) {
                return true;
            }
            return file.isFile() && (lastModified = file.lastModified()) > this.buildState.lastBuild;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return (T)Adapters.adapt((Object)this.delegate, adapter);
        }
    }
}

