/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class LogReader {
    private static final int SESSION_STATE = 10;
    private static final int ENTRY_STATE = 20;
    private static final int SUBENTRY_STATE = 30;
    private static final int MESSAGE_STATE = 40;
    private static final int STACK_STATE = 50;
    private static final int TEXT_STATE = 60;
    private static final int UNKNOWN_STATE = 70;

    public static List<LogEntry> parseLogFile(File file, String lastEntryDateString) {
        LogSession currentSession;
        ArrayList<LogEntry> entries;
        ArrayList<LogEntry> tmp;
        block41: {
            PrintWriter writer;
            StringWriter swriter;
            int writerState;
            LogSession session;
            LogEntry current;
            block40: {
                tmp = new ArrayList<LogEntry>();
                entries = new ArrayList<LogEntry>();
                Date lastEntryDate = null;
                try {
                    lastEntryDate = DateFormat.getDateTimeInstance(2, 2).parse(lastEntryDateString);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (!file.exists()) {
                    return null;
                }
                ArrayList<LogEntry> parents = new ArrayList<LogEntry>();
                current = null;
                session = null;
                writerState = 70;
                swriter = null;
                writer = null;
                int state = 70;
                currentSession = null;
                try {
                    try {
                        Throwable throwable = null;
                        Iterator iterator = null;
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                            while (true) {
                                block23: while (true) {
                                    String line0;
                                    if ((line0 = reader.readLine()) == null) {
                                        break block40;
                                    }
                                    String line = line0.trim();
                                    state = line.startsWith("!SESSION") ? 10 : (line.startsWith("!ENTRY") ? 20 : (line.startsWith("!SUBENTRY") ? 30 : (line.startsWith("!MESSAGE") ? 40 : (line.startsWith("!STACK") ? 50 : 60))));
                                    if (state == 60) {
                                        if (writer == null) continue;
                                        if (swriter.getBuffer().length() > 0) {
                                            writer.println();
                                        }
                                        writer.print(line0);
                                        continue;
                                    }
                                    if (writer != null) {
                                        LogReader.setData(current, session, writerState, swriter);
                                        writerState = 70;
                                        swriter = null;
                                        writer.close();
                                        writer = null;
                                    }
                                    switch (state) {
                                        case 50: {
                                            swriter = new StringWriter();
                                            writer = new PrintWriter((Writer)swriter, true);
                                            writerState = 50;
                                            continue block23;
                                        }
                                        case 10: {
                                            session = new LogSession();
                                            session.processLogLine(line);
                                            swriter = new StringWriter();
                                            writer = new PrintWriter((Writer)swriter, true);
                                            writerState = 10;
                                            currentSession = LogReader.updateCurrentSession(currentSession, session);
                                            continue block23;
                                        }
                                        case 20: {
                                            LogEntry entry2;
                                            if (currentSession == null) {
                                                currentSession = new LogSession();
                                            }
                                            try {
                                                entry2 = new LogEntry();
                                                entry2.setSession(currentSession);
                                                entry2.processEntry(line);
                                                LogReader.setNewParent(parents, entry2, 0);
                                                current = entry2;
                                                if (!current.getDate().before(lastEntryDate)) continue block23;
                                                LogReader.addEntry(current, tmp);
                                            }
                                            catch (IllegalArgumentException entry2) {}
                                            continue block23;
                                        }
                                        case 30: {
                                            LogEntry entry2;
                                            if (parents.size() <= 0) continue block23;
                                            try {
                                                entry2 = new LogEntry();
                                                entry2.setSession(session);
                                                int depth = entry2.processSubEntry(line);
                                                LogReader.setNewParent(parents, entry2, depth);
                                                current = entry2;
                                                LogEntry parent = parents.get(depth - 1);
                                                parent.addChild(entry2);
                                            }
                                            catch (IllegalArgumentException entry) {}
                                            continue block23;
                                        }
                                        case 40: {
                                            swriter = new StringWriter();
                                            writer = new PrintWriter((Writer)swriter, true);
                                            String message = "";
                                            if (line.length() > 8) {
                                                message = line.substring(9);
                                            }
                                            if (current != null) {
                                                current.setMessage(message);
                                            }
                                            writerState = 40;
                                            continue block23;
                                        }
                                    }
                                }
                                break;
                            }
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        if (writer != null) {
                            LogReader.setData(current, session, writerState, swriter);
                            writer.close();
                        }
                        break block41;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        LogReader.setData(current, session, writerState, swriter);
                        writer.close();
                    }
                    throw throwable;
                }
            }
            if (writer != null) {
                LogReader.setData(current, session, writerState, swriter);
                writer.close();
            }
        }
        for (LogEntry e : tmp) {
            if (!e.getSession().equals(currentSession)) continue;
            entries.add(e);
        }
        return entries;
    }

    private static void setData(LogEntry current, LogSession session, int writerState, StringWriter swriter) {
        if (writerState == 50 && current != null) {
            current.setStack(swriter.toString());
        } else if (writerState == 10 && session != null) {
            session.setSessionData(swriter.toString());
        } else if (writerState == 40 && current != null) {
            StringBuilder sb = new StringBuilder(current.getMessage());
            String continuation = swriter.toString();
            if (continuation.length() > 0) {
                sb.append(System.lineSeparator()).append(continuation);
            }
            current.setMessage(sb.toString());
        }
    }

    private static LogSession updateCurrentSession(LogSession currentSession, LogSession session) {
        if (currentSession == null) {
            return session;
        }
        Date currentDate = currentSession.getDate();
        Date sessionDate = session.getDate();
        if (currentDate == null && sessionDate != null) {
            return session;
        }
        if (currentDate != null && sessionDate == null) {
            return session;
        }
        if (currentDate != null && sessionDate != null && sessionDate.after(currentDate)) {
            return session;
        }
        return currentSession;
    }

    private static void addEntry(LogEntry entry, List<LogEntry> entries) {
        entries.add(entry);
    }

    private static void setNewParent(ArrayList<LogEntry> parents, LogEntry entry, int depth) {
        if (depth + 1 > parents.size()) {
            parents.add(entry);
        } else {
            parents.set(depth, entry);
        }
    }

    public static class LogEntry {
        public static final String F_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        private static final DateTimeFormatter GREGORIAN_SDF = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH).withZone(ZoneId.systemDefault());
        public static final String SPACE = " ";
        private LogSession session;
        private String stack;
        private String message;
        private List<LogEntry> children = new ArrayList<LogEntry>();
        private int severity;
        private int code;
        private String pluginId;
        private Date fDate;

        public void setSession(LogSession currentSession) {
            this.session = currentSession;
        }

        public LogSession getSession() {
            return this.session;
        }

        public String getMessage() {
            return this.message;
        }

        public void setStack(String stack) {
            this.stack = stack;
        }

        public String getStack() {
            return this.stack;
        }

        public int processSubEntry(String line) throws IllegalArgumentException {
            StringTokenizer stok = new StringTokenizer(line, SPACE);
            StringBuilder dateBuffer = new StringBuilder();
            int depth = 0;
            String token = null;
            int tokens = stok.countTokens();
            int i = 0;
            while (i < tokens) {
                token = stok.nextToken();
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        try {
                            depth = Integer.parseInt(token);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Failed to parse '" + token + "'", e);
                        }
                    }
                    case 2: {
                        this.pluginId = token;
                        break;
                    }
                    case 3: {
                        try {
                            this.severity = Integer.parseInt(token);
                        }
                        catch (NumberFormatException nfe) {
                            this.appendToken(dateBuffer, token);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            this.code = Integer.parseInt(token);
                        }
                        catch (NumberFormatException nfe) {
                            this.appendToken(dateBuffer, token);
                        }
                        break;
                    }
                    default: {
                        this.appendToken(dateBuffer, token);
                    }
                }
                ++i;
            }
            try {
                Date date = Date.from(Instant.from(GREGORIAN_SDF.parse(dateBuffer.toString())));
                if (date != null) {
                    this.fDate = date;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse '" + String.valueOf(dateBuffer) + "'", e);
            }
            return depth;
        }

        public void processEntry(String line) throws IllegalArgumentException {
            StringTokenizer stok = new StringTokenizer(line, SPACE);
            this.severity = 0;
            this.code = 0;
            StringBuilder dateBuffer = new StringBuilder();
            int tokens = stok.countTokens();
            String token = null;
            int i = 0;
            while (i < tokens) {
                token = stok.nextToken();
                switch (i) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.pluginId = token;
                        break;
                    }
                    case 2: {
                        try {
                            this.severity = Integer.parseInt(token);
                        }
                        catch (NumberFormatException nfe) {
                            this.appendToken(dateBuffer, token);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            this.code = Integer.parseInt(token);
                        }
                        catch (NumberFormatException nfe) {
                            this.appendToken(dateBuffer, token);
                        }
                        break;
                    }
                    default: {
                        this.appendToken(dateBuffer, token);
                    }
                }
                ++i;
            }
            String stringToParse = dateBuffer.toString();
            try {
                Date date = Date.from(Instant.from(GREGORIAN_SDF.parse(stringToParse)));
                if (date != null) {
                    this.fDate = date;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse '" + String.valueOf(dateBuffer) + "'", e);
            }
        }

        void appendToken(StringBuilder buffer, String token) {
            if (buffer.length() > 0) {
                buffer.append(SPACE);
            }
            buffer.append(token);
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void addChild(LogEntry child) {
            this.children.add(child);
        }

        public Date getDate() {
            return this.fDate;
        }

        public int getSeverity() {
            return this.severity;
        }
    }

    public static class LogSession {
        public static final String SESSION = "!SESSION";
        private String data;
        private Date date;

        public void setSessionData(String data) {
            this.data = data;
        }

        public Date getDate() {
            return this.date;
        }

        private void setDate(String dateString) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                this.date = formatter.parse(dateString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public void processLogLine(String line) {
            if (line.startsWith(SESSION)) {
                int delim = (line = line.substring(SESSION.length()).trim()).indexOf("----");
                if (delim == -1) {
                    return;
                }
                String dateBuffer = line.substring(0, delim).trim();
                this.setDate(dateBuffer);
            }
        }
    }
}

