/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;

public abstract class JavacPackageBinding
implements IPackageBinding {
    private Symbol.PackageSymbol packageSymbol;
    final JavacBindingResolver resolver;
    private String nameString;

    public JavacPackageBinding(Symbol.PackageSymbol packge, JavacBindingResolver resolver) {
        this.setPackageSymbol(packge);
        this.nameString = packge.getQualifiedName().toString();
        this.resolver = resolver;
    }

    public JavacPackageBinding(String nameString, JavacBindingResolver resolver) {
        this.nameString = nameString;
        this.resolver = resolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        return this.getPackageSymbol() == null ? new IAnnotationBinding[]{} : (IAnnotationBinding[])this.getPackageSymbol().getAnnotationMirrors().stream().map(am -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)am, (IBinding)this)).toArray(IAnnotationBinding[]::new);
    }

    public int getKind() {
        return 1;
    }

    public int getModifiers() {
        return this.getPackageSymbol() == null ? 0 : JavacMethodBinding.toInt(this.getPackageSymbol().getModifiers());
    }

    public boolean isDeprecated() {
        return this.getPackageSymbol() == null ? false : this.getPackageSymbol().isDeprecated();
    }

    public boolean isRecovered() {
        IJavaElement element = this.getJavaElement();
        return element == null || !element.exists();
    }

    public boolean isSynthetic() {
        return false;
    }

    public IJavaElement getJavaElement() {
        System.err.println("Hardocded binding->IJavaElement to 1st package");
        if (this.resolver.javaProject == null) {
            return null;
        }
        try {
            IJavaElement ret = Arrays.stream(this.resolver.javaProject.getAllPackageFragmentRoots()).map(root -> root.getPackageFragment(this.getQualifiedNameInternal())).filter(Objects::nonNull).filter(IJavaElement::exists).findFirst().orElse(null);
            return ret;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IJavaElement findJavaElementForClass(String fqqn) {
        if (this.resolver.javaProject == null) {
            return null;
        }
        String qnInternal = this.getQualifiedNameInternal();
        if (fqqn.length() <= qnInternal.length()) {
            return null;
        }
        try {
            List ret = Arrays.stream(this.resolver.javaProject.getAllPackageFragmentRoots()).map(root -> root.getPackageFragment(qnInternal)).filter(Objects::nonNull).filter(IJavaElement::exists).collect(Collectors.toList());
            int s = ret.size();
            if (s == 1) {
                return (IJavaElement)ret.get(0);
            }
            String relative = qnInternal == null || qnInternal.isEmpty() ? fqqn : fqqn.substring(qnInternal.length() + 1);
            String relativePackage = relative != null && relative.contains(".") ? relative.substring(0, relative.lastIndexOf(".")) : null;
            String cuName = relative != null && relative.contains(".") ? relative.substring(relative.lastIndexOf(".") + 1) : relative;
            String soughtFile = cuName + ".java";
            for (int i = 0; i < s; ++i) {
                ICompilationUnit cu;
                IPackageFragment pf = (IPackageFragment)ret.get(i);
                if (relativePackage != null || (cu = pf.getCompilationUnit(soughtFile)) == null || !cu.exists()) continue;
                return pf;
            }
            return s == 0 ? null : (IJavaElement)ret.get(0);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IModuleBinding getModule() {
        return this.getPackageSymbol() != null ? this.resolver.bindings.getModuleBinding(this.getPackageSymbol().modle) : null;
    }

    public String getKey() {
        if (this.isUnnamed()) {
            return "";
        }
        return this.getQualifiedNameInternal().replace('.', '/');
    }

    public String getName() {
        return this.isUnnamed() ? "" : this.getQualifiedNameInternal();
    }

    public boolean isUnnamed() {
        Symbol.PackageSymbol ps = this.getPackageSymbol();
        return ps != null ? ps.isUnnamed() : "".equals(this.nameString);
    }

    public String[] getNameComponents() {
        return this.isUnnamed() ? new String[]{} : this.getQualifiedNameInternal().split("\\.");
    }

    private String getQualifiedNameInternal() {
        return this.getPackageSymbol() != null ? this.getPackageSymbol().getQualifiedName().toString() : this.nameString;
    }

    public String toString() {
        return "package " + this.getName();
    }

    public Symbol.PackageSymbol getPackageSymbol() {
        return this.packageSymbol;
    }

    public void setPackageSymbol(Symbol.PackageSymbol packageSymbol) {
        this.packageSymbol = packageSymbol;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.getPackageSymbol(), this.nameString});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof IPackageBinding)) return false;
        IPackageBinding other = (IPackageBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacPackageBinding)) return false;
        JavacPackageBinding other = (JavacPackageBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.getPackageSymbol(), other.getPackageSymbol())) return false;
        if (!Objects.equals(this.nameString, other.nameString)) return false;
        return true;
    }
}

