/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.lang.model.element.ModuleElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.internal.javac.dom.JavacAnnotationBinding;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacPackageBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public abstract class JavacModuleBinding
implements IModuleBinding {
    final JavacBindingResolver resolver;
    public final Symbol.ModuleSymbol moduleSymbol;
    private JCTree.JCModuleDecl moduleDecl;

    public JavacModuleBinding(Type.ModuleType moduleType, JavacBindingResolver resolver) {
        this((Symbol.ModuleSymbol)moduleType.tsym, moduleType, resolver);
    }

    public JavacModuleBinding(Symbol.ModuleSymbol moduleSymbol, JavacBindingResolver resolver) {
        this(moduleSymbol, (Type.ModuleType)moduleSymbol.type, resolver);
    }

    public JavacModuleBinding(JCTree.JCModuleDecl decl, JavacBindingResolver resolver) {
        this(decl.sym, (Type.ModuleType)decl.sym.type, resolver);
        this.moduleDecl = decl;
    }

    public JavacModuleBinding(Symbol.ModuleSymbol moduleSymbol, Type.ModuleType moduleType, JavacBindingResolver resolver) {
        this.moduleSymbol = moduleSymbol;
        this.resolver = resolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        List<Attribute.Compound> list = this.moduleSymbol.getRawAttributes();
        return (IAnnotationBinding[])list.stream().map(x -> this.resolver.bindings.getAnnotationBinding((Attribute.Compound)x, (IBinding)this)).toArray(JavacAnnotationBinding[]::new);
    }

    public String getName() {
        return this.moduleSymbol.name.toString();
    }

    public int getModifiers() {
        return JavacMethodBinding.toInt(this.moduleSymbol.getModifiers());
    }

    public boolean isDeprecated() {
        return this.moduleSymbol.isDeprecated();
    }

    public boolean isRecovered() {
        return this.moduleSymbol.kind == Kinds.Kind.ERR;
    }

    public boolean isSynthetic() {
        return (this.moduleSymbol.flags() & 0x1000L) != 0L;
    }

    public IJavaElement getJavaElement() {
        try {
            IModuleDescription res = this.resolver.javaProject.findModule(this.getName(), this.resolver.getWorkingCopyOwner());
            if (res != null) {
                return res;
            }
            return Arrays.stream(this.resolver.javaProject.getAllPackageFragmentRoots()).map(IPackageFragmentRoot::getModuleDescription).filter(Objects::nonNull).filter(module -> Objects.equals(this.getName(), module.getElementName())).findAny().orElse(null);
        }
        catch (JavaModelException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getKey() {
        return "\"" + this.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof IModuleBinding)) return false;
        IModuleBinding other = (IModuleBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public boolean isOpen() {
        return this.moduleSymbol.isOpen();
    }

    public IModuleBinding[] getRequiredModules() {
        ArrayList<Symbol.ModuleSymbol> mods = new ArrayList<Symbol.ModuleSymbol>();
        this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.REQUIRES).map(x -> ((Directive.RequiresDirective)x).module).forEachOrdered(mods::add);
        if (this.moduleDecl != null) {
            java.util.List directives = this.moduleDecl.getDirectives();
            for (JCTree.JCDirective jcd : directives) {
                Symbol.ModuleSymbol mss;
                if (!(jcd instanceof JCTree.JCRequires)) continue;
                JCTree.JCRequires jcr = (JCTree.JCRequires)jcd;
                JCTree.JCExpression jce = jcr.moduleName;
                if (!(jce instanceof JCTree.JCIdent)) continue;
                JCTree.JCIdent jcid = (JCTree.JCIdent)jce;
                Symbol symbol = jcid.sym;
                if (!(symbol instanceof Symbol.ModuleSymbol) || mods.contains(mss = (Symbol.ModuleSymbol)symbol)) continue;
                mods.add(mss);
            }
        }
        IModuleBinding[] ret = new IModuleBinding[mods.size()];
        for (int i = 0; i < mods.size(); ++i) {
            ret[i] = this.resolver.bindings.getModuleBinding((Symbol.ModuleSymbol)mods.get(i));
        }
        return ret;
    }

    public IPackageBinding[] getExportedPackages() {
        Directive.ExportsDirective[] arr = (Directive.ExportsDirective[])this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.EXPORTS).map(x -> (Directive.ExportsDirective)x).toArray(Directive.ExportsDirective[]::new);
        IPackageBinding[] arr2 = new IPackageBinding[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr2[i] = this.resolver.bindings.getPackageBinding(arr[i].packge);
        }
        return arr2;
    }

    public String[] getExportedTo(IPackageBinding packageBinding) {
        Directive.ExportsDirective[] arr = (Directive.ExportsDirective[])this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.EXPORTS).map(x -> (Directive.ExportsDirective)x).toArray(Directive.ExportsDirective[]::new);
        for (int i = 0; i < arr.length; ++i) {
            JavacPackageBinding tmp = this.resolver.bindings.getPackageBinding(arr[i].packge);
            if (tmp.isUnnamed() != packageBinding.isUnnamed() || !tmp.getName().equals(packageBinding.getName())) continue;
            return (String[])arr[i].getTargetModules().stream().map(Symbol.ModuleSymbol::toString).toArray(String[]::new);
        }
        return new String[0];
    }

    public IPackageBinding[] getOpenedPackages() {
        Directive.OpensDirective[] arr = (Directive.OpensDirective[])this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.OPENS).map(x -> (Directive.OpensDirective)x).toArray(Directive.OpensDirective[]::new);
        IPackageBinding[] arr2 = new IPackageBinding[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr2[i] = this.resolver.bindings.getPackageBinding(arr[i].packge);
        }
        return arr2;
    }

    public String[] getOpenedTo(IPackageBinding packageBinding) {
        Directive.OpensDirective[] arr = (Directive.OpensDirective[])this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.OPENS).map(x -> (Directive.OpensDirective)x).toArray(Directive.OpensDirective[]::new);
        for (int i = 0; i < arr.length; ++i) {
            JavacPackageBinding tmp = this.resolver.bindings.getPackageBinding(arr[i].packge);
            if (tmp.isUnnamed() != packageBinding.isUnnamed() || !tmp.getName().equals(packageBinding.getName())) continue;
            return (String[])arr[i].getTargetModules().stream().map(x -> x.toString()).toArray(String[]::new);
        }
        return new String[0];
    }

    public ITypeBinding[] getUses() {
        Directive.UsesDirective[] arr = (Directive.UsesDirective[])this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.USES).map(x -> (Directive.UsesDirective)x).toArray(Directive.UsesDirective[]::new);
        ITypeBinding[] arr2 = new ITypeBinding[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr2[i] = this.resolver.bindings.getTypeBinding(arr[i].getService().type);
        }
        return arr2;
    }

    public ITypeBinding[] getServices() {
        Directive.ProvidesDirective[] arr = (Directive.ProvidesDirective[])this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.PROVIDES).map(x -> (Directive.ProvidesDirective)x).toArray(Directive.ProvidesDirective[]::new);
        ITypeBinding[] arr2 = new ITypeBinding[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr2[i] = this.resolver.bindings.getTypeBinding(arr[i].getService().type);
        }
        return arr2;
    }

    public ITypeBinding[] getImplementations(ITypeBinding service) {
        Directive.ProvidesDirective[] arr = (Directive.ProvidesDirective[])this.moduleSymbol.getDirectives().stream().filter(x -> x.getKind() == ModuleElement.DirectiveKind.PROVIDES).map(x -> (Directive.ProvidesDirective)x).toArray(Directive.ProvidesDirective[]::new);
        for (int i = 0; i < arr.length; ++i) {
            JavacTypeBinding tmp = this.resolver.bindings.getTypeBinding(arr[i].getService().type);
            if (!service.getKey().equals(tmp.getKey())) continue;
            ITypeBinding[] ret = (JavacTypeBinding[])arr[i].getImplementations().stream().map(x -> this.resolver.bindings.getTypeBinding(x.type)).toArray(JavacTypeBinding[]::new);
            return ret;
        }
        return null;
    }
}

