/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;

public abstract class JavacAnnotationBinding
implements IAnnotationBinding {
    private final JavacBindingResolver resolver;
    private final Attribute.Compound annotation;
    private final IBinding recipient;

    public JavacAnnotationBinding(Attribute.Compound ann, JavacBindingResolver resolver, IBinding recipient) {
        this.resolver = resolver;
        this.annotation = ann;
        this.recipient = recipient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacAnnotationBinding)) return false;
        JavacAnnotationBinding other = (JavacAnnotationBinding)obj;
        if (!Objects.equals((Object)this.resolver, (Object)other.resolver)) return false;
        if (!Objects.equals(this.annotation, other.annotation)) return false;
        if (!Objects.equals(this.recipient, other.recipient)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resolver, this.annotation, this.recipient});
    }

    public IAnnotationBinding[] getAnnotations() {
        return new IAnnotationBinding[0];
    }

    public int getKind() {
        return 5;
    }

    public int getModifiers() {
        return this.getAnnotationType().getModifiers();
    }

    public boolean isDeprecated() {
        return this.getAnnotationType().isDeprecated();
    }

    public boolean isRecovered() {
        return this.getAnnotationType().isRecovered();
    }

    public boolean isSynthetic() {
        return this.getAnnotationType().isSynthetic();
    }

    public IJavaElement getJavaElement() {
        return this.getAnnotationType().getJavaElement();
    }

    public String getKey() {
        StringBuilder builder = new StringBuilder();
        if (this.recipient != null) {
            builder.append(this.recipient.getKey());
        }
        builder.append('@');
        ITypeBinding annotationType = this.getAnnotationType();
        if (annotationType != null) {
            builder.append(this.getAnnotationType().getKey());
        } else {
            ILog.get().error("missing annotation type");
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEqualTo(IBinding binding) {
        if (!(binding instanceof IAnnotationBinding)) return false;
        IAnnotationBinding other = (IAnnotationBinding)binding;
        if (!Objects.equals(this.getKey(), other.getKey())) return false;
        return true;
    }

    public IMemberValuePairBinding[] getAllMemberValuePairs() {
        return (IMemberValuePairBinding[])this.annotation.getElementValues().entrySet().stream().map(entry -> this.resolver.bindings.getMemberValuePairBinding((Symbol.MethodSymbol)entry.getKey(), (Attribute)entry.getValue())).filter(Objects::nonNull).toArray(IMemberValuePairBinding[]::new);
    }

    public ITypeBinding getAnnotationType() {
        return this.resolver.bindings.getTypeBinding(this.annotation.type);
    }

    public IMemberValuePairBinding[] getDeclaredMemberValuePairs() {
        return this.getAllMemberValuePairs();
    }

    public String getName() {
        return this.getAnnotationType().getName();
    }

    public String toString() {
        return "@" + this.getName() + "(" + Arrays.stream(this.getAllMemberValuePairs()).map(IBinding::toString).collect(Collectors.joining(",")) + ")";
    }
}

