/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core.model;

import com.microsoft.jdtls.ext.core.model.TrieNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Trie<T> {
    private TrieNode<T> root = new TrieNode();
    private Set<TrieNode<T>> allNodes = new HashSet<TrieNode<T>>();

    public Trie(Map<String, T> entries) {
        for (Map.Entry<String, T> entry : entries.entrySet()) {
            this.insert(entry.getKey(), entry.getValue());
        }
    }

    public Set<TrieNode<T>> getAllNodes() {
        return this.allNodes;
    }

    public void insert(String name, T value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            this.root.value = value;
            this.allNodes.add(this.root);
            return;
        }
        String[] names = name.split("\\.");
        TrieNode<T> currentNode = this.root;
        int i = 0;
        while (i < names.length) {
            TrieNode<Object> node;
            if (currentNode.children.containsKey(names[i])) {
                node = currentNode.children.get(names[i]);
            } else {
                node = new TrieNode<Object>(names[i], null);
                currentNode.children.put(names[i], node);
                this.allNodes.add(node);
            }
            if (i == names.length - 1) {
                node.value = value;
            }
            currentNode = node;
            ++i;
        }
    }
}

