/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;

public class InnovationContext
implements IInvocationContextCore {
    private final ICompilationUnit fCompilationUnit;
    private CompilationUnit fASTRoot;
    private NodeFinder fNodeFinder;
    private int fSelectionLength;
    private int fSelectionOffset;

    public InnovationContext(ICompilationUnit compilationUnit, int selectionOffset, int selectionLength) {
        this.fCompilationUnit = compilationUnit;
        this.fSelectionLength = selectionLength;
        this.fSelectionOffset = selectionOffset;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public int getSelectionLength() {
        return this.fSelectionLength;
    }

    public int getSelectionOffset() {
        return this.fSelectionOffset;
    }

    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = ASTResolving.createQuickFixAST((ICompilationUnit)this.fCompilationUnit, null);
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit root) {
        this.fASTRoot = root;
    }

    public ASTNode getCoveringNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.fSelectionOffset, this.fSelectionLength);
        }
        return this.fNodeFinder.getCoveringNode();
    }

    public ASTNode getCoveredNode() {
        if (this.fNodeFinder == null) {
            this.fNodeFinder = new NodeFinder((ASTNode)this.getASTRoot(), this.fSelectionOffset, this.fSelectionLength);
        }
        return this.fNodeFinder.getCoveredNode();
    }
}

