"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendStackListVariables = exports.sendStackSelectFrame = exports.sendStackListFramesRequest = exports.sendStackInfoDepth = void 0;
function sendStackInfoDepth(gdb, params) {
    let command = '-stack-info-depth';
    if (params.threadId !== undefined) {
        command += ` --thread ${params.threadId}`;
    }
    if (params.maxDepth) {
        command += ` ${params.maxDepth}`;
    }
    return gdb.sendCommand(command);
}
exports.sendStackInfoDepth = sendStackInfoDepth;
function sendStackListFramesRequest(gdb, params) {
    let command = '-stack-list-frames';
    if (params.threadId !== undefined) {
        command += ` --thread ${params.threadId}`;
    }
    if (params.noFrameFilters) {
        command += ' -no-frame-filters';
    }
    if (params.lowFrame !== undefined) {
        command += ` ${params.lowFrame}`;
    }
    if (params.highFrame !== undefined) {
        command += ` ${params.highFrame}`;
    }
    return gdb.sendCommand(command);
}
exports.sendStackListFramesRequest = sendStackListFramesRequest;
function sendStackSelectFrame(gdb, params) {
    return gdb.sendCommand(`-stack-select-frame ${params.frameNum}`);
}
exports.sendStackSelectFrame = sendStackSelectFrame;
function sendStackListVariables(gdb, params) {
    var _a, _b;
    let command = '-stack-list-variables';
    if (params.noFrameFilters) {
        command += ' --no-frame-filters';
    }
    if (params.skipUnavailable) {
        command += ' --skip-unavailable';
    }
    if (((_a = params.frameRef) === null || _a === void 0 ? void 0 : _a.threadId) !== undefined) {
        command += ` --thread ${params.frameRef.threadId}`;
    }
    if (((_b = params.frameRef) === null || _b === void 0 ? void 0 : _b.frameId) !== undefined) {
        command += ` --frame ${params.frameRef.frameId}`;
    }
    command += ` --${params.printValues}`;
    return gdb.sendCommand(command);
}
exports.sendStackListVariables = sendStackListVariables;
//# sourceMappingURL=stack.js.map