"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
const path = require("path");
const os = require("os");
describe('pause', () => __awaiter(void 0, void 0, void 0, function* () {
    let dc;
    beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
        dc = yield (0, utils_1.standardBeforeEach)();
    }));
    afterEach(() => __awaiter(void 0, void 0, void 0, function* () {
        yield dc.stop();
    }));
    it('can be paused', function () {
        return __awaiter(this, void 0, void 0, function* () {
            if (os.platform() === 'win32' && (!utils_1.isRemoteTest || !utils_1.gdbAsync)) {
                // win32 host can only pause remote + mi-async targets
                this.skip();
            }
            yield dc.launchRequest((0, utils_1.fillDefaults)(this.test, {
                program: path.join(utils_1.testProgramsDir, 'loopforever'),
            }));
            yield dc.configurationDoneRequest();
            const waitForStopped = dc.waitForEvent('stopped');
            const threads = yield dc.threadsRequest();
            const pr = dc.pauseRequest({ threadId: threads.body.threads[0].id });
            yield Promise.all([pr, waitForStopped]);
        });
    });
}));
//# sourceMappingURL=pause.spec.js.map