/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;

public class PushOperationResult {
    private LinkedHashMap<URIish, Entry> urisEntries = new LinkedHashMap();
    private String hookOut;
    private String hookErr;

    public void addOperationResult(URIish uri, PushResult result) {
        this.urisEntries.put(uri, new Entry(result));
    }

    public void addOperationResult(URIish uri, String errorMessage) {
        this.urisEntries.put(uri, new Entry(errorMessage));
    }

    public Set<URIish> getURIs() {
        return Collections.unmodifiableSet(this.urisEntries.keySet());
    }

    public boolean isSuccessfulConnection(URIish uri) {
        return this.urisEntries.get(uri).isSuccessfulConnection();
    }

    public boolean isSuccessfulConnectionForAnyURI() {
        for (URIish uri : this.getURIs()) {
            if (!this.isSuccessfulConnection(uri)) continue;
            return true;
        }
        return false;
    }

    public PushResult getPushResult(URIish uri) {
        return this.urisEntries.get(uri).getResult();
    }

    public String getErrorMessage(URIish uri) {
        return this.urisEntries.get(uri).getErrorMessage();
    }

    public void setHookOutput(String stdout, String stderr) {
        this.hookOut = stdout;
        this.hookErr = stderr;
    }

    public String getHookStdOut() {
        return this.hookOut == null ? "" : this.hookOut;
    }

    public String getHookStdErr() {
        return this.hookErr == null ? "" : this.hookErr;
    }

    public String getErrorStringForAllURis() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (URIish uri : this.getURIs()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(uri);
            sb.append(" (");
            sb.append(this.getErrorMessage(uri));
            sb.append(")");
        }
        return sb.toString();
    }

    public PushOperationSpecification deriveSpecification(boolean requireUnchanged) throws IOException {
        PushOperationSpecification spec = new PushOperationSpecification();
        for (URIish uri : this.getURIs()) {
            PushResult pr = this.getPushResult(uri);
            if (pr == null) continue;
            Collection oldUpdates = pr.getRemoteUpdates();
            ArrayList<RemoteRefUpdate> newUpdates = new ArrayList<RemoteRefUpdate>(oldUpdates.size());
            for (RemoteRefUpdate rru : oldUpdates) {
                Ref advertisedRef;
                ObjectId expectedOldObjectId = requireUnchanged ? ((advertisedRef = this.getPushResult(uri).getAdvertisedRef(rru.getRemoteName())) == null ? ObjectId.zeroId() : advertisedRef.getObjectId()) : rru.getExpectedOldObjectId();
                RemoteRefUpdate newRru = new RemoteRefUpdate(rru, expectedOldObjectId);
                newUpdates.add(newRru);
            }
            spec.addURIRefUpdates(uri, newUpdates);
        }
        return spec;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PushOperationResult)) {
            return false;
        }
        PushOperationResult other = (PushOperationResult)obj;
        Set<URIish> otherURIs = other.getURIs();
        for (URIish uri : this.getURIs()) {
            if (!this.isSuccessfulConnection(uri) || otherURIs.contains(uri) && other.isSuccessfulConnection(uri)) continue;
            return false;
        }
        for (URIish uri : other.getURIs()) {
            if (!other.isSuccessfulConnection(uri) || this.urisEntries.containsKey(uri) && this.isSuccessfulConnection(uri)) continue;
            return false;
        }
        for (URIish uri : this.getURIs()) {
            if (!this.isSuccessfulConnection(uri)) continue;
            PushResult otherPushResult = other.getPushResult(uri);
            for (RemoteRefUpdate rru : this.getPushResult(uri).getRemoteUpdates()) {
                RemoteRefUpdate otherRru = otherPushResult.getRemoteUpdate(rru.getRemoteName());
                if (otherRru == null) {
                    return false;
                }
                if (otherRru.getStatus() == rru.getStatus() && otherRru.getNewObjectId() == rru.getNewObjectId()) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.urisEntries.hashCode();
    }

    private static class Entry {
        private String errorMessage;
        private PushResult result;

        Entry(PushResult result) {
            this.result = result;
        }

        Entry(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        boolean isSuccessfulConnection() {
            return this.result != null;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        PushResult getResult() {
            return this.result;
        }
    }
}

