/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.text.build.PropertiesTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleTextChangeListener;
import org.eclipse.pde.internal.core.text.plugin.FragmentModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.core.text.plugin.XMLTextChangeListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class PDEModelUtility {
    public static final String F_PROPERTIES = ".properties";
    private static final int F_Bi = 0;
    private static final int F_Xi = 1;
    private static Hashtable<IProject, ArrayList<PDEFormEditor>> fOpenPDEEditors = new Hashtable();

    public static void connect(PDEFormEditor editor) {
        IProject project = editor.getCommonProject();
        if (project == null) {
            return;
        }
        if (fOpenPDEEditors.containsKey(project)) {
            ArrayList<PDEFormEditor> list = fOpenPDEEditors.get(project);
            if (!list.contains(editor)) {
                list.add(editor);
            }
        } else {
            ArrayList<PDEFormEditor> list = new ArrayList<PDEFormEditor>();
            list.add(editor);
            fOpenPDEEditors.put(project, list);
        }
    }

    public static void disconnect(PDEFormEditor editor) {
        IEditorInput input;
        IProject project = editor.getCommonProject();
        if (project == null && (input = editor.getEditorInput()) != null && input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            IFile file = fei.getFile();
            project = file.getProject();
        }
        if (project == null) {
            return;
        }
        if (!fOpenPDEEditors.containsKey(project)) {
            return;
        }
        List list = fOpenPDEEditors.get(project);
        list.remove(editor);
        if (list.isEmpty()) {
            fOpenPDEEditors.remove(project);
        }
    }

    public static ManifestEditor getOpenManifestEditor(IProject project) {
        return (ManifestEditor)PDEModelUtility.getOpenEditor(project, "org.eclipse.pde.ui.manifestEditor");
    }

    public static BuildEditor getOpenBuildPropertiesEditor(IProject project) {
        return (BuildEditor)PDEModelUtility.getOpenEditor(project, "org.eclipse.pde.ui.buildEditor");
    }

    public static SiteEditor getOpenUpdateSiteEditor(IProject project) {
        return (SiteEditor)PDEModelUtility.getOpenEditor(project, "org.eclipse.pde.ui.siteEditor");
    }

    private static PDEFormEditor getOpenEditor(IProject project, String editorId) {
        List list = fOpenPDEEditors.get(project);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            PDEFormEditor editor = (PDEFormEditor)list.get(i);
            if (editor.getEditorSite().getId().equals(editorId)) {
                return editor;
            }
            ++i;
        }
        return null;
    }

    public static SchemaEditor getOpenSchemaEditor(IFile file) {
        return (SchemaEditor)PDEModelUtility.getOpenEditor("org.eclipse.pde.ui.schemaEditor", "schema-context", file);
    }

    private static PDEFormEditor getOpenEditor(String editorID, String inputContextID, IFile file) {
        IProject project = file.getProject();
        List list = fOpenPDEEditors.get(project);
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            IFile currentFile;
            IEditorInput input;
            InputContext context;
            PDEFormEditor editor = (PDEFormEditor)list.get(i);
            String currentEditorID = editor.getEditorSite().getId();
            if (currentEditorID.equals(editorID) && (context = editor.getContextManager().findContext(inputContextID)) != null && (input = context.getInput()) instanceof IFileEditorInput && (currentFile = ((IFileEditorInput)input).getFile()).equals((Object)file)) {
                return editor;
            }
            ++i;
        }
        return null;
    }

    public static IPluginModelBase getActivePluginModel() {
        IBaseModel model;
        IEditorPart editor = PDEPlugin.getActivePage().getActiveEditor();
        if (editor instanceof ManifestEditor && (model = ((ManifestEditor)editor).getAggregateModel()) instanceof IPluginModelBase) {
            return (IPluginModelBase)model;
        }
        return null;
    }

    public static IEditingModel getOpenModel(IDocument doc) {
        for (List list : fOpenPDEEditors.values()) {
            int i = 0;
            while (i < list.size()) {
                PDEFormEditor e = (PDEFormEditor)list.get(i);
                IPluginModelBase model = (IPluginModelBase)e.getAggregateModel();
                if (model instanceof IBundlePluginModelBase) {
                    IBundleModel bModel = ((IBundlePluginModelBase)model).getBundleModel();
                    if (bModel instanceof IEditingModel && doc == ((IEditingModel)bModel).getDocument()) {
                        return (IEditingModel)bModel;
                    }
                    ISharedExtensionsModel eModel = ((IBundlePluginModelBase)model).getExtensionsModel();
                    if (eModel instanceof IEditingModel && doc == ((IEditingModel)eModel).getDocument()) {
                        return (IEditingModel)eModel;
                    }
                }
                if (model instanceof IEditingModel && doc == ((IEditingModel)model).getDocument()) {
                    return (IEditingModel)model;
                }
                ++i;
            }
        }
        return null;
    }

    public static void modifyModel(ModelModification modification, IProgressMonitor monitor) {
        IFile file = modification.getFile();
        if (file == null) {
            return;
        }
        PDEFormEditor editor = PDEModelUtility.getOpenEditor(modification);
        IBaseModel model = PDEModelUtility.getModelFromEditor(editor, modification);
        if (model != null) {
            PDEModelUtility.modifyEditorModel(modification, editor, model, monitor);
        } else {
            boolean needUIthread = PDEModelUtility.isEditorOpenedOn(file);
            if (needUIthread) {
                Display.getDefault().execute(() -> PDEModelUtility.generateModelEdits(modification, monitor, true));
            } else {
                PDEModelUtility.generateModelEdits(modification, monitor, true);
            }
        }
    }

    private static boolean isEditorOpenedOn(IFile file) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IFile ifile;
                IEditorReference editorReference = iEditorReferenceArray[n4];
                IEditorPart part = editorReference.getEditor(false);
                if (part != null && file.equals((Object)(ifile = (IFile)Adapters.adapt((Object)part.getEditorInput(), IFile.class)))) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static TextFileChange[] changesForModelModication(ModelModification modification, IProgressMonitor monitor) {
        PDEFormEditor editor = PDEModelUtility.getOpenEditor(modification);
        if (editor != null) {
            Display.getDefault().syncExec(() -> {
                if (editor.isDirty()) {
                    editor.flushEdits();
                }
            });
        }
        return PDEModelUtility.generateModelEdits(modification, monitor, false);
    }

    /*
     * Unable to fully structure code
     */
    private static TextFileChange[] generateModelEdits(ModelModification modification, IProgressMonitor monitor, boolean performEdits) {
        block32: {
            block31: {
                block30: {
                    block33: {
                        edits = new ArrayList<TextFileChange>();
                        manager = FileBuffers.getTextFileBufferManager();
                        files = modification.isFullBundleModification() != false ? new IFile[]{modification.getManifestFile(), modification.getXMLFile()} : new IFile[]{modification.getFile()};
                        sc = 0;
                        buffers = new ITextFileBuffer[files.length];
                        documents = new IDocument[files.length];
                        i = 0;
                        while (i < files.length) {
                            if (files[i] != null && files[i].exists()) {
                                manager.connect(files[i].getFullPath(), LocationKind.NORMALIZE, monitor);
                                ++sc;
                                buffers[i] = manager.getTextFileBuffer(files[i].getFullPath(), LocationKind.NORMALIZE);
                                if (performEdits && buffers[i].isDirty()) {
                                    buffers[i].commit(monitor, true);
                                }
                                documents[i] = buffers[i].getDocument();
                            }
                            ++i;
                        }
                        if (!modification.isFullBundleModification()) break block33;
                        editModel = PDEModelUtility.prepareBundlePluginModel(files, documents, performEdits == false);
                        ** GOTO lbl42
                    }
                    if (documents[0] != null) break block30;
                    var21_12 = new TextFileChange[]{};
                    dc = 0;
                    i = 0;
                    ** while (i < files.length && dc <= sc)
lbl-1000:
                    // 1 sources

                    {
                        if (files[i] != null && files[i].exists()) {
                            try {
                                manager.disconnect(files[i].getFullPath(), LocationKind.NORMALIZE, monitor);
                                ++dc;
                            }
                            catch (CoreException e) {
                                PDEPlugin.log(e);
                            }
                        }
                        ++i;
                        continue;
                    }
lbl37:
                    // 1 sources

                    return var21_12;
                }
                try {
                    try {
                        editModel = PDEModelUtility.prepareAbstractEditingModel(files[0], documents[0], performEdits == false);
lbl42:
                        // 2 sources

                        modification.modifyModel(editModel, monitor);
                        listeners = PDEModelUtility.gatherListeners(editModel);
                        i = 0;
                        while (i < listeners.length) {
                            if (listeners[i] != null && (currentEdits = listeners[i].getTextOperations()).length > 0) {
                                multi = new MultiTextEdit();
                                multi.addChildren(currentEdits);
                                if (performEdits) {
                                    multi.apply(documents[i]);
                                    buffers[i].commit(monitor, true);
                                }
                                change = new TextFileChange(files[i].getName(), files[i]);
                                change.setEdit((TextEdit)multi);
                                if (!performEdits) {
                                    var18_33 = currentEdits;
                                    var17_32 = currentEdits.length;
                                    var16_31 = 0;
                                    while (var16_31 < var17_32) {
                                        edit = var18_33[var16_31];
                                        name = listeners[i].getReadableName(edit);
                                        if (name != null) {
                                            change.addTextEditGroup(new TextEditGroup(name, edit));
                                        }
                                        ++var16_31;
                                    }
                                }
                                change.setSaveMode(2);
                                PDEModelUtility.setChangeTextType(change, files[i]);
                                edits.add(change);
                            }
                            ++i;
                        }
                        break block31;
                    }
                    catch (CoreException | BadLocationException | MalformedTreeException e) {
                        PDEPlugin.log(e);
                        dc = 0;
                        i = 0;
                        ** while (i < files.length && dc <= sc)
                    }
                }
                catch (Throwable var20_35) {
                    dc = 0;
                    i = 0;
                    ** while (i < files.length && dc <= sc)
                }
lbl-1000:
                // 1 sources

                {
                    if (files[i] != null && files[i].exists()) {
                        try {
                            manager.disconnect(files[i].getFullPath(), LocationKind.NORMALIZE, monitor);
                            ++dc;
                        }
                        catch (CoreException e) {
                            PDEPlugin.log(e);
                        }
                    }
                    ++i;
                    continue;
lbl87:
                    // 1 sources

                    break block32;
                }
lbl-1000:
                // 1 sources

                {
                    if (files[i] != null && files[i].exists()) {
                        try {
                            manager.disconnect(files[i].getFullPath(), LocationKind.NORMALIZE, monitor);
                            ++dc;
                        }
                        catch (CoreException e) {
                            PDEPlugin.log(e);
                        }
                    }
                    ++i;
                    continue;
                }
lbl101:
                // 1 sources

                throw var20_35;
            }
            dc = 0;
            i = 0;
            while (i < files.length && dc <= sc) {
                if (files[i] != null && files[i].exists()) {
                    try {
                        manager.disconnect(files[i].getFullPath(), LocationKind.NORMALIZE, monitor);
                        ++dc;
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
                ++i;
            }
        }
        return edits.toArray(new TextFileChange[edits.size()]);
    }

    public static void setChangeTextType(TextFileChange change, IFile file) {
        String name = file.getName();
        if (name == null) {
            return;
        }
        String textType = name.equals("plugin.xml") || name.equals("fragment.xml") ? "PLUGIN2" : file.getFileExtension();
        change.setTextType(textType);
    }

    private static void modifyEditorModel(ModelModification mod, PDEFormEditor editor, IBaseModel model, IProgressMonitor monitor) {
        PDEModelUtility.getDisplay().syncExec(() -> {
            try {
                IFile[] files;
                mod.modifyModel(model, monitor);
                IFile[] iFileArray = files = new IFile[]{mod.getManifestFile(), mod.getXMLFile(), mod.getPropertiesFile()};
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    InputContext con;
                    InputContextManager manager;
                    IFile file = iFileArray[n2];
                    if (file != null && (manager = editor.getContextManager()) != null && (con = manager.findContext((IResource)file)) != null) {
                        con.flushEditorInput();
                    }
                    ++n2;
                }
                if (mod.saveOpenEditor()) {
                    editor.doSave(monitor);
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        });
    }

    private static PDEFormEditor getOpenEditor(ModelModification modification) {
        IProject project = modification.getFile().getProject();
        String name = modification.getFile().getName();
        if (name.equals("plugin.xml") || name.equals("fragment.xml") || name.equals("MANIFEST.MF")) {
            return PDEModelUtility.getOpenManifestEditor(project);
        }
        if (name.equals("build.properties")) {
            MultiSourceEditor openEditor = PDEModelUtility.getOpenBuildPropertiesEditor(project);
            if (openEditor == null) {
                openEditor = PDEModelUtility.getOpenManifestEditor(project);
            }
            return openEditor;
        }
        return null;
    }

    private static IBaseModel getModelFromEditor(PDEFormEditor openEditor, ModelModification modification) {
        if (openEditor == null) {
            return null;
        }
        String name = modification.getFile().getName();
        IBaseModel model = null;
        if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
            model = openEditor.getAggregateModel();
            if (model instanceof IBundlePluginModelBase) {
                model = ((IBundlePluginModelBase)model).getExtensionsModel();
            }
        } else if (name.equals("build.properties")) {
            IFormPage page;
            if (openEditor instanceof BuildEditor) {
                model = openEditor.getAggregateModel();
            } else if (openEditor instanceof ManifestEditor && (page = openEditor.findPage("build-context")) instanceof BuildSourcePage) {
                model = ((BuildSourcePage)page).getInputContext().getModel();
            }
        } else if (name.equals("MANIFEST.MF") && (model = openEditor.getAggregateModel()) instanceof IBundlePluginModelBase) {
            return model;
        }
        if (model instanceof AbstractEditingModel) {
            return model;
        }
        return null;
    }

    private static IModelTextChangeListener createListener(String filename, IDocument doc, boolean generateEditNames) {
        if (filename.equals("plugin.xml") || filename.equals("fragment.xml")) {
            return new XMLTextChangeListener(doc, generateEditNames);
        }
        if (filename.equals("MANIFEST.MF")) {
            return new BundleTextChangeListener(doc, generateEditNames);
        }
        if (filename.endsWith(F_PROPERTIES)) {
            return new PropertiesTextChangeListener(doc, generateEditNames);
        }
        return null;
    }

    private static AbstractEditingModel prepareAbstractEditingModel(IFile file, IDocument doc, boolean generateEditNames) {
        BundleModel model;
        String filename = file.getName();
        if (filename.equals("MANIFEST.MF")) {
            model = new BundleModel(doc, true);
        } else if (filename.equals("fragment.xml")) {
            model = new FragmentModel(doc, true);
        } else if (filename.equals("plugin.xml")) {
            model = new PluginModel(doc, true);
        } else if (filename.endsWith(F_PROPERTIES)) {
            model = new BuildModel(doc, true);
        } else {
            return null;
        }
        model.setUnderlyingResource((IResource)file);
        try {
            model.load();
            IModelTextChangeListener listener = PDEModelUtility.createListener(filename, doc, generateEditNames);
            model.addModelChangedListener((IModelChangedListener)listener);
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
        return model;
    }

    private static IBaseModel prepareBundlePluginModel(IFile[] files, IDocument[] docs, boolean generateEditNames) {
        AbstractEditingModel[] models = new AbstractEditingModel[docs.length];
        boolean isFragment = false;
        models[0] = PDEModelUtility.prepareAbstractEditingModel(files[0], docs[0], generateEditNames);
        if (models[0] instanceof IBundleModel) {
            isFragment = ((IBundleModel)models[0]).getBundle().getHeader("Fragment-Host") != null;
        }
        Object pluginModel = isFragment ? new BundleFragmentModel() : new BundlePluginModel();
        pluginModel.setBundleModel((IBundleModel)models[0]);
        if (files.length > 1 && files[1] != null) {
            models[1] = PDEModelUtility.prepareAbstractEditingModel(files[1], docs[1], generateEditNames);
            pluginModel.setExtensionsModel((ISharedExtensionsModel)models[1]);
        }
        return pluginModel;
    }

    private static IModelTextChangeListener[] gatherListeners(IBaseModel editModel) {
        IModelTextChangeListener[] listeners = new IModelTextChangeListener[]{};
        if (editModel instanceof AbstractEditingModel) {
            listeners = new IModelTextChangeListener[]{((AbstractEditingModel)editModel).getLastTextChangeListener()};
        }
        if (editModel instanceof IBundlePluginModelBase) {
            IBundlePluginModelBase modelBase = (IBundlePluginModelBase)editModel;
            listeners = new IModelTextChangeListener[]{PDEModelUtility.gatherListener((IBaseModel)modelBase.getBundleModel()), PDEModelUtility.gatherListener((IBaseModel)modelBase.getExtensionsModel())};
            return listeners;
        }
        return listeners;
    }

    private static IModelTextChangeListener gatherListener(IBaseModel model) {
        if (model instanceof AbstractEditingModel) {
            return ((AbstractEditingModel)model).getLastTextChangeListener();
        }
        return null;
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

