/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.model.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLElement {
    private static final Pattern START_ELEMENT_NAME_PATTERN = Pattern.compile("<\\s*(?<name>\\w*).*", 32);
    private static final Pattern END_ELEMENT_NAME_PATTERN = Pattern.compile("</\\s*(?<name>\\w*).*", 32);
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("((?<key>\\w*)\\s*=\\s*\"(?<value>.*?)\")", 32);
    private static final Pattern START_ELEMENT_PATTERN = Pattern.compile("<[^/].*", 32);
    private static final Pattern END_ELEMENT_PATTERN = Pattern.compile("</.*|.*/>.*", 32);
    private final String element;
    private final int offset;
    private final String name;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final boolean isEndElement;
    private final boolean isStartElement;

    public XMLElement(String element, int offset) {
        this.element = element;
        this.offset = offset;
        this.isEndElement = END_ELEMENT_PATTERN.matcher(element).matches();
        this.isStartElement = START_ELEMENT_PATTERN.matcher(element).matches();
        Pattern namePattern = this.isStartElement() ? START_ELEMENT_NAME_PATTERN : END_ELEMENT_NAME_PATTERN;
        Matcher nameMatcher = namePattern.matcher(element);
        nameMatcher.matches();
        this.name = nameMatcher.group("name");
        Matcher attrMatcher = ATTRIBUTE_PATTERN.matcher(element);
        while (attrMatcher.find()) {
            String key = attrMatcher.group("key");
            String value = attrMatcher.group("value");
            this.attributes.put(key, value);
        }
    }

    public boolean isEndElement() {
        return this.isEndElement;
    }

    public boolean isStartElement() {
        return this.isStartElement;
    }

    public int getStartOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.offset + this.element.length();
    }

    public String getAttributeValueByKey(String key) {
        return this.attributes.get(key);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.element;
    }
}

