/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.ArrayList;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CNFOutlinePage
implements IContentOutlinePage,
ILabelProviderListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String ID = "org.eclipse.lsp4e.outline";
    public static final String LINK_WITH_EDITOR_PREFERENCE = "org.eclipse.lsp4e.outline.linkWithEditor";
    public static final String SHOW_KIND_PREFERENCE = "org.eclipse.lsp4e.outline.showKind";
    public static final String SORT_OUTLINE_PREFERENCE = "org.eclipse.lsp4e.outline.sortOutline";
    public static final String HIDE_DOCUMENT_SYMBOL_KIND_PREFERENCE_PREFIX = "org.eclipse.lsp4e.outline.hide";
    private CommonViewer outlineViewer = (CommonViewer)NullSafetyHelper.lateNonNull();
    private final IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
    private final @Nullable ITextEditor textEditor;
    private final @Nullable ITextViewer textEditorViewer;
    private final @Nullable IDocument document;
    private final LanguageServerWrapper wrapper;
    private @Nullable EditorSelectionChangedListener editorSelectionChangedListener;

    public CNFOutlinePage(LanguageServerWrapper wrapper, @Nullable ITextEditor textEditor) {
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.textEditor = textEditor;
        this.textEditorViewer = LSPEclipseUtils.getTextViewer((IEditorPart)textEditor);
        this.document = LSPEclipseUtils.getDocument(textEditor);
        this.wrapper = wrapper;
    }

    public void createControl(Composite parent) {
        this.outlineViewer = new CommonViewer(ID, parent, 0);
        if (this.document != null) {
            this.outlineViewer.setInput((Object)new LSSymbolsContentProvider.OutlineViewerInput(this.document, this.wrapper, this.textEditor));
        }
        this.outlineViewer.setSorter((ViewerSorter)new CommonViewerSorter());
        this.outlineViewer.getLabelProvider().addListener((ILabelProviderListener)this);
        ITextEditor textEditor = this.textEditor;
        if (textEditor != null) {
            this.outlineViewer.addOpenListener(event -> {
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true)) {
                    textEditor.setFocus();
                }
            });
            this.outlineViewer.addSelectionChangedListener(event -> {
                TreeSelection sel;
                Range range;
                ISelection iSelection;
                IDocument document = this.document;
                if (document != null && this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true) && this.outlineViewer.getTree().isFocusControl() && (iSelection = this.outlineViewer.getSelection()) instanceof TreeSelection && (range = this.getRangeSelection((sel = (TreeSelection)iSelection).getFirstElement())) != null) {
                    try {
                        int startOffset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                        int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
                        textEditor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                    catch (BadLocationException e) {
                        return;
                    }
                }
            });
            ITextViewer textEditorViewer = this.textEditorViewer;
            if (textEditorViewer != null) {
                this.editorSelectionChangedListener = new EditorSelectionChangedListener();
                this.editorSelectionChangedListener.install(textEditorViewer.getSelectionProvider());
            }
        }
    }

    private @Nullable Range getRangeSelection(@Nullable Object selection) {
        if (selection == null) {
            return null;
        }
        if (selection instanceof SymbolInformation) {
            SymbolInformation symbolInformation = (SymbolInformation)selection;
            return symbolInformation.getLocation().getRange();
        }
        if (selection instanceof SymbolsModel.DocumentSymbolWithURI) {
            SymbolsModel.DocumentSymbolWithURI symbolWithURI = (SymbolsModel.DocumentSymbolWithURI)selection;
            return symbolWithURI.symbol.getSelectionRange();
        }
        return null;
    }

    public static void refreshTreeSelection(TreeViewer viewer, int offset, IDocument document) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        Object[] objects = contentProvider.getElements(null);
        ArrayList<Object> path = new ArrayList<Object>();
        while (objects != null && objects.length > 0) {
            boolean found = false;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Range range = CNFOutlinePage.toRange(object);
                if (range != null && CNFOutlinePage.isOffsetInRange(offset, range, document)) {
                    objects = contentProvider.getChildren(object);
                    path.add(object);
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) break;
        }
        if (!path.isEmpty()) {
            Object bestNode = path.get(path.size() - 1);
            if (bestNode.equals(viewer.getStructuredSelection().getFirstElement())) {
                return;
            }
            UI.runOnUIThread(() -> {
                if (!viewer.getControl().isDisposed()) {
                    TreePath treePath = new TreePath(path.toArray());
                    viewer.reveal((Object)treePath);
                    viewer.setSelection((ISelection)new TreeSelection(treePath), true);
                }
            });
        }
    }

    private static @Nullable Range toRange(Object object) {
        SymbolInformation symbolInformation;
        SymbolInformation symbol;
        Range range = null;
        SymbolInformation symbolInformation2 = symbol = object instanceof SymbolInformation ? (symbolInformation = (SymbolInformation)object) : (SymbolInformation)Adapters.adapt((Object)object, SymbolInformation.class);
        if (symbol != null) {
            range = symbol.getLocation().getRange();
        } else {
            SymbolsModel.DocumentSymbolWithURI symbolWithURI;
            SymbolsModel.DocumentSymbolWithURI documentSymbol;
            SymbolsModel.DocumentSymbolWithURI documentSymbolWithURI = documentSymbol = object instanceof SymbolsModel.DocumentSymbolWithURI ? (symbolWithURI = (SymbolsModel.DocumentSymbolWithURI)object) : (SymbolsModel.DocumentSymbolWithURI)Adapters.adapt((Object)object, SymbolsModel.DocumentSymbolWithURI.class);
            if (documentSymbol != null) {
                range = documentSymbol.symbol.getRange();
            }
        }
        return range;
    }

    private static boolean isOffsetInRange(int offset, Range range, IDocument document) {
        block3: {
            try {
                int startOffset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                if (startOffset <= offset) break block3;
                return false;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
        return endOffset >= offset;
    }

    public void collapseTree() {
        this.outlineViewer.collapseAll();
    }

    public void dispose() {
        this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.outlineViewer.dispose();
        if (this.textEditorViewer != null && this.editorSelectionChangedListener != null) {
            this.editorSelectionChangedListener.uninstall(this.textEditorViewer.getSelectionProvider());
        }
    }

    public @Nullable Control getControl() {
        return this.outlineViewer.getControl();
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.outlineViewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.outlineViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.outlineViewer.setSelection(selection);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.outlineViewer.refresh(true);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (SORT_OUTLINE_PREFERENCE.equals(event.getKey()) && NullSafetyHelper.castNullable(this.outlineViewer) != null) {
            this.outlineViewer.refresh();
        }
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IDocument document = CNFOutlinePage.this.document;
            if (document == null) {
                return;
            }
            ISelection selection = event.getSelection();
            if (selection instanceof ITextSelection) {
                int n;
                ITextSelection textSelection = (ITextSelection)selection;
                if (!CNFOutlinePage.this.preferences.getBoolean(CNFOutlinePage.LINK_WITH_EDITOR_PREFERENCE, true)) {
                    return;
                }
                CommonViewer commonViewer = CNFOutlinePage.this.outlineViewer;
                if (commonViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension5 = (ITextViewerExtension5)commonViewer;
                    n = extension5.widgetOffset2ModelOffset(textSelection.getOffset());
                } else {
                    n = textSelection.getOffset();
                }
                int offset = n;
                CNFOutlinePage.refreshTreeSelection((TreeViewer)CNFOutlinePage.this.outlineViewer, offset, document);
            }
        }
    }
}

