/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.CBreakIterator;

public class NameComposer {
    private static final int CAPITALIZATION_ORIGINAL = 0;
    private static final int CAPITALIZATION_UPPER_CASE = 1;
    private static final int CAPITALIZATION_LOWER_CASE = 2;
    private static final int CAPITALIZATION_CAMEL_CASE = 3;
    private static final int CAPITALIZATION_LOWER_CAMEL_CASE = 4;
    private static final int[] ALL_CAPITALIZATIONS;
    private int capitalization;
    private final String wordDelimiter;
    private final String prefix;
    private String suffix;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        ALL_CAPITALIZATIONS = nArray;
    }

    public NameComposer(int capitalization, String wordDelimiter, String prefix, String suffix) {
        this.capitalization = capitalization;
        this.wordDelimiter = wordDelimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public String compose(CharSequence seedName) {
        List<CharSequence> words = NameComposer.splitIntoWords(seedName);
        return this.compose(words);
    }

    public String compose(List<CharSequence> words) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.prefix);
        int i = 0;
        while (i < words.size()) {
            if (i > 0) {
                buf.append(this.wordDelimiter);
            }
            CharSequence word = words.get(i);
            switch (this.capitalization) {
                case 0: {
                    buf.append(word);
                    break;
                }
                case 1: {
                    this.appendUpperCase(buf, word);
                    break;
                }
                case 2: {
                    this.appendLowerCase(buf, word);
                    break;
                }
                case 3: {
                    this.appendTitleCase(buf, word);
                    break;
                }
                case 4: {
                    if (i == 0) {
                        this.appendLowerCase(buf, word);
                        break;
                    }
                    this.appendTitleCase(buf, word);
                }
            }
            ++i;
        }
        buf.append(this.suffix);
        return buf.toString();
    }

    public static List<CharSequence> splitIntoWords(CharSequence name) {
        int end;
        ArrayList<CharSequence> words = new ArrayList<CharSequence>();
        CBreakIterator iterator = new CBreakIterator();
        iterator.setText(name);
        int start = iterator.first();
        while ((end = iterator.next()) != -1) {
            if (Character.isLetterOrDigit(name.charAt(start))) {
                int pos = end;
                while (--pos >= start && !Character.isLetterOrDigit(name.charAt(pos))) {
                }
                words.add(name.subSequence(start, pos + 1));
            }
            start = end;
        }
        return words;
    }

    private void appendUpperCase(StringBuilder buf, CharSequence word) {
        int i = 0;
        while (i < word.length()) {
            buf.append(Character.toUpperCase(word.charAt(i)));
            ++i;
        }
    }

    private void appendLowerCase(StringBuilder buf, CharSequence word) {
        int i = 0;
        while (i < word.length()) {
            buf.append(Character.toLowerCase(word.charAt(i)));
            ++i;
        }
    }

    private void appendTitleCase(StringBuilder buf, CharSequence word) {
        int i = 0;
        while (i < word.length()) {
            buf.append(i == 0 ? Character.toUpperCase(word.charAt(i)) : Character.toLowerCase(word.charAt(i)));
            ++i;
        }
    }

    public static NameComposer createByExample(String seedName, String composedName, int defaultCapitalization, String defaultWordDelimiter) {
        int i;
        List<CharSequence> seedWords = NameComposer.splitIntoWords(seedName);
        if (seedWords.isEmpty()) {
            return null;
        }
        List<CharSequence> composedWords = NameComposer.splitIntoWords(composedName);
        String delimiter = defaultWordDelimiter;
        int numPrefixWords = NameComposer.indexOfSublistIgnoreCase(composedWords, seedWords);
        if (numPrefixWords < 0) {
            delimiter = "";
            seedWords = Collections.singletonList(seedName);
            numPrefixWords = NameComposer.indexOfSublistIgnoreCase(composedWords, seedWords);
            if (numPrefixWords < 0) {
                return null;
            }
        }
        String prefix = NameComposer.deducePrefix(composedName, numPrefixWords);
        if (seedWords.size() > 1) {
            int start;
            delimiter = "";
            i = start = prefix.length() + composedWords.get(numPrefixWords).length();
            while (i < composedName.length()) {
                if (Character.isLetterOrDigit(composedName.charAt(i))) {
                    delimiter = composedName.substring(start, i);
                    break;
                }
                ++i;
            }
        }
        NameComposer composer = new NameComposer(defaultCapitalization, delimiter, prefix, "");
        i = -1;
        while (i < ALL_CAPITALIZATIONS.length) {
            String name;
            if (i >= 0) {
                composer.capitalization = ALL_CAPITALIZATIONS[i];
            }
            if (composedName.startsWith(name = composer.compose(seedWords))) {
                composer.suffix = composedName.substring(name.length());
                return composer;
            }
            ++i;
        }
        return null;
    }

    private static int indexOfSublistIgnoreCase(List<CharSequence> list, List<CharSequence> subList) {
        int subListSize = subList.size();
        int limit = list.size() - subListSize;
        int k = 0;
        while (k <= limit) {
            block3: {
                int i = 0;
                int j = k;
                while (i < subListSize) {
                    if (subList.get(i).toString().equalsIgnoreCase(list.get(j).toString())) {
                        ++i;
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return k;
            }
            ++k;
        }
        return -1;
    }

    private static String deducePrefix(CharSequence name, int numPrefixWords) {
        int end;
        CBreakIterator iterator = new CBreakIterator();
        iterator.setText(name);
        int wordCount = 0;
        int start = iterator.first();
        while ((end = iterator.next()) != -1) {
            if (Character.isLetterOrDigit(name.charAt(start))) {
                if (wordCount == numPrefixWords) {
                    return name.subSequence(0, start).toString();
                }
                ++wordCount;
            }
            start = end;
        }
        if (wordCount == numPrefixWords) {
            return name.toString();
        }
        throw new IllegalArgumentException(numPrefixWords + " is larger than the number of words in \"" + String.valueOf(name) + "\"");
    }
}

