/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.apache.connector;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.glassfish.jersey.apache.connector.ApacheConnector;
import org.glassfish.jersey.apache.connector.LocalizationMessages;
import org.glassfish.jersey.client.Initializable;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class ApacheConnectorProvider
implements ConnectorProvider {
    public Connector getConnector(Client client, Configuration runtimeConfig) {
        return new ApacheConnector(client, runtimeConfig);
    }

    public static HttpClient getHttpClient(Configurable<?> component) {
        return ApacheConnectorProvider.getConnector(component).getHttpClient();
    }

    public static CookieStore getCookieStore(Configurable<?> component) {
        return ApacheConnectorProvider.getConnector(component).getCookieStore();
    }

    private static ApacheConnector getConnector(Configurable<?> component) {
        if (!(component instanceof Initializable)) {
            throw new IllegalArgumentException(LocalizationMessages.INVALID_CONFIGURABLE_COMPONENT_TYPE(component.getClass().getName()));
        }
        Initializable initializable = (Initializable)component;
        Connector connector = initializable.getConfiguration().getConnector();
        if (connector == null) {
            initializable.preInitialize();
            connector = initializable.getConfiguration().getConnector();
        }
        if (connector instanceof ApacheConnector) {
            return (ApacheConnector)connector;
        }
        throw new IllegalArgumentException(LocalizationMessages.EXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }
}

