/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.HashTable;

public class CharTable
extends HashTable {
    protected char[][] keyTable = new char[this.capacity()][];

    public CharTable(int initialSize) {
        super(initialSize);
    }

    @Override
    protected void resize(int size) {
        char[][] oldKeyTable = this.keyTable;
        this.keyTable = new char[size][];
        System.arraycopy(oldKeyTable, 0, this.keyTable, 0, Math.min(size, oldKeyTable.length));
        super.resize(size);
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill((Object[])this.keyTable, null);
    }

    @Override
    public Object clone() {
        CharTable newTable = (CharTable)super.clone();
        int size = this.capacity();
        newTable.keyTable = new char[size][];
        System.arraycopy(this.keyTable, 0, newTable.keyTable, 0, this.keyTable.length);
        return newTable;
    }

    protected final int hash(char[] source, int start, int length) {
        return this.hashTable == null ? 0 : this.hashToOffset(CharArrayUtils.hash(source, start, length));
    }

    @Override
    protected final int hash(int pos) {
        return this.hash(this.keyTable[pos], 0, this.keyTable[pos].length);
    }

    protected final int hash(char[] obj) {
        return this.hash(obj, 0, obj.length);
    }

    protected final int addIndex(char[] buffer) {
        return this.addIndex(buffer, 0, buffer.length);
    }

    public final int addIndex(char[] buffer, int start, int len) {
        if (this.hashTable == null) {
            int pos = this.lookup(buffer, start, len);
            if (pos != -1) {
                return pos;
            }
            if (this.currEntry + 1 >= this.capacity()) {
                this.resize();
                if (this.hashTable != null) {
                    return this.addIndex(buffer, start, len);
                }
            }
            ++this.currEntry;
            this.keyTable[this.currEntry] = CharArrayUtils.extract(buffer, start, len);
        } else {
            int hash = this.hash(buffer, start, len);
            int pos = this.lookup(buffer, start, len, hash);
            if (pos != -1) {
                return pos;
            }
            if (this.currEntry + 1 >= this.capacity()) {
                this.resize();
                hash = this.hash(buffer, start, len);
            }
            ++this.currEntry;
            this.keyTable[this.currEntry] = CharArrayUtils.extract(buffer, start, len);
            this.linkIntoHashTable(this.currEntry, hash);
        }
        return this.currEntry;
    }

    protected void removeEntry(int i) {
        int hash = this.hash(this.keyTable[i]);
        if (i < this.currEntry) {
            System.arraycopy(this.keyTable, i + 1, this.keyTable, i, this.currEntry - i);
        }
        this.keyTable[this.currEntry] = null;
        this.removeEntry(i, hash);
    }

    public List<char[]> toList() {
        ArrayList<char[]> list = new ArrayList<char[]>(this.size());
        int size = this.size();
        int i = 0;
        while (i < size) {
            list.add(this.keyAt(i));
            ++i;
        }
        return list;
    }

    public final char[] keyAt(int i) {
        if (i < 0 || i > this.currEntry) {
            return null;
        }
        return this.keyTable[i];
    }

    public final boolean containsKey(char[] key, int start, int len) {
        return this.lookup(key, start, len) != -1;
    }

    public final boolean containsKey(char[] key) {
        return this.lookup(key) != -1;
    }

    public final char[] findKey(char[] buffer, int start, int len) {
        int idx = this.lookup(buffer, start, len);
        if (idx == -1) {
            return null;
        }
        return this.keyTable[idx];
    }

    public int lookup(char[] buffer) {
        return this.lookup(buffer, 0, buffer.length);
    }

    protected final int lookup(char[] buffer, int start, int len) {
        if (this.hashTable != null) {
            return this.lookup(buffer, start, len, this.hash(buffer, start, len));
        }
        int i = 0;
        while (i <= this.currEntry) {
            if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected final int lookup(char[] buffer, int start, int len, int hash) {
        int i = this.hashTable[hash];
        if (i == 0) {
            return -1;
        }
        if (CharArrayUtils.equals(buffer, start, len, this.keyTable[--i])) {
            return i;
        }
        i = this.nextTable[i] - 1;
        while (i >= 0 && i != this.nextTable[i] - 1) {
            if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
                return i;
            }
            i = this.nextTable[i] - 1;
        }
        return -1;
    }

    public char[][] keys() {
        char[][] keys = new char[this.size()][];
        System.arraycopy(this.keyTable, 0, keys, 0, keys.length);
        return keys;
    }

    @Deprecated
    public Object[] keyArray() {
        return this.keys();
    }
}

