/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.cdt.debug.internal.core.sourcelookup.ICSourceNotFoundDescription;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CSourceNotFoundEditor
extends CommonSourceNotFoundEditor {
    private static final String SOURCE_NOT_FOUND_PATH = "org.eclipse.cdt.debug.ui.CDebugPreferencePage";
    public final String foundMappingsContainerName = "Found Mappings";
    private static final String UID_KEY = ".uid";
    private static final String UID_CLASS_NAME = CSourceNotFoundEditor.class.getName();
    public static final String UID_DISASSEMBLY_BUTTON = UID_CLASS_NAME + "disassemblyButton";
    public static final String UID_LOCATE_FILE_BUTTON = UID_CLASS_NAME + "locateFileButton";
    public static final String UID_EDIT_LOOKUP_BUTTON = UID_CLASS_NAME + "editLookupButton";
    public static final String UID_OPEN_PREFERENCE_BUTTON = UID_CLASS_NAME + "preferenceButton";
    private String missingFile = "";
    private ILaunchConfiguration launch;
    private IAdaptable context;
    private ITranslationUnit tunit;
    private boolean isDebugElement;
    private boolean isTranslationUnit;
    private EditorControls controls;

    public void createPartControl(Composite parent) {
        GridLayout topLayout = new GridLayout();
        GridData data = new GridData();
        topLayout.numColumns = 1;
        topLayout.verticalSpacing = 10;
        parent.setLayout((Layout)topLayout);
        parent.setLayoutData((Object)data);
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        this.controls = new EditorControls();
        this.controls.fText = new Text(parent, 72);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.controls.fText.setLayoutData((Object)data);
        this.controls.fText.setForeground(parent.getDisplay().getSystemColor(2));
        this.controls.fText.setBackground(parent.getDisplay().getSystemColor(1));
        this.createButtons(parent);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ICDebugHelpContextIds.SOURCE_NOT_FOUND);
        if (this.getEditorInput() != null) {
            this.setInput(this.getEditorInput());
        }
        this.syncButtons();
    }

    public void setFocus() {
        if (this.controls != null) {
            this.controls.fText.setFocus();
        }
    }

    public void setInput(IEditorInput input) {
        if (input instanceof CSourceNotFoundEditorInput) {
            this.isDebugElement = false;
            this.isTranslationUnit = false;
            Object artifact = ((CSourceNotFoundEditorInput)input).getArtifact();
            if (artifact instanceof CSourceNotFoundElement) {
                CSourceNotFoundElement element = (CSourceNotFoundElement)artifact;
                this.missingFile = element.getFile();
                this.launch = element.getLaunch();
                this.context = element.getElement();
                this.isDebugElement = true;
            } else if (artifact instanceof ITranslationUnit) {
                this.isTranslationUnit = true;
                this.tunit = (ITranslationUnit)artifact;
                IPath tuPath = this.tunit.getLocation();
                if (tuPath != null) {
                    this.missingFile = tuPath.toOSString();
                }
            } else {
                this.missingFile = "";
            }
        }
        super.setInput(input);
        if (this.controls != null) {
            this.controls.fText.setText(this.getText());
        }
        this.syncButtons();
    }

    private void syncButtons() {
        if (this.controls != null) {
            boolean missingFileNameKnown = this.missingFile.length() > 0;
            boolean disassemblyButtonVisible = this.isDebugElement;
            this.controls.disassemblyButton.setVisible(disassemblyButtonVisible);
            this.controls.disassemblyButtonGridData.exclude = !disassemblyButtonVisible;
            boolean locateFileButtonVisible = missingFileNameKnown;
            this.controls.locateFileButton.setVisible(locateFileButtonVisible);
            this.controls.locateFileButtonGridData.exclude = !locateFileButtonVisible;
            boolean editLookupButtonVisible = missingFileNameKnown && this.isDebugElement;
            this.controls.editLookupButton.setVisible(editLookupButtonVisible);
            this.controls.editLookupButtonGridData.exclude = !editLookupButtonVisible;
            this.controls.buttonParentComposite.layout(true, true);
        }
    }

    protected String getText() {
        boolean isAddressOnly;
        String contextDescription;
        if (this.missingFile.length() > 0) {
            return NLS.bind((String)SourceLookupUIMessages.CSourceNotFoundEditor_0, (Object)this.missingFile);
        }
        if (this.context == null) {
            return super.getText();
        }
        ICSourceNotFoundDescription description = (ICSourceNotFoundDescription)this.context.getAdapter(ICSourceNotFoundDescription.class);
        if (description != null) {
            contextDescription = description.getDescription();
            isAddressOnly = description.isAddressOnly();
        } else {
            contextDescription = this.context.toString();
            isAddressOnly = false;
        }
        if (isAddressOnly) {
            return NLS.bind((String)SourceLookupUIMessages.CSourceNotFoundEditor_8, (Object)contextDescription);
        }
        return NLS.bind((String)SourceLookupUIMessages.CSourceNotFoundEditor_3, (Object)contextDescription);
    }

    protected void createButtons(final Composite parent) {
        this.controls.buttonParentComposite = parent;
        this.controls.disassemblyButton = new Button(parent, 8);
        this.controls.disassemblyButtonGridData = new GridData();
        this.controls.disassemblyButtonGridData.grabExcessHorizontalSpace = false;
        this.controls.disassemblyButtonGridData.grabExcessVerticalSpace = false;
        this.controls.disassemblyButton.setLayoutData((Object)this.controls.disassemblyButtonGridData);
        this.controls.disassemblyButton.setText(SourceLookupUIMessages.CSourceNotFoundEditor_4);
        this.controls.disassemblyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CSourceNotFoundEditor.this.viewDisassembly();
            }
        });
        this.controls.disassemblyButton.setData(UID_KEY, (Object)UID_DISASSEMBLY_BUTTON);
        this.controls.locateFileButton = new Button(parent, 8);
        this.controls.locateFileButtonGridData = new GridData();
        this.controls.locateFileButtonGridData.grabExcessHorizontalSpace = false;
        this.controls.locateFileButtonGridData.grabExcessVerticalSpace = false;
        this.controls.locateFileButton.setLayoutData((Object)this.controls.locateFileButtonGridData);
        this.controls.locateFileButton.setText(SourceLookupUIMessages.CSourceNotFoundEditor_1);
        this.controls.locateFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CSourceNotFoundEditor.this.locateFile();
            }
        });
        this.controls.locateFileButton.setData(UID_KEY, (Object)UID_LOCATE_FILE_BUTTON);
        this.controls.editLookupButton = new Button(parent, 8);
        this.controls.editLookupButtonGridData = new GridData();
        this.controls.editLookupButtonGridData.grabExcessHorizontalSpace = false;
        this.controls.editLookupButtonGridData.grabExcessVerticalSpace = false;
        this.controls.editLookupButton.setLayoutData((Object)this.controls.editLookupButtonGridData);
        this.controls.editLookupButton.setText(SourceLookupUIMessages.CSourceNotFoundEditor_5);
        this.controls.editLookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                CSourceNotFoundEditor.this.editSourceLookupPath();
            }
        });
        this.controls.editLookupButton.setData(UID_KEY, (Object)UID_EDIT_LOOKUP_BUTTON);
        Composite data = ControlFactory.createComposite((Composite)parent, (int)2);
        ((GridLayout)data.getLayout()).marginWidth = 0;
        ((GridLayout)data.getLayout()).marginHeight = 0;
        this.controls.preferenceText = new Text(data, 72);
        this.controls.preferenceButton = new Button(data, 8);
        this.controls.preferenceText.setText(SourceLookupUIMessages.CSourceNotFoundEditor_6);
        this.controls.preferenceButton.setText(SourceLookupUIMessages.CSourceNotFoundEditor_7);
        this.controls.preferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)CSourceNotFoundEditor.SOURCE_NOT_FOUND_PATH, null, null).open();
            }
        });
    }

    protected void viewDisassembly() {
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null) {
            try {
                page.showView("org.eclipse.cdt.dsf.debug.ui.disassembly.view");
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
    }

    private void addSourceMappingToDirector(String missingPath, IPath newSourcePath, AbstractSourceLookupDirector director) throws CoreException {
        ArrayList<ISourceContainer> containerList = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
        MappingSourceContainer foundMappings = null;
        for (ISourceContainer container : containerList) {
            if (!(container instanceof MappingSourceContainer) || !container.getName().equals("Found Mappings")) continue;
            foundMappings = (MappingSourceContainer)container;
            break;
        }
        if (foundMappings == null) {
            foundMappings = new MappingSourceContainer("Found Mappings");
            foundMappings.init((ISourceLookupDirector)director);
            containerList.add((ISourceContainer)foundMappings);
        }
        foundMappings.addMapEntry(new MapEntrySourceContainer(missingPath, newSourcePath));
        director.setSourceContainers(containerList.toArray(new ISourceContainer[containerList.size()]));
    }

    private void addSourceMappingToCommon(String missingPath, IPath newSourcePath) throws CoreException {
        CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
        this.addSourceMappingToDirector(missingPath, newSourcePath, (AbstractSourceLookupDirector)director);
        CDebugCorePlugin.getDefault().savePluginPreferences();
    }

    private void addSourceMappingToLaunch(String missingPath, IPath newSourcePath) throws CoreException {
        ILaunchManager launchManager;
        IPersistableSourceLocator locator;
        String memento = null;
        String type = null;
        ILaunchConfigurationWorkingCopy configuration = this.launch.getWorkingCopy();
        memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        if (type == null) {
            type = configuration.getType().getSourceLocatorId();
        }
        if ((locator = (launchManager = DebugPlugin.getDefault().getLaunchManager()).newSourceLocator(type)) instanceof AbstractSourceLookupDirector) {
            AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                director.initializeDefaults((ILaunchConfiguration)configuration);
            } else {
                director.initializeFromMemento(memento, (ILaunchConfiguration)configuration);
            }
            this.addSourceMappingToDirector(missingPath, newSourcePath, director);
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
            configuration.doSave();
        }
    }

    protected void locateFile() {
        CDebugUtils.FileParts resParts;
        FileDialog dialog = new FileDialog(this.getEditorSite().getShell(), 0);
        dialog.setFilterNames(new String[]{SourceLookupUIMessages.CSourceNotFoundEditor_2});
        CDebugUtils.FileParts missingFileParts = CDebugUtils.getFileParts((String)this.missingFile);
        dialog.setFilterExtensions(new String[]{"*." + missingFileParts.getExtension()});
        String res = dialog.open();
        if (res != null && (resParts = CDebugUtils.getFileParts((String)res)).getFileName().toLowerCase().equals(missingFileParts.getFileName().toLowerCase())) {
            String compPath = missingFileParts.getFolder();
            Path newSourcePath = new Path(resParts.getFolder());
            if (compPath.length() > 0) {
                try {
                    if (this.isDebugElement) {
                        this.addSourceMappingToLaunch(compPath, (IPath)newSourcePath);
                    } else {
                        this.addSourceMappingToCommon(compPath, (IPath)newSourcePath);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            IWorkbenchPage page = this.getEditorSite().getPage();
            if (this.isDebugElement) {
                ISourceDisplay adapter = (ISourceDisplay)this.context.getAdapter(ISourceDisplay.class);
                if (adapter != null) {
                    adapter.displaySource((Object)this.context, page, true);
                }
            } else if (this.isTranslationUnit) {
                this.reopenTranslationUnit(this.tunit);
            }
            this.closeEditor();
        }
    }

    private boolean reopenTranslationUnit(ITranslationUnit tu) {
        IPath tuPath;
        if (tu != null && (tuPath = tu.getLocation()) != null) {
            Object[] foundElements;
            block6: {
                String filePath = tuPath.toOSString();
                foundElements = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector().findSourceElements((Object)filePath);
                if (foundElements.length != 1 || !(foundElements[0] instanceof IFile)) break block6;
                EditorUtility.openInEditor((Object)foundElements[0]);
                return true;
            }
            try {
                LocalFileStorage newLocation;
                if (foundElements.length == 1 && foundElements[0] instanceof LocalFileStorage && (newLocation = (LocalFileStorage)foundElements[0]).getFullPath().toFile().exists()) {
                    ITranslationUnit remappedTU = tu;
                    if (tu instanceof ExternalTranslationUnit) {
                        remappedTU = new ExternalTranslationUnit(tu.getParent(), URIUtil.toURI((IPath)newLocation.getFullPath()), tu.getContentTypeId());
                    }
                    EditorUtility.openInEditor((Object)remappedTU);
                    return true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    protected Object getArtifact() {
        Object o = super.getArtifact();
        if (o instanceof CSourceNotFoundElement) {
            return ((CSourceNotFoundElement)o).getElement();
        }
        return o;
    }

    private static class EditorControls {
        public Composite buttonParentComposite;
        public Button disassemblyButton;
        public GridData disassemblyButtonGridData;
        public Button locateFileButton;
        public GridData locateFileButtonGridData;
        public Button editLookupButton;
        public GridData editLookupButtonGridData;
        public Text fText;
        public Text preferenceText;
        public Button preferenceButton;

        private EditorControls() {
        }
    }
}

