/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteService;

public class JobRemoteService
extends AbstractRemoteService {
    private final List<Job> jobs = new ArrayList<Job>();

    @Override
    public void retrieve(final AbstractRemoteConsumer process, final boolean force) {
        if (process.isAsynchronous()) {
            Job job = new Job(process.getDescription()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        process.pull(force, monitor);
                    }
                    catch (CoreException e) {
                        return new Status(2, "org.eclipse.mylyn.reviews.core", "Couldn't update model.", (Throwable)e);
                    }
                    catch (OperationCanceledException e) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    JobRemoteService.this.modelExec(() -> {
                        IStatus result = event.getResult();
                        if (result.isOK()) {
                            process.applyModel(force);
                        }
                        process.notifyDone(event.getResult());
                    }, false);
                }
            });
            this.addJob(job);
            job.schedule();
        } else {
            try {
                process.pull(force, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                process.notifyDone(e.getStatus());
                return;
            }
            this.modelExec(() -> {
                process.applyModel(force);
                process.notifyDone(Status.OK_STATUS);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJob(final Job job) {
        List<Job> list = this.jobs;
        synchronized (list) {
            this.jobs.add(job);
        }
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                JobRemoteService.this.removeJob(job);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJob(Job job) {
        List<Job> list = this.jobs;
        synchronized (list) {
            this.jobs.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        List<Job> list = this.jobs;
        synchronized (list) {
            return this.jobs.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() {
        List<Job> list = this.jobs;
        synchronized (list) {
            for (Job job : this.jobs) {
                job.cancel();
            }
            this.jobs.clear();
        }
    }

    @Override
    public void modelExec(Runnable runnable, boolean block) {
        runnable.run();
    }
}

