/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.contentgenerator.ui;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.binding.soap.internal.generator.SOAPContentGenerator;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.contentgenerator.ui.BaseContentGeneratorOptionsPage;
import org.eclipse.wst.wsdl.ui.internal.contentgenerator.ui.ISoapStyleInfo;
import org.eclipse.wst.wsdl.ui.internal.util.ServicePolicyHelper;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.wizards.WSDLNewFileOptionsPage;
import org.w3c.dom.Element;

public class SoapBindingOptionsPage
extends BaseContentGeneratorOptionsPage
implements ISoapStyleInfo {
    protected Button docLiteral;
    protected Button rpcLiteral;
    protected Button rpcEncoded;

    @Override
    public Composite createControl(Composite parent) {
        EList eeList;
        QName qname;
        Definition definition;
        Binding binding;
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.control.setLayout((Layout)layout);
        Label separator = new Label(this.control, 258);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gd);
        Label optionsHeading = new Label(this.control, 0);
        optionsHeading.setText(Messages._UI_LABEL_SOAP_BINDING_OPTIONS);
        this.docLiteral = new Button(this.control, 16);
        this.docLiteral.setText(Messages._UI_RADIO_DOCUMENT_LITERAL);
        this.docLiteral.setSelection(true);
        this.rpcLiteral = new Button(this.control, 16);
        this.rpcLiteral.setText(Messages._UI_RADIO_RPC_LITERAL);
        this.rpcEncoded = new Button(this.control, 16);
        this.rpcEncoded.setText(Messages._UI_RADIO_RPC_ENCODED);
        if (this.generator.getName() != null && (binding = (Binding)(definition = this.generator.getDefinition()).getBinding(qname = new QName(definition.getTargetNamespace(), this.generator.getName()))) != null && (eeList = binding.getEExtensibilityElements()).size() > 0) {
            ExtensibilityElement ee = (ExtensibilityElement)eeList.get(0);
            Element element = WSDLEditorUtil.getInstance().getElementForObject(ee);
            String style = element.getAttribute("style");
            if ("rpc".equals(style)) {
                String use = "encoded";
                EList operations = binding.getEBindingOperations();
                if (operations.size() > 0) {
                    BindingFault fault;
                    List faultEE;
                    element = null;
                    BindingOperation operation = (BindingOperation)operations.get(0);
                    if (operation.getEBindingInput() != null && operation.getEBindingInput().getEExtensibilityElements().size() > 0) {
                        Object object = operation.getEBindingInput().getEExtensibilityElements().get(0);
                        element = WSDLEditorUtil.getInstance().getElementForObject(object);
                    } else if (operation.getEBindingOutput() != null && operation.getEBindingOutput().getEExtensibilityElements().size() > 0) {
                        Object object = operation.getEBindingOutput().getEExtensibilityElements().get(0);
                        element = WSDLEditorUtil.getInstance().getElementForObject(object);
                    } else if (operation.getEBindingFaults().size() > 0 && (faultEE = (fault = (BindingFault)operation.getEBindingFaults().get(0)).getExtensibilityElements()).size() > 0) {
                        element = WSDLEditorUtil.getInstance().getElementForObject(faultEE.get(0));
                    }
                    if (element != null) {
                        use = element.getAttribute("use");
                    }
                }
                if (use != null && "literal".equals(use)) {
                    this.docLiteral.setSelection(false);
                    this.rpcLiteral.setSelection(true);
                    this.rpcEncoded.setSelection(false);
                } else {
                    this.docLiteral.setSelection(false);
                    this.rpcLiteral.setSelection(false);
                    this.rpcEncoded.setSelection(true);
                }
            }
        }
        this.docLiteral.addSelectionListener((SelectionListener)this);
        this.rpcLiteral.addSelectionListener((SelectionListener)this);
        this.rpcEncoded.addSelectionListener((SelectionListener)this);
        this.setOptionsOnGenerator();
        return this.control;
    }

    @Override
    public void setOptionsOnGenerator() {
        if (this.generator.getContentGenerator() instanceof SOAPContentGenerator) {
            SOAPContentGenerator soapGenerator = (SOAPContentGenerator)this.generator.getContentGenerator();
            if (this.docLiteral.getSelection()) {
                soapGenerator.setStyle(1);
                soapGenerator.setUse(1);
            } else if (this.rpcLiteral.getSelection()) {
                soapGenerator.setStyle(2);
                soapGenerator.setUse(1);
            } else if (this.rpcEncoded.getSelection()) {
                soapGenerator.setStyle(2);
                soapGenerator.setUse(2);
            }
        }
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        this.setOptionsOnGenerator();
        if (this.wizardPage != null) {
            boolean isComplete = this.wizardPage.isPageComplete();
            if (this.wizardPage instanceof WSDLNewFileOptionsPage) {
                isComplete = ((WSDLNewFileOptionsPage)this.wizardPage).validatePage();
            }
            this.wizardPage.setPageComplete(isComplete);
        }
    }

    @Override
    public String getMessage() {
        String message = null;
        if (this.rpcEncoded != null && this.rpcEncoded.getSelection() && this.wizardPage instanceof WSDLNewFileOptionsPage) {
            IServicePolicy policy;
            IProject project = ((WSDLNewFileOptionsPage)this.wizardPage).getProject();
            int messageType = ServicePolicyHelper.getMessageSeverity(project, policy = ((WSDLNewFileOptionsPage)this.wizardPage).getServicePolicy());
            if (messageType == 3) {
                message = Messages._ERROR_WSI_COMPLIANCE_RPC_ENCODING;
            } else if (messageType == 2) {
                message = Messages._WARN_WSI_COMPLIANCE_RPC_ENCODING;
            }
        }
        if (message == null) {
            message = "";
        }
        return message;
    }

    @Override
    public int getMessageType() {
        int messageType = 0;
        if (this.rpcEncoded != null && this.rpcEncoded.getSelection() && this.wizardPage instanceof WSDLNewFileOptionsPage) {
            IProject project = ((WSDLNewFileOptionsPage)this.wizardPage).getProject();
            IServicePolicy policy = ((WSDLNewFileOptionsPage)this.wizardPage).getServicePolicy();
            messageType = ServicePolicyHelper.getMessageSeverity(project, policy);
        }
        return messageType;
    }

    @Override
    public boolean isDocumentLiteralPattern() {
        return this.docLiteral.getSelection();
    }
}

