/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ShowInPackageViewAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ShowInPackageViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ShowInPackageViewAction_label);
        this.setDescription(ActionMessages.ShowInPackageViewAction_description);
        this.setToolTipText(ActionMessages.ShowInPackageViewAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.show_in_packageview_action_context");
    }

    public ShowInPackageViewAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaScriptElement;
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IJavaScriptElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                this.run(element);
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            String message = ActionMessages.ShowInPackageViewAction_error_message;
            ErrorDialog.openError((Shell)this.getShell(), (String)ShowInPackageViewAction.getDialogTitle(), (String)message, (IStatus)e.getStatus());
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run((IJavaScriptElement)selection.getFirstElement());
    }

    public void run(IJavaScriptElement element) {
        if (element == null) {
            return;
        }
        IOpenable openable = element.getOpenable();
        if (openable instanceof IJavaScriptElement) {
            element = (IJavaScriptElement)openable;
        }
        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
        view.tryToReveal(element);
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInPackageViewAction_dialog_title;
    }
}

