/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.impl;

import java.io.PrintWriter;
import org.apache.wsil.Abstract;
import org.apache.wsil.Description;
import org.apache.wsil.Link;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocument;
import org.apache.wsil.extension.ExtensionBuilder;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.impl.AbstractImpl;
import org.apache.wsil.impl.DescriptionImpl;
import org.apache.wsil.impl.InspectionImpl;
import org.apache.wsil.impl.LinkImpl;
import org.apache.wsil.impl.ServiceImpl;
import org.apache.wsil.impl.ServiceNameImpl;

public class WSILDocumentImpl
extends WSILDocument {
    public WSILDocumentImpl() {
        this.inspection = new InspectionImpl();
    }

    @Override
    public Abstract createAbstract() {
        return new AbstractImpl();
    }

    @Override
    public Description createDescription() {
        return new DescriptionImpl();
    }

    @Override
    public Link createLink() {
        return new LinkImpl();
    }

    @Override
    public Service createService() {
        return new ServiceImpl();
    }

    @Override
    public ServiceName createServiceName() {
        return new ServiceNameImpl();
    }

    public static void main(String[] args) {
        try {
            String filename = args.length == 0 ? "c:\\temp\\inspection.wsil" : args[0];
            WSILDocument wdRead = WSILDocument.newInstance();
            wdRead.read(filename);
            wdRead.write(new PrintWriter(System.out));
            System.out.println("\n================================================\n");
            WSILDocument wdCreate = WSILDocument.newInstance();
            Service service = wdCreate.createService();
            Description desc = wdCreate.createDescription();
            ExtensionBuilder extBuilder = wdCreate.getExtensionRegistry().getBuilder("http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/");
            Reference ref = (Reference)extBuilder.createElement(Reference.QNAME);
            ImplementedBinding ib = (ImplementedBinding)extBuilder.createElement(ImplementedBinding.QNAME);
            ref.addImplementedBinding(ib);
            desc.setExtensionElement(ref);
            service.addDescription(desc);
            wdCreate.getInspection().addService(service);
            wdCreate.write(new PrintWriter(System.out));
        }
        catch (Exception e) {
            System.out.println("EXCEPTION: " + e.toString());
            e.printStackTrace();
        }
    }
}

