/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.commons.workbench.editors.CommonTextSupport;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LongTextAttributeEditor
extends AbstractAttributeEditor {
    private SourceViewer viewer;
    boolean ignoreNotification;
    boolean suppressRefresh;

    public LongTextAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        int style = 8388674;
        if (!this.isReadOnly()) {
            style |= 0x200;
        }
        this.viewer = new SourceViewer(parent, null, style);
        RepositoryTextViewerConfiguration configuration = RichTextEditor.installHyperlinkPresenter((ISourceViewer)this.viewer, this.getModel().getTaskRepository(), this.getModel().getTask(), RepositoryTextViewerConfiguration.Mode.DEFAULT);
        this.viewer.configure((SourceViewerConfiguration)configuration);
        this.viewer.setDocument((IDocument)new Document(this.getValue()));
        StyledText text = this.viewer.getTextWidget();
        text.setToolTipText(this.getDescription());
        toolkit.adapt((Control)text, false, false);
        CommonTextSupport.setTextViewer((Widget)text, (TextViewer)this.viewer);
        if (this.isReadOnly()) {
            this.viewer.setEditable(false);
        } else {
            this.viewer.setEditable(true);
            text.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            text.addModifyListener(e -> {
                try {
                    this.suppressRefresh = true;
                    this.setValue(text.getText());
                    CommonFormUtil.ensureVisible((Control)text);
                }
                finally {
                    this.suppressRefresh = false;
                }
            });
        }
        this.setControl((Control)text);
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public void setValue(String text) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), text);
        this.attributeChanged();
    }

    @Override
    public void refresh() {
        if (this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed()) {
            try {
                this.ignoreNotification = true;
                this.viewer.getDocument().set(this.getValue());
            }
            finally {
                this.ignoreNotification = false;
            }
        }
    }

    @Override
    public boolean shouldAutoRefresh() {
        return !this.suppressRefresh;
    }
}

