/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client.properties;

import org.eclipse.emf.cdo.common.util.CDOFingerPrinter;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.messages.Messages;
import org.eclipse.emf.cdo.lm.internal.client.properties.LMCheckoutProperties;
import org.eclipse.emf.cdo.lm.internal.client.properties.LMModuleCheckoutProperties;
import org.eclipse.emf.cdo.lm.util.LMFingerPrintAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

public abstract class AbstractLMProperties<RECEIVER>
extends Properties<RECEIVER> {
    public static final String CATEGORY = "Lifecycle Management";

    protected AbstractLMProperties(Class<RECEIVER> receiverType) {
        super(receiverType);
        this.initProperties();
    }

    protected abstract IAssemblyDescriptor getAssemblyDescriptor(RECEIVER var1);

    protected void initProperties() {
        this.add(new Property<RECEIVER>("moduleName", Messages.getString("AbstractLMProperties_00"), Messages.getString("AbstractLMProperties_01"), CATEGORY){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getModule(receiver).getName();
            }
        });
        this.add(new Property<RECEIVER>("moduleType", Messages.getString("AbstractLMProperties_12"), Messages.getString("AbstractLMProperties_13"), CATEGORY){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getModule(receiver).getType().getName();
            }
        });
        this.add(new Property<RECEIVER>("systemName", Messages.getString("AbstractLMProperties_02"), Messages.getString("AbstractLMProperties_03"), CATEGORY){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getBaseline(receiver).getSystem().getName();
            }
        });
        this.add(new Property<RECEIVER>("baselineName", Messages.getString("AbstractLMProperties_04"), Messages.getString("AbstractLMProperties_05"), CATEGORY){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getBaseline(receiver).getName();
            }
        });
        this.add(new Property<RECEIVER>("baselineTypeName", Messages.getString("AbstractLMProperties_10"), Messages.getString("AbstractLMProperties_11"), CATEGORY){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getBaseline(receiver).getTypeName();
            }
        });
        this.add(new Property<RECEIVER>("baselineTypeAndName"){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getBaseline(receiver).getTypeAndName();
            }
        });
        this.add(new Property<RECEIVER>("baselineType"){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getBaseline(receiver).eClass().getName();
            }
        });
        this.add(new Property<RECEIVER>("baselineFloating"){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getBaseline(receiver).isFloating();
            }
        });
        this.add(new Property<RECEIVER>("baselineHasFingerPrint"){

            protected Object eval(RECEIVER receiver) {
                CDOFingerPrinter.FingerPrint fingerPrint = AbstractLMProperties.this.getFingerPrint(receiver);
                if (fingerPrint != null) {
                    return true;
                }
                return false;
            }
        });
        this.add(new Property<RECEIVER>("baselineFingerPrint"){

            protected Object eval(RECEIVER receiver) {
                CDOFingerPrinter.FingerPrint fingerPrint = AbstractLMProperties.this.getFingerPrint(receiver);
                if (fingerPrint != null) {
                    return fingerPrint.getValue();
                }
                return null;
            }
        });
        this.add(new Property<RECEIVER>("streamName", Messages.getString("AbstractLMProperties_06"), Messages.getString("AbstractLMProperties_07"), CATEGORY){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getStream(receiver).getName();
            }
        });
        this.add(new Property<RECEIVER>("streamCodeName"){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getStream(receiver).getCodeName();
            }
        });
        this.add(new Property<RECEIVER>("streamModeName"){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getStream(receiver).getMode();
            }
        });
        this.add(new Property<RECEIVER>("streamVersion"){

            protected Object eval(RECEIVER receiver) {
                Stream stream = AbstractLMProperties.this.getStream(receiver);
                return stream.getMajorVersion() + 46 + stream.getMinorVersion();
            }
        });
        this.add(new Property<RECEIVER>("updatesAvailable"){

            protected Object eval(RECEIVER receiver) {
                return AbstractLMProperties.this.getAssemblyDescriptor(receiver).hasUpdatesAvailable();
            }
        });
    }

    private Module getModule(RECEIVER receiver) {
        return this.getBaseline(receiver).getModule();
    }

    private Stream getStream(RECEIVER receiver) {
        return this.getBaseline(receiver).getStream();
    }

    private Baseline getBaseline(RECEIVER receiver) {
        return this.getAssemblyDescriptor(receiver).getBaseline();
    }

    private CDOFingerPrinter.FingerPrint getFingerPrint(RECEIVER receiver) {
        Baseline baseline = this.getBaseline(receiver);
        if (baseline instanceof FixedBaseline) {
            FixedBaseline fixedBaseline = (FixedBaseline)baseline;
            return LMFingerPrintAnnotation.getFingerPrint((EObject)fixedBaseline);
        }
        return null;
    }

    public static void main(String[] args) {
        new LMCheckoutProperties.Tester().dumpContributionMarkup();
        new LMModuleCheckoutProperties.Tester().dumpContributionMarkup();
    }
}

