/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.refactoring.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.ui.refactoring.actions.CRenameAction;
import org.eclipse.cdt.ui.refactoring.actions.ExtractConstantAction;
import org.eclipse.cdt.ui.refactoring.actions.ExtractFunctionAction;
import org.eclipse.cdt.ui.refactoring.actions.ExtractLocalVariableAction;
import org.eclipse.cdt.ui.refactoring.actions.HideMethodAction;
import org.eclipse.cdt.ui.refactoring.actions.Messages;
import org.eclipse.cdt.ui.refactoring.actions.RefactoringAction;
import org.eclipse.cdt.ui.refactoring.actions.ToggleFunctionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;

public class CRefactoringActionGroup
extends ActionGroup
implements ISelectionChangedListener {
    public static final String MENU_ID = "org.eclipse.cdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    public static final String GROUP_CODING2 = "codingGroup2";
    public static final String GROUP_REORG2 = "reorgGroup2";
    public static final String GROUP_TYPE2 = "typeGroup2";
    public static final String GROUP_TYPE3 = "typeGroup3";
    private String fGroupName = "group.reorganize";
    private CRenameAction fRenameAction;
    private RefactoringAction fExtractConstantAction;
    private RefactoringAction fExtractLocalVariableAction;
    private RefactoringAction fExtractFunctionAction;
    private RefactoringAction fToggleFunctionAction;
    private RefactoringAction fHideMethodAction;
    private IWorkbenchSite fSite;
    private List<RefactoringAction> fAllActions = new ArrayList<RefactoringAction>();

    public CRefactoringActionGroup(IWorkbenchPart part) {
        this(part, null);
    }

    public CRefactoringActionGroup(Page page) {
        this.createActions(false);
        this.setWorkbenchSite((IWorkbenchSite)page.getSite());
    }

    public CRefactoringActionGroup(IWorkbenchPart part, String groupName) {
        if (groupName != null && groupName.length() > 0) {
            this.fGroupName = groupName;
        }
        this.createActions(part instanceof ITextEditor);
        if (part instanceof ITextEditor) {
            this.setEditor((ITextEditor)part);
        } else {
            this.setWorkbenchSite((IWorkbenchSite)part.getSite());
        }
    }

    private void createActions(boolean forEditor) {
        this.fRenameAction = new CRenameAction();
        this.fRenameAction.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.rename.element");
        this.fAllActions.add(this.fRenameAction);
        if (forEditor) {
            this.fExtractConstantAction = new ExtractConstantAction();
            this.fExtractConstantAction.setActionDefinitionId("org.eclipse.cdt.ui.refactor.extract.constant");
            this.fAllActions.add(this.fExtractConstantAction);
            this.fExtractLocalVariableAction = new ExtractLocalVariableAction();
            this.fExtractLocalVariableAction.setActionDefinitionId("org.eclipse.cdt.ui.refactor.extract.local.variable");
            this.fAllActions.add(this.fExtractLocalVariableAction);
            this.fExtractFunctionAction = new ExtractFunctionAction();
            this.fExtractFunctionAction.setActionDefinitionId("org.eclipse.cdt.ui.refactor.extract.function");
            this.fAllActions.add(this.fExtractFunctionAction);
            this.fToggleFunctionAction = new ToggleFunctionAction();
            this.fToggleFunctionAction.setActionDefinitionId("org.eclipse.cdt.ui.refactor.toggle.function");
            this.fAllActions.add(this.fToggleFunctionAction);
        }
        this.fHideMethodAction = new HideMethodAction();
        this.fHideMethodAction.setActionDefinitionId("org.eclipse.cdt.ui.refactor.hide.method");
        this.fAllActions.add(this.fHideMethodAction);
    }

    public void setWorkbenchSite(IWorkbenchSite site) {
        this.unregisterSite();
        this.fSite = site;
        for (RefactoringAction action : this.fAllActions) {
            action.setSite(site);
        }
        ISelectionProvider sp = this.fSite.getSelectionProvider();
        sp.addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateActions(sp.getSelection());
    }

    private void unregisterSite() {
        if (this.fSite != null) {
            this.fSite.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            this.fSite = null;
        }
    }

    public void setEditor(ITextEditor textEditor) {
        this.unregisterSite();
        for (RefactoringAction action : this.fAllActions) {
            action.setEditor((IEditorPart)textEditor);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setActionHandler(actionBar, "org.eclipse.cdt.ui.actions.Rename", this.fRenameAction);
        this.setActionHandler(actionBar, "org.eclipse.cdt.ui.actions.ExtractConstant", this.fExtractConstantAction);
        this.setActionHandler(actionBar, "org.eclipse.cdt.ui.actions.ExtractLocalVariable", this.fExtractLocalVariableAction);
        this.setActionHandler(actionBar, "org.eclipse.cdt.ui.actions.ExtractMethod", this.fExtractFunctionAction);
        this.setActionHandler(actionBar, "org.eclipse.cdt.ui.actions.ToggleFunction", this.fToggleFunctionAction);
        this.setActionHandler(actionBar, "org.eclipse.cdt.ui.actions.HideMethod", this.fHideMethodAction);
    }

    private void setActionHandler(IActionBars actionBar, String id, RefactoringAction action) {
        if (action != null) {
            actionBar.setGlobalActionHandler(id, (IAction)action);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        this.updateActionBars();
        boolean needMenu = false;
        for (RefactoringAction action : this.fAllActions) {
            if (!action.isEnabled()) continue;
            needMenu = true;
            break;
        }
        if (needMenu) {
            MenuManager refactorSubmenu = new MenuManager(Messages.CRefactoringActionGroup_menu, MENU_ID);
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
            this.addAction((IMenuManager)refactorSubmenu, this.fRenameAction);
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING));
            this.addAction((IMenuManager)refactorSubmenu, this.fExtractConstantAction);
            this.addAction((IMenuManager)refactorSubmenu, this.fExtractLocalVariableAction);
            this.addAction((IMenuManager)refactorSubmenu, this.fExtractFunctionAction);
            this.addAction((IMenuManager)refactorSubmenu, this.fToggleFunctionAction);
            this.addAction((IMenuManager)refactorSubmenu, this.fHideMethodAction);
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG2));
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE));
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE2));
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_CODING2));
            refactorSubmenu.add((IContributionItem)new Separator(GROUP_TYPE3));
            menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
        }
    }

    private void addAction(IMenuManager refactorSubmenu, RefactoringAction action) {
        if (action != null && action.isEnabled()) {
            refactorSubmenu.add((IAction)action);
        }
    }

    private ICElement getCElement(ISelection selection) {
        Object o;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (o = ss.getFirstElement()) instanceof ICElement && o instanceof ISourceReference) {
            return (ICElement)o;
        }
        return null;
    }

    private void updateActions(ISelection selection) {
        ICElement celem = this.getCElement(selection);
        for (RefactoringAction action : this.fAllActions) {
            action.updateSelection(celem);
        }
    }

    public void dispose() {
        this.unregisterSite();
        this.fSite = null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateActions(event.getSelection());
    }
}

