/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.delegates;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

class ValidatorDelegatesRegistryReader {
    static final String CLASS_ATTRIBUTE = "class";
    private static final String DELEGATE_ELEMENT = "delegate";
    private static final String EXTENSION_POINT_ID = "validatorDelegates";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String PLUGIN_ID = "org.eclipse.wst.validation";
    private static final String TARGET_ATTRIBUTE = "target";
    private ValidatorDelegatesRegistry registry;

    public ValidatorDelegatesRegistryReader(ValidatorDelegatesRegistry registry) {
        this.registry = registry;
    }

    private void readElement(IConfigurationElement element) {
        String elementName = element.getName();
        if (elementName.equals(DELEGATE_ELEMENT)) {
            String delegateID = element.getAttribute(CLASS_ATTRIBUTE);
            String delegateName = element.getAttribute(NAME_ATTRIBUTE);
            String targetValidatorID = element.getAttribute(TARGET_ATTRIBUTE);
            ValidatorDelegateDescriptor descriptor = new ValidatorDelegateDescriptor(delegateID, element, delegateName, targetValidatorID);
            this.registry.add(descriptor);
        }
    }

    void readRegistry() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        if (point != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = point.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    this.readElement(configurationElement);
                }
                catch (Exception exception) {
                    IContributor contributor = configurationElement.getContributor();
                    String msg = NLS.bind((String)ValMessages.RogueValidator, (Object)contributor);
                    ValidationPlugin.getPlugin().logMessage(4, msg);
                }
                ++n2;
            }
        }
    }
}

