/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.commands.actions.ActionsUpdater;
import org.eclipse.debug.internal.ui.commands.actions.ExecuteActionRequest;
import org.eclipse.debug.internal.ui.commands.actions.ICommandParticipant;
import org.eclipse.debug.internal.ui.commands.actions.IEnabledTarget;
import org.eclipse.debug.internal.ui.commands.actions.UpdateActionsRequest;
import org.eclipse.debug.internal.ui.commands.actions.UpdateHandlerRequest;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugCommandService
implements IDebugContextListener {
    private Map<Class<?>, List<IEnabledTarget>> fCommandUpdates = new HashMap();
    private IWorkbenchWindow fWindow;
    private final IDebugContextService fContextService;
    private static Map<IWorkbenchWindow, DebugCommandService> fgServices = new HashMap<IWorkbenchWindow, DebugCommandService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DebugCommandService getService(IWorkbenchWindow window) {
        DebugCommandService service = fgServices.get(window);
        if (service == null) {
            Map<IWorkbenchWindow, DebugCommandService> map = fgServices;
            synchronized (map) {
                service = fgServices.get(window);
                if (service == null) {
                    service = new DebugCommandService(window);
                    fgServices.put(window, service);
                }
            }
        }
        return service;
    }

    public DebugCommandService(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fContextService = DebugUITools.getDebugContextManager().getContextService(window);
        this.fContextService.addPostDebugContextListener(this);
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow w) {
            }

            public void windowDeactivated(IWorkbenchWindow w) {
            }

            public void windowClosed(IWorkbenchWindow w) {
                if (DebugCommandService.this.fWindow == w) {
                    DebugCommandService.this.dispose();
                }
            }

            public void windowActivated(IWorkbenchWindow w) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        this.fContextService.removeDebugContextListener(this);
        Map<IWorkbenchWindow, DebugCommandService> map = fgServices;
        synchronized (map) {
            fgServices.remove(this.fWindow);
        }
        this.fCommandUpdates.clear();
        this.fWindow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUpdateCommand(Class<?> commandType, IEnabledTarget action) {
        Map<Class<?>, List<IEnabledTarget>> map = this.fCommandUpdates;
        synchronized (map) {
            List<IEnabledTarget> actions = this.fCommandUpdates.get(commandType);
            if (actions == null) {
                actions = new ArrayList<IEnabledTarget>();
                this.fCommandUpdates.put(commandType, actions);
            }
            actions.add(action);
        }
    }

    public void updateCommand(Class<?> commandType, IEnabledTarget action) {
        ISelection context = this.fContextService.getActiveContext();
        if (context instanceof IStructuredSelection && !context.isEmpty()) {
            Object[] elements = ((IStructuredSelection)context).toArray();
            this.updateCommand(commandType, elements, new IEnabledTarget[]{action});
        } else {
            action.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpdate(ISelection context) {
        Map<Class<?>, List<IEnabledTarget>> commands = null;
        Map<Class<?>, List<IEnabledTarget>> map = this.fCommandUpdates;
        synchronized (map) {
            commands = this.fCommandUpdates;
            this.fCommandUpdates = new HashMap(commands.size());
        }
        if (context instanceof IStructuredSelection && !context.isEmpty()) {
            Object[] elements = ((IStructuredSelection)context).toArray();
            for (Map.Entry<Class<?>, List<IEnabledTarget>> entry : commands.entrySet()) {
                List<IEnabledTarget> actions = entry.getValue();
                this.updateCommand(entry.getKey(), elements, actions.toArray(new IEnabledTarget[actions.size()]));
            }
        } else {
            for (List<IEnabledTarget> actionList : commands.values()) {
                for (IEnabledTarget target : actionList) {
                    target.setEnabled(false);
                }
            }
        }
        commands.clear();
    }

    private void updateCommand(Class<?> handlerType, Object[] elements, IEnabledTarget[] actions) {
        this.cancelHandlerEnablementUpdateJobs(handlerType);
        if (elements.length == 1) {
            Object element = elements[0];
            IDebugCommandHandler handler = this.getHandler(element, handlerType);
            if (handler != null) {
                UpdateActionsRequest request = new UpdateActionsRequest(elements, actions);
                if (DebugUIPlugin.DEBUG_COMMAND_SERVICE) {
                    DebugUIPlugin.trace(String.valueOf((Object)request) + " to " + String.valueOf(handler));
                }
                handler.canExecute((IEnabledStateRequest)request);
                return;
            }
        } else {
            Map<IDebugCommandHandler, List<Object>> map = this.collate(elements, handlerType);
            if (map != null) {
                ActionsUpdater updater = new ActionsUpdater(actions, map.size());
                for (Map.Entry<IDebugCommandHandler, List<Object>> entry : map.entrySet()) {
                    UpdateHandlerRequest request = new UpdateHandlerRequest(entry.getValue().toArray(), updater);
                    if (DebugUIPlugin.DEBUG_COMMAND_SERVICE) {
                        DebugUIPlugin.trace(String.valueOf((Object)request) + " to " + String.valueOf(entry.getKey()));
                    }
                    entry.getKey().canExecute((IEnabledStateRequest)request);
                }
                return;
            }
        }
        IEnabledTarget[] iEnabledTargetArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IEnabledTarget action = iEnabledTargetArray[n2];
            action.setEnabled(false);
            ++n2;
        }
    }

    public boolean executeCommand(Class<?> handlerType, Object[] elements, ICommandParticipant participant) {
        if (elements.length == 1) {
            Object element = elements[0];
            IDebugCommandHandler handler = this.getHandler(element, handlerType);
            if (handler != null) {
                ExecuteActionRequest request = new ExecuteActionRequest(elements);
                request.setCommandParticipant(participant);
                return handler.execute((IDebugCommandRequest)request);
            }
        } else {
            Map<IDebugCommandHandler, List<Object>> map = this.collate(elements, handlerType);
            if (map != null) {
                boolean enabled = true;
                for (Map.Entry<IDebugCommandHandler, List<Object>> entry : map.entrySet()) {
                    ExecuteActionRequest request = new ExecuteActionRequest(entry.getValue().toArray());
                    request.setCommandParticipant(participant);
                    enabled &= entry.getKey().execute((IDebugCommandRequest)request);
                }
                return enabled;
            }
        }
        return false;
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        this.postUpdate(event.getContext());
    }

    private Map<IDebugCommandHandler, List<Object>> collate(Object[] elements, Class<?> handlerType) {
        HashMap<IDebugCommandHandler, List<Object>> map = new HashMap<IDebugCommandHandler, List<Object>>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IDebugCommandHandler handler = this.getHandler(element, handlerType);
            if (handler == null) {
                return null;
            }
            ArrayList<Object> list = (ArrayList<Object>)map.get(handler);
            if (list == null) {
                list = new ArrayList<Object>();
                map.put(handler, list);
            }
            list.add(element);
            ++n2;
        }
        return map;
    }

    private IDebugCommandHandler getHandler(Object element, Class<?> handlerType) {
        return (IDebugCommandHandler)DebugPlugin.getAdapter((Object)element, handlerType);
    }

    private void cancelHandlerEnablementUpdateJobs(Class<?> handlerType) {
        boolean hasMultipleWindowServices;
        if (handlerType != null && !(hasMultipleWindowServices = DebugCommandService.hasMultipleWindowServices())) {
            if (DebugUIPlugin.DEBUG_COMMAND_SERVICE) {
                Job[] jobs;
                Job[] jobArray = jobs = Job.getJobManager().find(handlerType);
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    DebugUIPlugin.trace("WOULD cancel " + String.valueOf(job));
                    ++n2;
                }
            }
            Job.getJobManager().cancel(handlerType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasMultipleWindowServices() {
        Map<IWorkbenchWindow, DebugCommandService> map = fgServices;
        synchronized (map) {
            return fgServices.size() > 1;
        }
    }
}

