/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.CommonUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.interpreter.IClassLoaderProvider;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.common.types.xtext.ui.XtextResourceSetBasedProjectProvider;
import org.osgi.framework.Bundle;

public class XcoreJavaProjectProvider
extends XtextResourceSetBasedProjectProvider
implements IClassLoaderProvider {
    public List<IJavaProject> getJavaProjects(Resource resource) {
        UniqueEList result = new UniqueEList();
        GenModel genModel = (GenModel)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)GenModelPackage.Literals.GEN_MODEL);
        if (genModel != null) {
            result.add(this.getJavaProject(genModel.getModelDirectory()));
            result.add(this.getJavaProject(genModel.getEditDirectory()));
            result.add(this.getJavaProject(genModel.getEditorDirectory()));
            result.add(this.getJavaProject(genModel.getTestsDirectory()));
        } else {
            result.add(this.getJavaProject(resource.getResourceSet()));
        }
        result.remove(null);
        return result;
    }

    protected IJavaProject getJavaProject(String directory) {
        IProject project;
        URI directoryURI;
        if (directory != null && (directoryURI = URI.createURI((String)directory)).segmentCount() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(directoryURI.segment(0))).exists()) {
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public IJavaProject getJavaProject(ResourceSet resourceSet) {
        IJavaProject result = super.getJavaProject(resourceSet);
        if (result == null) {
            for (Resource resource : resourceSet.getResources()) {
                IProject project;
                URI uri = resource.getURI();
                if (!uri.isPlatformResource() || !(project = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1))).exists()) continue;
                try {
                    if (!project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                    result = JavaCore.create((IProject)project);
                    break;
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public ClassLoader getClassLoader(ResourceSet resourceSet) {
        IJavaProject project = this.getJavaProject(resourceSet);
        if (project != null) {
            IProject iProject = project.getProject();
            IWorkspaceRoot workspaceRoot = iProject.getWorkspace().getRoot();
            UniqueEList libraryURLs = new UniqueEList();
            try {
                this.getAllReferencedProjects((Collection<URL>)libraryURLs, new IProject[]{iProject});
                IClasspathEntry[] classpath = project.getResolvedClasspath(true);
                if (classpath != null) {
                    String projectName = iProject.getName();
                    int i = 0;
                    while (i < classpath.length) {
                        IClasspathEntry classpathEntry = classpath[i];
                        switch (classpathEntry.getEntryKind()) {
                            case 1: 
                            case 5: {
                                IPath path = classpathEntry.getPath();
                                if (path.segment(0).equals(projectName)) {
                                    path = iProject.getLocation().append(path.removeFirstSegments(1));
                                }
                                libraryURLs.add(CommonUtil.newURL((String)URI.createFileURI((String)path.toString()).toString()));
                                break;
                            }
                            case 2: {
                                IPath path = classpathEntry.getPath();
                                IProject referencedProject = workspaceRoot.getProject(path.segment(0));
                                IJavaProject referencedJavaProject = JavaCore.create((IProject)referencedProject);
                                IFolder container = workspaceRoot.getFolder(referencedJavaProject.getOutputLocation());
                                libraryURLs.add(CommonUtil.newURL((String)URI.createFileURI((String)(String.valueOf(container.getLocation().toString()) + "/")).toString()));
                                IProjectDescription description = referencedProject.getDescription();
                                this.getAllReferencedProjects((Collection<URL>)libraryURLs, description.getReferencedProjects());
                                this.getAllReferencedProjects((Collection<URL>)libraryURLs, description.getDynamicReferences());
                                break;
                            }
                        }
                        ++i;
                    }
                }
                return new URLClassLoader(libraryURLs.toArray(new URL[libraryURLs.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
            }
            catch (JavaModelException exception) {
                exception.printStackTrace();
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
        for (Resource resource : resourceSet.getResources()) {
            URI uri = resource.getURI();
            if (!uri.isPlatformPlugin()) continue;
            final Bundle bundle = Platform.getBundle((String)uri.segments()[1]);
            return new ClassLoader(){

                @Override
                public Enumeration<URL> findResources(String name) throws IOException {
                    return bundle.getResources(name);
                }

                @Override
                public URL findResource(String name) {
                    return bundle.getResource(name);
                }

                @Override
                public URL getResource(String name) {
                    return this.findResource(name);
                }

                @Override
                public Class<?> findClass(String name) throws ClassNotFoundException {
                    return bundle.loadClass(name);
                }

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    Class<?> clazz = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            };
        }
        return null;
    }

    protected void getAllReferencedProjects(Collection<URL> libraryURLs, IProject[] projects) throws CoreException, MalformedURLException {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.exists() && project.isOpen()) {
                IJavaProject referencedJavaProject = JavaCore.create((IProject)project);
                IFolder container = project.getWorkspace().getRoot().getFolder(referencedJavaProject.getOutputLocation());
                if (libraryURLs.add(CommonUtil.newURL((String)URI.createFileURI((String)(String.valueOf(container.getLocation().toString()) + "/")).toString()))) {
                    IProjectDescription description = project.getDescription();
                    this.getAllReferencedProjects(libraryURLs, description.getReferencedProjects());
                    this.getAllReferencedProjects(libraryURLs, description.getDynamicReferences());
                }
            }
            ++i;
        }
    }
}

