/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public abstract class AbstractTestDescriptor
implements TestDescriptor {
    private static final String UNICODE_REPLACEMENT_CHARACTER = "\ufffd";
    private final UniqueId uniqueId;
    private final String displayName;
    private final @Nullable TestSource source;
    private @Nullable TestDescriptor parent;
    protected final Set<TestDescriptor> children = Collections.synchronizedSet(new LinkedHashSet(16));

    protected AbstractTestDescriptor(UniqueId uniqueId, String displayName) {
        this(uniqueId, displayName, null);
    }

    protected AbstractTestDescriptor(UniqueId uniqueId, String displayName, @Nullable TestSource source) {
        this.uniqueId = (UniqueId)Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        this.displayName = AbstractTestDescriptor.replaceControlCharacters(Preconditions.notBlank((String)displayName, (String)"displayName must not be null or blank"));
        this.source = source;
    }

    @Override
    public final UniqueId getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<TestTag> getTags() {
        return Collections.emptySet();
    }

    @Override
    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public final Optional<TestDescriptor> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public final void setParent(@Nullable TestDescriptor parent) {
        this.parent = parent;
    }

    @Override
    public final Set<? extends TestDescriptor> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    @Override
    public void addChild(TestDescriptor child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    public void removeChild(TestDescriptor child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        this.children.remove(child);
        child.setParent(null);
    }

    @Override
    public void removeFromHierarchy() {
        TestDescriptor parent = (TestDescriptor)Preconditions.notNull((Object)this.parent, (String)"cannot remove the root of a hierarchy");
        parent.removeChild(this);
        this.children.forEach(child -> child.setParent(null));
        this.children.clear();
    }

    @Override
    public void orderChildren(UnaryOperator<List<TestDescriptor>> orderer) {
        Preconditions.notNull(orderer, (String)"orderer must not be null");
        List suggestedOrder = (List)orderer.apply(new ArrayList<TestDescriptor>(this.children));
        Preconditions.notNull((Object)suggestedOrder, (String)"orderer may not return null");
        LinkedHashSet orderedChildren = new LinkedHashSet(suggestedOrder);
        boolean unmodified = this.children.equals(orderedChildren);
        Preconditions.condition((unmodified && this.children.size() == suggestedOrder.size() ? 1 : 0) != 0, (String)"orderer may not add or remove test descriptors");
        this.children.clear();
        this.children.addAll(orderedChildren);
    }

    @Override
    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId uniqueId) {
        Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        if (this.getUniqueId().equals(uniqueId)) {
            return Optional.of(this);
        }
        return this.children.stream().map(child -> child.findByUniqueId(uniqueId)).filter(Optional::isPresent).findAny().orElse(Optional.empty());
    }

    public final int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TestDescriptor that = (TestDescriptor)other;
        return this.getUniqueId().equals(that.getUniqueId());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + String.valueOf(this.getUniqueId());
    }

    private static String replaceControlCharacters(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            builder.append(AbstractTestDescriptor.replaceControlCharacter(text.charAt(i)));
        }
        return builder.toString();
    }

    private static String replaceControlCharacter(char ch) {
        return switch (ch) {
            case '\r' -> "<CR>";
            case '\n' -> "<LF>";
            default -> Character.isISOControl(ch) ? UNICODE_REPLACEMENT_CHARACTER : String.valueOf(ch);
        };
    }
}

