/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaEditorOpener {
    public static IEditorPart open(Match match, int offset, int length, boolean activate) throws PartInitException, JavaModelException {
        IEditorPart editor = null;
        Object element = match.getElement();
        if (element instanceof IJavaElement) {
            editor = JavaUI.openInEditor((IJavaElement)((IJavaElement)element));
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null && element instanceof IFile) {
            IFile file = (IFile)element;
            JavaEditorOpener.showWithMarker(editor, file, offset, length);
        }
        return editor;
    }

    private static void showWithMarker(IEditorPart editor, IFile file, int offset, int length) {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", offset);
            attributes.put("charEnd", offset + length);
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

