/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks;

import com.wamas.ide.launching.lcDsl.LaunchConfig;
import com.wamas.ide.launching.ui.LcDslHelper;
import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.util.FileUtils;

public class TaskLcDslLaunch {
    private final String configName;
    private final boolean wait;

    public TaskLcDslLaunch(String configName) {
        this(configName, true);
    }

    public TaskLcDslLaunch(String configName, boolean wait) {
        this.configName = configName;
        this.wait = wait;
    }

    @Execute
    public void run(BuildDirectories dirs) throws Exception {
        LaunchConfig lc = LcDslHelper.getInstance().findLaunchConfig(this.configName);
        Assert.isNotNull((Object)lc, (String)("cannot find " + this.configName));
        File logFile = new File(dirs.getLogDirectory(), this.configName + ".log");
        FileUtils.delete((File)logFile);
        LcDslHelper.getInstance().launch(lc, "run", false, this.wait, logFile);
    }

    protected LaunchConfig processConfig(LaunchConfig cfg) {
        return cfg;
    }

    public String toString() {
        return "Launcher [" + this.configName + "]";
    }
}

