/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.url;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfURLConnection;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class TcfURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final String WINPATH_PATTERN = "[A-Za-z]:.*";
    private static final char[] WINPATH_FORBIDDEN_CHARS = new char[]{':', '*', '?', '\"', '<', '>', '|'};

    public URLConnection openConnection(URL u) throws IOException {
        return new TcfURLConnection(u);
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        if (u.getPath() != null) {
            String path = u.getPath();
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            path = String.valueOf(path) + spec;
            this.setURL(u, u.getProtocol(), u.getHost(), u.getPort(), u.getAuthority(), u.getUserInfo(), path, u.getQuery(), u.getRef());
        } else {
            IllegalArgumentException errorFormat = new IllegalArgumentException(Messages.TcfURLStreamHandlerService_ErrorURLFormat);
            int end = spec.indexOf("/", start);
            if (end == -1) {
                throw errorFormat;
            }
            start = end + 1;
            if ((end = spec.indexOf("/", start)) == -1) {
                throw errorFormat;
            }
            String peerId = spec.substring(start, end);
            if (peerId.trim().length() == 0) {
                throw errorFormat;
            }
            start = end + 1;
            String path = spec.substring(start);
            if (path.length() > 0) {
                if (path.matches(WINPATH_PATTERN)) {
                    String pathext = path.substring(2);
                    if (pathext.length() == 0) {
                        throw new IllegalArgumentException(Messages.TcfURLStreamHandlerService_OnlyDiskPartError);
                    }
                    pathext = pathext.substring(1);
                    this.checkWinPath(pathext);
                } else {
                    path = "/" + path;
                }
            } else {
                path = "/";
            }
            final String path2decode = path;
            final AtomicReference pathRef = new AtomicReference();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    pathRef.set(TcfURLStreamHandlerService.this.decodeURLPath(path2decode));
                }
            });
            path = (String)pathRef.get();
            this.setURL(u, "tcf", peerId, -1, null, null, path, null, null);
        }
    }

    String decodeURLPath(String path) throws UnsupportedEncodingException {
        StringTokenizer st = new StringTokenizer(path, "/");
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreTokens()) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            String segment = st.nextToken();
            builder.append(URLDecoder.decode(segment, "UTF-8"));
        }
        String relative = builder.toString();
        return path.startsWith("/") ? "/" + relative : relative;
    }

    private void checkWinPath(String path) {
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            int j = 0;
            while (j < WINPATH_FORBIDDEN_CHARS.length) {
                if (c == WINPATH_FORBIDDEN_CHARS[j]) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.TcfURLStreamHandlerService_IllegalCharacter, (Object)("'" + c + "'")));
                }
                ++j;
            }
            ++i;
        }
    }

    String encodeURLPath(String path) throws UnsupportedEncodingException {
        StringTokenizer st = new StringTokenizer(path, "/");
        StringBuilder builder = new StringBuilder();
        while (st.hasMoreTokens()) {
            String segment;
            if (builder.length() > 0) {
                builder.append("/");
                segment = st.nextToken();
                builder.append(URLEncoder.encode(segment, "UTF-8"));
                continue;
            }
            segment = st.nextToken();
            if (path.matches(WINPATH_PATTERN)) {
                builder.append(segment);
                continue;
            }
            builder.append(URLEncoder.encode(segment, "UTF-8"));
        }
        String relative = builder.toString();
        return path.startsWith("/") ? "/" + relative : relative;
    }

    public String toExternalForm(final URL u) {
        String peerId = u.getHost();
        StringBuilder builder = new StringBuilder();
        builder.append("tcf");
        builder.append(":/");
        builder.append(peerId);
        final AtomicReference pathRef = new AtomicReference();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                pathRef.set(TcfURLStreamHandlerService.this.encodeURLPath(u.getPath()));
            }
        });
        String path = (String)pathRef.get();
        if (path == null) {
            builder.append("/");
        } else if (path.length() == 0) {
            builder.append("/");
        } else if (path.matches(WINPATH_PATTERN)) {
            builder.append("/");
            builder.append(path);
        } else {
            builder.append(path);
        }
        return builder.toString();
    }
}

