/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.concurrent.TCFOperationMonitor;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.util.TCFFileOutputStream;

public class OpUpload
extends AbstractOperation {
    IConfirmCallback fConfirmCallback;
    LinkedList<WorkItem> fWork = new LinkedList();
    private long fStartTime;

    public OpUpload(IConfirmCallback confirm) {
        this.fConfirmCallback = confirm;
    }

    public void addUpload(File source, FSTreeNode destinationFile) {
        this.fWork.add(new WorkItem(source, destinationFile, false));
    }

    public void addDrop(File source, FSTreeNode destiniationFolder) {
        this.fWork.add(new WorkItem(source, destiniationFolder, true));
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        this.fStartTime = System.currentTimeMillis();
        monitor.beginTask(this.getName(), -1);
        while (!this.fWork.isEmpty()) {
            IStatus s = this.runWorkItem(this.fWork.remove(), monitor);
            if (s.isOK()) continue;
            return s;
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus runWorkItem(WorkItem item, IProgressMonitor monitor) {
        BufferedOutputStream out;
        String path;
        FSTreeNode existing;
        String name;
        FSTreeNode destination;
        block24: {
            IStatus iStatus;
            destination = item.fDestination;
            File source = item.fSource;
            if (item.fDropToDestination) {
                IStatus status = this.refresh(destination, this.fStartTime, monitor);
                if (!status.isOK()) {
                    return status;
                }
                name = item.fSource.getName();
                existing = destination.findChild(name);
                if (source.isDirectory()) {
                    if (existing != null) {
                        if (!existing.isDirectory()) {
                            return StatusHelper.createStatus(MessageFormat.format(Messages.OpCopy_error_noDirectory, existing.getLocation()), null);
                        }
                        int replace = this.confirmCallback(existing, this.fConfirmCallback);
                        if (replace == 2) {
                            return Status.OK_STATUS;
                        }
                        if (replace != 0) {
                            return Status.CANCEL_STATUS;
                        }
                    } else {
                        status = destination.operationNewFolder(name).run((IProgressMonitor)new SubProgressMonitor(monitor, 0));
                        if (!status.isOK()) {
                            return status;
                        }
                        existing = destination.findChild(name);
                    }
                    File[] fileArray = source.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        this.fWork.addFirst(new WorkItem(child, existing, true));
                        ++n2;
                    }
                    return Status.OK_STATUS;
                }
                if (!source.isFile()) return Status.OK_STATUS;
                if (existing != null) {
                    if (!existing.isFile()) {
                        return StatusHelper.createStatus(MessageFormat.format(Messages.OpCopy_error_noFile, existing.getLocation()), null);
                    }
                    int replace = this.confirmCallback(existing, this.fConfirmCallback);
                    if (replace == 2) {
                        return Status.OK_STATUS;
                    }
                    if (replace != 0) {
                        return Status.CANCEL_STATUS;
                    }
                }
                path = this.getPath(destination, name);
            } else {
                name = destination.getName();
                existing = destination;
                path = destination.getLocation(true);
            }
            final TCFOperationMonitor result = new TCFOperationMonitor();
            monitor.subTask(NLS.bind((String)Messages.OpUpload_UploadSingleFile, (Object)item.fSource));
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IFileSystem fs = destination.getRuntimeModel().getFileSystem();
                    if (fs == null) {
                        result.setCancelled();
                    } else {
                        OpUpload.this.tcfGetOutputStream(fs, path, (TCFOperationMonitor<OutputStream>)result);
                    }
                }
            });
            IStatus status = result.waitDone(monitor);
            if (!status.isOK()) {
                return status;
            }
            out = new BufferedOutputStream((OutputStream)result.getValue());
            try {
                IStatus s = this.uploadFile(item.fSource, existing, out, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                if (s.isOK()) break block24;
                iStatus = s;
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)out).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
                return iStatus;
            }
            catch (IOException iOException) {}
            return iStatus;
        }
        try {
            ((OutputStream)out).close();
            return this.updateNode(path, name, destination, existing, monitor);
        }
        catch (IOException iOException) {}
        return this.updateNode(path, name, destination, existing, monitor);
    }

    private IStatus updateNode(final String path, final String name, final FSTreeNode destination, final FSTreeNode existing, IProgressMonitor monitor) {
        final TCFOperationMonitor r2 = new TCFOperationMonitor();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                IFileSystem fs = destination.getRuntimeModel().getFileSystem();
                if (fs == null) {
                    r2.setCancelled();
                } else if (!r2.checkCancelled()) {
                    fs.stat(path, new IFileSystem.DoneStat(){

                        public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                            if (error != null) {
                                r2.setError(MessageFormat.format(Messages.OpUpload_error_upload, name), (Throwable)error);
                            } else if (!r2.checkCancelled()) {
                                if (existing != null) {
                                    existing.setAttributes(attrs, true);
                                } else {
                                    destination.addNode(new FSTreeNode(destination, name, false, attrs), true);
                                }
                                r2.setDone(null);
                            }
                        }
                    });
                }
            }
        });
        return r2.waitDone(monitor);
    }

    protected void tcfGetOutputStream(IFileSystem fileSystem, final String path, final TCFOperationMonitor<OutputStream> result) {
        int flags = 26;
        if (!result.checkCancelled()) {
            fileSystem.open(path, flags, null, new IFileSystem.DoneOpen(){

                public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                    if (error != null) {
                        result.setError(MessageFormat.format(Messages.OpUpload_error_openFile, path), (Throwable)error);
                    } else {
                        result.setDone((Object)new TCFFileOutputStream(handle));
                    }
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    private IStatus uploadFile(File source, FSTreeNode existing, OutputStream output, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void statFile(final FSTreeNode node, IProgressMonitor monitor) {
        final TCFOperationMonitor result = new TCFOperationMonitor();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpUpload.this.tcfStat(node, result);
            }
        });
        result.waitDone(monitor);
    }

    protected void tcfStat(final FSTreeNode node, final TCFOperationMonitor<?> result) {
        if (!result.checkCancelled()) {
            IFileSystem fs = node.getRuntimeModel().getFileSystem();
            if (fs == null) {
                result.setCancelled();
                return;
            }
            fs.stat(node.getLocation(true), new IFileSystem.DoneStat(){

                public void doneStat(IToken token, IFileSystem.FileSystemException error, IFileSystem.FileAttrs attrs) {
                    if (error != null) {
                        OpUpload.this.handleFSError(node, Messages.OpRefresh_errorReadAttributes, error, result);
                    } else {
                        node.setAttributes(attrs, false);
                        result.setDone(null);
                    }
                }
            });
        }
    }

    @Override
    public String getName() {
        String message = this.fWork.size() == 1 ? NLS.bind((String)Messages.OpUpload_UploadSingleFile, (Object)this.fWork.element().fSource) : NLS.bind((String)Messages.OpUpload_UploadNFiles, (Object)this.fWork.size());
        return message;
    }

    private static class WorkItem {
        final File fSource;
        final FSTreeNode fDestination;
        final boolean fDropToDestination;

        WorkItem(File source, FSTreeNode destination, boolean isDrop) {
            this.fSource = source;
            this.fDestination = destination;
            this.fDropToDestination = isDrop;
        }
    }
}

