/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.core.interfaces.IFilterable;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.core.interfaces.IViewerInput;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IResultOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeBase;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNodeBase;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.UserAccount;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCopy;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCopyLocal;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCreateFile;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCreateFolder;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpDelete;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpDownload;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpMove;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRefresh;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRename;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpUpload;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.testers.TargetPropertyTester;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.ContentTypeHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;
import org.eclipse.tcf.te.tcf.filesystem.core.model.RuntimeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class FSTreeNode
extends FSTreeNodeBase
implements IFilterable,
org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode {
    private static final QualifiedName EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    static final String KEY_WIN32_ATTRS = "Win32Attrs";
    private static final Comparator<FSTreeNode> CMP_WIN = new Comparator<FSTreeNode>(){

        @Override
        public int compare(FSTreeNode o1, FSTreeNode o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private static final Comparator<FSTreeNode> CMP_UNIX = new Comparator<FSTreeNode>(){

        @Override
        public int compare(FSTreeNode o1, FSTreeNode o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private FSTreeNode fParent;
    private String fName;
    private IFSTreeNodeBase.Type fType;
    private IFileSystem.FileAttrs fAttributes;
    private FSTreeNode[] fChildren = null;
    private final RuntimeModel fRuntimeModel;
    private final boolean fWindowsNode;
    private long fRefreshTime;

    public FSTreeNode(RuntimeModel runtimeModel, String name) {
        this.fRuntimeModel = runtimeModel;
        this.fParent = null;
        this.fName = name;
        this.fAttributes = null;
        this.fType = IFSTreeNodeBase.Type.FILE_SYSTEM;
        this.fWindowsNode = this.isWindowsNode(this.getPeerNode());
        Assert.isTrue((boolean)Protocol.isDispatchThread());
    }

    private boolean isWindowsNode(IPeerNode peerNode) {
        String osname = TargetPropertyTester.getOSName(peerNode);
        if (osname != null) {
            return osname.startsWith("Windows");
        }
        return false;
    }

    public FSTreeNode(FSTreeNode parent, String name, boolean isRootDir, IFileSystem.FileAttrs attribs) {
        this.fRuntimeModel = parent.getRuntimeModel();
        this.fWindowsNode = parent.isWindowsNode() || isRootDir && name.endsWith("\\");
        this.fParent = parent;
        this.fName = name;
        this.fAttributes = attribs;
        this.fType = isRootDir ? IFSTreeNodeBase.Type.ROOT : IFSTreeNodeBase.Type.DIRECTORY_OR_FILE;
        Assert.isTrue((boolean)Protocol.isDispatchThread());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": name=" + this.fName;
    }

    public Object getAdapter(Class adapter) {
        if (IViewerInput.class.equals((Object)adapter)) {
            return this.getPeerNode().getAdapter(IViewerInput.class);
        }
        if (IPropertyChangeProvider.class.equals((Object)adapter)) {
            return this.getPeerNode().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public RuntimeModel getRuntimeModel() {
        return this.fRuntimeModel;
    }

    @Override
    public IPeerNode getPeerNode() {
        return this.fRuntimeModel.getPeerNode();
    }

    @Override
    public UserAccount getUserAccount() {
        return this.fRuntimeModel.getUserAccount();
    }

    @Override
    public IFSTreeNodeBase.Type getType() {
        return this.fType;
    }

    @Override
    public boolean isWindowsNode() {
        return this.fWindowsNode;
    }

    @Override
    public boolean isFile() {
        return this.fAttributes != null && this.fAttributes.isFile();
    }

    @Override
    public boolean isDirectory() {
        switch (this.fType) {
            case FILE_SYSTEM: {
                return false;
            }
            case ROOT: {
                return true;
            }
            case DIRECTORY_OR_FILE: {
                return this.fAttributes == null || this.fAttributes.isDirectory();
            }
        }
        return false;
    }

    @Override
    public boolean isRootDirectory() {
        return this.fType == IFSTreeNodeBase.Type.ROOT;
    }

    public IFileSystem.FileAttrs getAttributes() {
        return this.fAttributes;
    }

    @Override
    protected int getWin32Attrs() {
        Object val;
        IFileSystem.FileAttrs attribs = this.fAttributes;
        if (attribs != null && attribs.attributes != null && (val = attribs.attributes.get(KEY_WIN32_ATTRS)) instanceof Integer) {
            return (Integer)val;
        }
        return 0;
    }

    @Override
    protected int getPermissions() {
        IFileSystem.FileAttrs attribs = this.fAttributes;
        if (attribs != null) {
            return attribs.permissions;
        }
        return 0;
    }

    @Override
    public String getLocation() {
        return this.getLocation(false);
    }

    public String getLocation(boolean forceSlashes) {
        return this.getLocation(this.isWindowsNode() && !forceSlashes ? (char)'\\' : '/', false);
    }

    private String getLocation(char separator, boolean encodeName) {
        char lastChar;
        String name = this.getName();
        if (this.fType == IFSTreeNodeBase.Type.ROOT) {
            if (this.isWindowsNode() && name.charAt(name.length() - 1) != separator) {
                return String.valueOf(name.substring(0, name.length() - 1)) + separator;
            }
            return name;
        }
        if (this.fParent == null) {
            return name;
        }
        String pLoc = this.fParent.getLocation(separator, encodeName);
        if (pLoc.length() == 0) {
            return name;
        }
        if (encodeName) {
            try {
                name = URLEncoder.encode(this.getName(), "UTF-8");
            }
            catch (Exception exception) {}
        }
        if ((lastChar = pLoc.charAt(pLoc.length() - 1)) != separator) {
            return String.valueOf(pLoc) + separator + name;
        }
        return String.valueOf(pLoc) + name;
    }

    @Override
    public URL getLocationURL() {
        try {
            String id = this.getPeerNode().getPeerId();
            String path = this.getLocation(true);
            return new URL("tcf", id, path);
        }
        catch (MalformedURLException malformedURLException) {
            assert (false);
            return null;
        }
    }

    @Override
    public URI getLocationURI() {
        try {
            String id = this.getPeerNode().getPeerId();
            String path = this.getLocation('/', true);
            return new URI("tcf", id, path, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            assert (false);
            return null;
        }
    }

    @Override
    public String getFileTypeLabel() {
        switch (this.fType) {
            case FILE_SYSTEM: {
                return Messages.FSTreeNodeContentProvider_rootNodeLabel;
            }
            case ROOT: {
                return Messages.FSTreeNode_TypeLocalDisk;
            }
        }
        if (this.isDirectory()) {
            return Messages.FSTreeNode_TypeFileFolder;
        }
        if (this.isSystemFile()) {
            return Messages.FSTreeNode_TypeSystemFile;
        }
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(this.getName());
        if (contentType != null) {
            return contentType.getName();
        }
        int lastDot = this.getName().lastIndexOf(".");
        if (lastDot == -1) {
            return Messages.FSTreeNode_TypeUnknownFile;
        }
        return String.valueOf(this.getName().substring(lastDot + 1).toUpperCase()) + " " + Messages.FSTreeNode_TypeFile;
    }

    @Override
    public CacheState getCacheState() {
        File file = CacheManager.getCacheFile(this);
        if (!file.exists()) {
            return CacheState.consistent;
        }
        FileState digest = PersistenceManager.getInstance().getFileDigest(this);
        return digest.getCacheState();
    }

    @Override
    public FSTreeNode getParent() {
        return this.fParent;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public IFSTreeNodeWorkingCopy createWorkingCopy() {
        return new FSTreeNodeWorkingCopy(this);
    }

    @Override
    public boolean isFileSystem() {
        return this.fType == IFSTreeNodeBase.Type.FILE_SYSTEM;
    }

    @Override
    public long getAccessTime() {
        if (this.fAttributes != null) {
            return this.fAttributes.atime;
        }
        return 0L;
    }

    @Override
    public long getModificationTime() {
        if (this.fAttributes != null) {
            return this.fAttributes.mtime;
        }
        return 0L;
    }

    @Override
    public long getSize() {
        if (this.fAttributes != null) {
            return this.fAttributes.size;
        }
        return 0L;
    }

    @Override
    public int getUID() {
        if (this.fAttributes != null) {
            return this.fAttributes.uid;
        }
        return 0;
    }

    @Override
    public int getGID() {
        if (this.fAttributes != null) {
            return this.fAttributes.gid;
        }
        return 0;
    }

    @Override
    public boolean isAncestorOf(IFSTreeNode node) {
        while (node != null) {
            if ((node = node.getParent()) != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getCacheFile() {
        return CacheManager.getCacheFile(this);
    }

    @Override
    public String getPreferredEditorID() {
        return PersistenceManager.getInstance().getPersistentProperties(this).get(EDITOR_KEY);
    }

    @Override
    public void setPreferredEditorID(String editorID) {
        PersistenceManager.getInstance().getPersistentProperties(this).put(EDITOR_KEY, editorID);
    }

    @Override
    public IContentType getContentType() {
        return ContentTypeHelper.getContentType(this);
    }

    @Override
    public boolean isBinaryFile() {
        return ContentTypeHelper.isBinaryFile(this);
    }

    public FSTreeNode[] getChildren() {
        return this.fChildren;
    }

    @Override
    public IOperation operationRefresh(boolean recursive) {
        return new OpRefresh(this, recursive);
    }

    @Override
    public IOperation operationRename(String newName) {
        return new OpRename(this, newName);
    }

    @Override
    public IOperation operationUploadContent(File srcFile) {
        if (srcFile == null) {
            srcFile = this.getCacheFile();
        }
        OpUpload upload = new OpUpload(null);
        upload.addUpload(srcFile, this);
        return upload;
    }

    @Override
    public IOperation operationDelete(IConfirmCallback readonlyCallback) {
        return new OpDelete(Collections.singletonList(this), readonlyCallback);
    }

    @Override
    public IOperation operationDownload(OutputStream output) {
        return new OpDownload(this, output);
    }

    @Override
    public IOperation operationDownload(File destinationFolder, IConfirmCallback confirmCallback) {
        return new OpCopyLocal(Collections.singletonList(this), destinationFolder, confirmCallback);
    }

    @Override
    public IOperation operationDropFiles(List<String> files, IConfirmCallback confirmCallback) {
        OpUpload upload = new OpUpload(confirmCallback);
        for (String file : files) {
            upload.addDrop(new File(file), this);
        }
        return upload;
    }

    @Override
    public IOperation operationDropMove(List<IFSTreeNode> nodes, IConfirmCallback confirmCallback) {
        return new OpMove(nodes, this, confirmCallback);
    }

    @Override
    public IOperation operationDropCopy(List<IFSTreeNode> nodes, boolean cpPerm, boolean cpOwn, IConfirmCallback moveCopyCallback) {
        return new OpCopy(nodes, this, cpPerm, cpOwn, moveCopyCallback);
    }

    public IResultOperation<IFSTreeNode> operationNewFile(String name) {
        return new OpCreateFile(this, name);
    }

    public IResultOperation<IFSTreeNode> operationNewFolder(String name) {
        return new OpCreateFolder(this, name);
    }

    public void changeParent(FSTreeNode newParent) {
        this.fParent = newParent;
    }

    public void changeName(String newName) {
        this.fName = newName;
    }

    @Override
    public FSTreeNode findChild(String name) {
        return this.binarySearch(this.fChildren, name);
    }

    public void addNode(FSTreeNode newNode, boolean notify) {
        FSTreeNode[] children = this.fChildren;
        if (children == null) {
            this.setChildren(new FSTreeNode[]{newNode}, notify);
        } else {
            int ip = Arrays.binarySearch(children, newNode, this.getComparator());
            if (ip >= 0) {
                children[ip] = newNode;
            } else {
                ip = -ip - 1;
                FSTreeNode[] newChildren = new FSTreeNode[children.length + 1];
                System.arraycopy(children, 0, newChildren, 0, ip);
                newChildren[ip] = newNode;
                System.arraycopy(children, ip, newChildren, ip + 1, children.length - ip);
                this.setChildren(newChildren, notify);
            }
        }
    }

    public void removeNode(FSTreeNode node, boolean notify) {
        FSTreeNode[] children = this.fChildren;
        if (children == null) {
            return;
        }
        int ip = Arrays.binarySearch(children, node, this.getComparator());
        if (ip < 0 || children[ip] != node) {
            return;
        }
        FSTreeNode[] newChildren = new FSTreeNode[children.length - 1];
        System.arraycopy(children, 0, newChildren, 0, ip);
        System.arraycopy(children, ip + 1, newChildren, ip, children.length - ip - 1);
        this.setChildren(newChildren, notify);
    }

    public void setContent(FSTreeNode[] children, boolean notify) {
        Comparator<FSTreeNode> comparator = this.getComparator();
        Arrays.sort(children, comparator);
        if (this.fChildren != null) {
            int j = 0;
            int i = 0;
            while (i < children.length) {
                FSTreeNode node = children[i];
                while (j < this.fChildren.length) {
                    FSTreeNode old = this.fChildren[j];
                    int cmp = comparator.compare(old, node);
                    if (cmp == 0) {
                        old.setAttributes(node.fAttributes, false);
                        children[i] = old;
                        ++j;
                        break;
                    }
                    if (cmp > 0) break;
                    ++j;
                }
                ++i;
            }
        }
        this.fRefreshTime = System.currentTimeMillis();
        this.setChildren(children, notify);
    }

    private Comparator<FSTreeNode> getComparator() {
        return this.isWindowsNode() ? CMP_WIN : CMP_UNIX;
    }

    private void setChildren(FSTreeNode[] children, boolean notify) {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        FSTreeNode[] oldChildren = this.fChildren;
        this.fChildren = children;
        if (notify) {
            this.notifyChange("children", oldChildren, children);
        }
    }

    public void setAttributes(IFileSystem.FileAttrs attrs, boolean notify) {
        IFileSystem.FileAttrs oldAttrs = this.fAttributes;
        this.fAttributes = attrs;
        if (attrs.isFile()) {
            this.fRefreshTime = System.currentTimeMillis();
        }
        if (notify) {
            this.notifyChange("attributes", oldAttrs, attrs);
        }
    }

    public void notifyChange() {
        this.notifyChange("children", null, null);
    }

    private void notifyChange(String prop, Object oldValue, Object newValue) {
        this.fRuntimeModel.firePropertyChanged(new PropertyChangeEvent(this, prop, oldValue, newValue));
    }

    @Override
    public long getLastRefresh() {
        return this.fRefreshTime;
    }

    private FSTreeNode binarySearch(FSTreeNode[] children, String name) {
        if (children == null) {
            return null;
        }
        boolean caseSensitive = !this.isWindowsNode();
        int low = 0;
        int high = children.length - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            FSTreeNode midVal = children[mid];
            int n = cmp = caseSensitive ? midVal.getName().compareTo(name) : midVal.getName().compareToIgnoreCase(name);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return midVal;
        }
        return null;
    }

    @Override
    public void setRevealOnConnect(boolean value) {
        if (value) {
            if (CorePlugin.getDefault().addToRevealOnConnect(this.getLocation(true))) {
                this.notifyChange("favorites", Boolean.FALSE, Boolean.TRUE);
            }
        } else if (CorePlugin.getDefault().removeFromRevealOnConnect(this.getLocation(true))) {
            this.notifyChange("favorites", Boolean.TRUE, Boolean.FALSE);
        }
    }

    @Override
    public boolean isRevealOnConnect() {
        return CorePlugin.getDefault().isRevealOnConnect(this.getLocation(true));
    }
}

