/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.model;

import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.model.YamlElementName;

public abstract class YamlLabelAccess
extends YamlElementName {
    public static final Comparator<YamlLabelAccess> NAME_POSITION_COMPARATOR = new Comparator<YamlLabelAccess>(){

        @Override
        public int compare(YamlLabelAccess o1, YamlLabelAccess o2) {
            return o1.getNameNode().getStartOffset() - o2.getNameNode().getStartOffset();
        }
    };

    public static Position getTextPosition(YamlAstNode node) {
        return new Position(node.getStartOffset(), node.getLength());
    }

    public static TextRegion getTextRegion(YamlAstNode node) {
        return new BasicTextRegion((TextRegion)node);
    }

    protected YamlLabelAccess() {
    }

    public abstract YamlAstNode getNode();

    public abstract YamlAstNode getNameNode();

    public abstract List<? extends YamlLabelAccess> getAllInUnit();

    public abstract boolean isWriteAccess();
}

