/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.export;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.export.ExportConfigAttributes;
import org.eclipse.statet.ecommons.waltable.export.IExportFormatter;
import org.eclipse.statet.ecommons.waltable.export.ILayerExporter;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.print.PrintEntireGridCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOffCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOnCommand;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.ui.IClientAreaProvider;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class NatExporter {
    private final Shell shell;

    public NatExporter(Shell shell) {
        this.shell = shell;
    }

    public void exportSingleLayer(final ILayer layer, final IConfigRegistry configRegistry) {
        final ILayerExporter exporter = configRegistry.getConfigAttribute(ExportConfigAttributes.EXPORTER, DisplayMode.NORMAL, new String[0]);
        final OutputStream outputStream = exporter.getOutputStream(this.shell);
        if (outputStream == null) {
            return;
        }
        Runnable exportRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        exporter.exportBegin(outputStream);
                        NatExporter.this.exportLayer(exporter, outputStream, "", layer, configRegistry);
                        exporter.exportEnd(outputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to export.", e);
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
                NatExporter.this.openExport(exporter);
            }
        };
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(exportRunnable);
        } else {
            exportRunnable.run();
        }
    }

    public void exportMultipleNatTables(final ILayerExporter exporter, final Map<String, NatTable> natTablesMap) {
        final OutputStream outputStream = exporter.getOutputStream(this.shell);
        if (outputStream == null) {
            return;
        }
        Runnable exportRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        exporter.exportBegin(outputStream);
                        for (String name : natTablesMap.keySet()) {
                            NatTable natTable = (NatTable)natTablesMap.get(name);
                            NatExporter.this.exportLayer(exporter, outputStream, name, natTable, natTable.getConfigRegistry());
                        }
                        exporter.exportEnd(outputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to export.", e);
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
                NatExporter.this.openExport(exporter);
            }
        };
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(exportRunnable);
        } else {
            exportRunnable.run();
        }
    }

    protected void exportLayer(ILayerExporter exporter, OutputStream outputStream, String layerName, ILayer layer, IConfigRegistry configRegistry) {
        IClientAreaProvider originalClientAreaProvider = layer.getClientAreaProvider();
        layer.doCommand(new TurnViewportOffCommand());
        this.setClientAreaToMaximum(layer);
        ProgressBar progressBar = null;
        double factor = 1.0;
        if (this.shell != null) {
            Shell childShell = new Shell(this.shell.getDisplay(), 67680);
            childShell.setText(Messages.getString("NatExporter.exporting"));
            boolean startRow = false;
            long endRow = layer.getRowCount() - 1L;
            factor = endRow < Integer.MAX_VALUE ? 1.0 : 2.68435455E8 / (double)endRow;
            progressBar = new ProgressBar((Composite)childShell, 65536);
            progressBar.setMinimum(0);
            progressBar.setMaximum((int)(factor * (double)endRow));
            progressBar.setBounds(0, 0, 400, 25);
            progressBar.setFocus();
            childShell.pack();
            childShell.open();
        }
        try {
            exporter.exportLayerBegin(outputStream, layerName);
            long rowPosition = 0L;
            while (rowPosition < layer.getRowCount()) {
                exporter.exportRowBegin(outputStream, rowPosition);
                if (progressBar != null) {
                    progressBar.setSelection((int)(factor * (double)rowPosition));
                }
                long columnPosition = 0L;
                while (columnPosition < layer.getColumnCount()) {
                    ILayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
                    IExportFormatter exportFormatter = configRegistry.getConfigAttribute(ExportConfigAttributes.EXPORT_FORMATTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
                    Object exportDisplayValue = exportFormatter.formatForExport(cell, configRegistry);
                    exporter.exportCell(outputStream, exportDisplayValue, cell, configRegistry);
                    ++columnPosition;
                }
                exporter.exportRowEnd(outputStream, rowPosition);
                ++rowPosition;
            }
            exporter.exportLayerEnd(outputStream, layerName);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        layer.setClientAreaProvider(originalClientAreaProvider);
        layer.doCommand(new TurnViewportOnCommand());
        if (progressBar != null) {
            Shell childShell = progressBar.getShell();
            progressBar.dispose();
            childShell.dispose();
        }
    }

    private void setClientAreaToMaximum(ILayer layer) {
        final LRectangle maxClientArea = new LRectangle(0L, 0L, layer.getWidth(), layer.getHeight());
        layer.setClientAreaProvider(new IClientAreaProvider(){

            @Override
            public LRectangle getClientArea() {
                return maxClientArea;
            }
        });
        layer.doCommand(new PrintEntireGridCommand());
    }

    private void openExport(ILayerExporter exporter) {
        if (exporter.getResult() != null && exporter.getResult() instanceof File) {
            Program.launch((String)((File)exporter.getResult()).getAbsolutePath());
        }
    }
}

