/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public class ParameterNode
extends ValueNode {
    private int parameterNumber;
    private DataTypeDescriptor[] userParameterTypes;
    private DataValueDescriptor defaultValue;
    private JSQLType jsqlType;
    private int orderableVariantType = 2;
    private ValueNode returnOutputParameter;
    private ValueNode valToGenerate;

    ParameterNode(int parameterNumber, DataValueDescriptor defaultValue, ContextManager cm) {
        super(cm);
        this.parameterNumber = parameterNumber;
        this.defaultValue = defaultValue;
    }

    int getParameterNumber() {
        return this.parameterNumber;
    }

    void setDescriptors(DataTypeDescriptor[] descriptors) {
        this.userParameterTypes = descriptors;
    }

    @Override
    void setType(DataTypeDescriptor descriptor) throws StandardException {
        descriptor = descriptor.getNullabilityType(true);
        if (this.userParameterTypes != null) {
            this.userParameterTypes[this.parameterNumber] = descriptor;
        }
        super.setType(descriptor);
        if (this.getJSQLType() == null) {
            this.setJSQLType(new JSQLType(descriptor));
        }
    }

    void setReturnOutputParam(ValueNode valueNode) {
        this.returnOutputParameter = valueNode;
    }

    boolean isReturnOutputParam() {
        return this.returnOutputParameter != null;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.checkReliability("?", 8);
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return true;
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return true;
    }

    @Override
    protected int getOrderableVariantType() {
        return this.orderableVariantType;
    }

    void setOrderableVariantType(int type) {
        this.orderableVariantType = type;
    }

    public void setJSQLType(JSQLType type) {
        this.jsqlType = type;
    }

    public JSQLType getJSQLType() {
        return this.jsqlType;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.valToGenerate != null) {
            this.valToGenerate.generateExpression(acb, mb);
            return;
        }
        DataTypeDescriptor dtd = this.getTypeServices();
        if (dtd != null && dtd.getTypeId().isXMLTypeId()) {
            throw StandardException.newException("42Z70", new Object[0]);
        }
        mb.pushThis();
        mb.push(this.parameterNumber);
        mb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getParameter", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
        switch (dtd.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                mb.dup();
                mb.push(dtd.getMaximumWidth());
                mb.callMethod((short)185, null, "checkHostVariable", "void", 1);
                break;
            }
        }
        mb.cast(this.getTypeCompiler().interfaceName());
    }

    @Override
    TypeId getTypeId() throws StandardException {
        return this.returnOutputParameter != null ? this.returnOutputParameter.getTypeId() : super.getTypeId();
    }

    static void generateParameterValueSet(ExpressionClassBuilder acb, int numberOfParameters, List<ParameterNode> parameterList) throws StandardException {
        if (numberOfParameters > 0) {
            MethodBuilder constructor = acb.getConstructor();
            boolean hasReturnParam = parameterList.get(0).isReturnOutputParam();
            constructor.pushThis();
            constructor.push(numberOfParameters);
            constructor.push(hasReturnParam);
            constructor.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "setParameterValueSet", "void", 2);
            MethodBuilder executeMethod = acb.getExecuteMethod();
            executeMethod.pushThis();
            executeMethod.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "throwIfMissingParms", "void", 0);
        }
    }

    DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    boolean requiresTypeFromContext() {
        return true;
    }

    @Override
    boolean isParameterNode() {
        return true;
    }

    @Override
    boolean isEquivalent(ValueNode o) {
        return false;
    }

    protected void setValueToGenerate(ValueNode vn) {
        this.valToGenerate = vn;
    }
}

