/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.JavaWorkspaceScope;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.sphinx.emf.mwe.dynamic.WorkflowContributorRegistry;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.ReflectUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WorkflowTypeSelectionDialog
extends OpenTypeSelectionDialog {
    public WorkflowTypeSelectionDialog(Shell parent) {
        super(parent, false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)new WorkflowSearchScope(), 5, (TypeSelectionExtension)new WorkflowTypeSelectionExtension());
        this.setTitle(Messages.dialog_workflowTypeSelection_title);
        this.setMessage(Messages.dialog_workflowTypeSelection_message);
    }

    public void create() {
        this.addWorkflowContributorsToJavaSearch();
        super.create();
    }

    protected void addWorkflowContributorsToJavaSearch() {
        final SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
        final ArrayList<IPluginModelBase> modelsToBeAdded = new ArrayList<IPluginModelBase>();
        for (String id : WorkflowContributorRegistry.INSTANCE.getContributorPluginIds()) {
            IPluginModelBase model = PluginRegistry.findModel((String)id);
            if (model == null || model.getUnderlyingResource() != null || manager.isInJavaSearch(model.getPluginBase().getId())) continue;
            modelsToBeAdded.add(model);
        }
        if (modelsToBeAdded.isEmpty()) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        manager.addToJavaSearch(modelsToBeAdded.toArray(new IPluginModelBase[modelsToBeAdded.size()]));
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    protected static class WorkflowSearchScope
    extends JavaWorkspaceScope {
        protected WorkflowSearchScope() {
        }

        public IPath[] enclosingProjectsAndJars() {
            IPath[] result = null;
            try {
                result = (IPath[])ReflectUtil.getInvisibleFieldValue((Object)((Object)this), (String)"enclosingPaths");
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
            if (result != null) {
                return result;
            }
            LinkedHashSet<IPath> workflowSearchPaths = new LinkedHashSet<IPath>();
            Set<IPath> javaProjectPaths = this.getJavaProjectPaths();
            IPath[] iPathArray = super.enclosingProjectsAndJars();
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path = iPathArray[n2];
                if (javaProjectPaths.contains(path) || WorkflowContributorRegistry.INSTANCE.isContributorClasspathLocation(path)) {
                    workflowSearchPaths.add(path);
                }
                ++n2;
            }
            result = workflowSearchPaths.toArray(new IPath[workflowSearchPaths.size()]);
            try {
                ReflectUtil.setInvisibleFieldValue((Object)((Object)this), (String)"enclosingPaths", (Object)result);
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
            return result;
        }

        protected Set<IPath> getJavaProjectPaths() {
            HashSet<IPath> javaProjectPaths = new HashSet<IPath>();
            try {
                IJavaProject[] iJavaProjectArray = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
                int n = iJavaProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject javaProject = iJavaProjectArray[n2];
                    if (!javaProject.getProject().getName().equals("External Plug-in Libraries")) {
                        javaProjectPaths.add(javaProject.getProject().getFullPath());
                    }
                    ++n2;
                }
            }
            catch (JavaModelException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
            return javaProjectPaths;
        }
    }

    protected static class WorkflowTypeSelectionExtension
    extends TypeSelectionExtension {
        protected WorkflowTypeSelectionExtension() {
        }

        public ITypeInfoFilterExtension getFilterExtension() {
            return new ITypeInfoFilterExtension(){

                public boolean select(ITypeInfoRequestor typeInfoRequestor) {
                    try {
                        TypeNameMatch match = (TypeNameMatch)ReflectUtil.getInvisibleFieldValue((Object)typeInfoRequestor, (String)"fMatch");
                        IType matchType = match.getType();
                        if (!matchType.isBinary()) {
                            IType workflowType = matchType.getJavaProject().findType(Workflow.class.getName());
                            if (workflowType != null) {
                                ITypeHierarchy supertypeHierarchy = matchType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                                List<IType> matchSuperclasses = Arrays.asList(supertypeHierarchy.getAllSuperclasses(matchType));
                                return matchSuperclasses.contains(workflowType);
                            }
                        } else if (!matchType.getFullyQualifiedName().startsWith("bin")) {
                            return WorkflowContributorRegistry.INSTANCE.matchesContributedWorkflowClass(matchType);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return false;
                }
            };
        }
    }
}

