/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.viatra.query.proxymanagment;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolver;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSet;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.viatra.query.IViatraQueryEngineHelper;
import org.eclipse.sphinx.emf.viatra.query.ViatraQueryEngineHelper;
import org.eclipse.sphinx.emf.viatra.query.internal.Activator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFScope;

public abstract class AbstractViatraQueryProxyResolver
implements IProxyResolver {
    private IViatraQueryEngineHelper viatraQueryEngineHelper;

    protected boolean isBlank(String text) {
        return text == null || text.isEmpty();
    }

    protected IViatraQueryEngineHelper getViatraQueryEngineHelper() {
        if (this.viatraQueryEngineHelper == null) {
            this.viatraQueryEngineHelper = this.createViatraQueryEngineHelper();
        }
        return this.viatraQueryEngineHelper;
    }

    protected IViatraQueryEngineHelper createViatraQueryEngineHelper() {
        return new ViatraQueryEngineHelper();
    }

    protected String getTargetEObjectName(EObject proxy) {
        InternalEObject internalEObject = (InternalEObject)proxy;
        if (internalEObject.eIsProxy()) {
            return this.getTargetEObjectName(internalEObject.eProxyURI());
        }
        return null;
    }

    protected abstract String getTargetEObjectName(URI var1);

    protected abstract EStructuralFeature getTargetEObjectNameFeature(EClass var1);

    protected Stream<EObject> getEObjectCandidates(EObject proxy, ViatraQueryEngine engine) {
        Assert.isNotNull((Object)proxy);
        String targetEObjectName = this.getTargetEObjectName(proxy);
        return this.doGetEObjectCandidates(targetEObjectName, proxy.eClass(), engine);
    }

    protected Stream<EObject> getEObjectCandidates(URI uri, EClass targetEClass, ViatraQueryEngine engine) {
        String targetEObjectName = this.getTargetEObjectName(uri);
        return this.doGetEObjectCandidates(targetEObjectName, targetEClass, engine);
    }

    protected Stream<EObject> doGetEObjectCandidates(String targetEObjectName, EClass targetEClass, ViatraQueryEngine engine) {
        Assert.isNotNull((Object)targetEClass);
        try {
            final NavigationHelper baseIndex = EMFScope.extractUnderlyingEMFIndex((ViatraQueryEngine)engine);
            if (!this.isBlank(targetEObjectName)) {
                final EStructuralFeature targetEObjectNameFeature = this.getTargetEObjectNameFeature(targetEClass);
                baseIndex.coalesceTraversals((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        baseIndex.registerEStructuralFeatures(Collections.singleton(targetEObjectNameFeature), IndexingLevel.FULL);
                        return null;
                    }
                });
                return baseIndex.findByFeatureValue((Object)targetEObjectName, targetEObjectNameFeature).stream().filter(eobject -> targetEClass.isInstance(eobject));
            }
            final EClass finalTargetEClass = targetEClass;
            baseIndex.coalesceTraversals((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    baseIndex.registerEClasses(Collections.singleton(finalTargetEClass), IndexingLevel.FULL);
                    return null;
                }
            });
            return baseIndex.getAllInstances(targetEClass).stream();
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return Stream.empty();
        }
    }

    protected EObject getMatchingEObject(URI uri, Object contextObject, Stream<EObject> candidateObjects) {
        if (uri != null && candidateObjects != null) {
            Optional<EObject> value = candidateObjects.filter(candidateObject -> this.matchesEObjectCandidate(uri, contextObject, (EObject)candidateObject)).findFirst();
            return value.isPresent() ? value.get() : null;
        }
        return null;
    }

    protected boolean matchesEObjectCandidate(URI uri, Object contextObject, EObject candidateObject) {
        return this.matchesEObjectCandidate(uri, candidateObject);
    }

    protected boolean matchesEObjectCandidate(URI uri, EObject candidateObject) {
        URI candidateURI = EcoreResourceUtil.getURI((EObject)candidateObject);
        return uri.equals(candidateURI);
    }

    public boolean canResolve(EObject eObject) {
        if (eObject != null) {
            return this.canResolve(eObject.eClass());
        }
        return false;
    }

    protected abstract boolean isTypeSupported(EClass var1);

    public boolean canResolve(EClass eType) {
        if (eType != null) {
            return this.isTypeSupported(eType);
        }
        return false;
    }

    protected URI trimContextInfo(URI proxyURI, EObject contextObject) {
        ExtendedResource extendedResource;
        if (contextObject != null && (extendedResource = ExtendedResourceAdapterFactory.INSTANCE.getExtendedResource(contextObject)) != null) {
            return extendedResource.trimProxyContextInfo(proxyURI);
        }
        return proxyURI;
    }

    public EObject getEObject(EObject proxy, EObject contextObject, boolean loadOnDemand) {
        try {
            if (proxy != null) {
                URI uri = this.trimContextInfo(((InternalEObject)proxy).eProxyURI(), contextObject);
                ViatraQueryEngine engine = this.getViatraQueryEngineHelper().getEngine(contextObject);
                Stream<EObject> candidateObjects = this.getEObjectCandidates(proxy, engine);
                return this.getMatchingEObject(uri, contextObject, candidateObjects);
            }
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
        return null;
    }

    public EObject getEObject(URI uri, EClass targetEClass, ExtendedResourceSet contextResourceSet, Object contextObject, boolean loadOnDemand) {
        try {
            if (contextResourceSet != null) {
                uri = contextResourceSet.trimProxyContextInfo(uri);
                ViatraQueryEngine engine = this.getViatraQueryEngineHelper().getEngine((ResourceSet)contextResourceSet);
                Stream<EObject> candidateObjects = this.getEObjectCandidates(uri, targetEClass, engine);
                return this.getMatchingEObject(uri, contextObject, candidateObjects);
            }
        }
        catch (Exception ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
        return null;
    }
}

