/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.topdownpacking;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.topdownpacking.Grid;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class GridElkNode
implements ElkNode,
Grid<ElkNode> {
    private List<List<ElkNode>> grid;
    private int rows = 0;
    private int cols = 0;
    private ElkNode node;

    public GridElkNode(ElkNode elkNode) {
        this.node = elkNode;
    }

    @Override
    public void put(int col, int row, ElkNode item) throws IndexOutOfBoundsException {
        if (col >= this.cols || row >= this.rows) {
            throw new IndexOutOfBoundsException("The grid has a size of (" + this.cols + " x " + this.rows + "). The requested index of (" + col + " x " + row + ") is out of bounds.");
        }
        this.grid.get(row).add(col, item);
    }

    @Override
    public ElkNode get(int col, int row) throws IndexOutOfBoundsException {
        if (col >= this.cols || row >= this.rows) {
            throw new IndexOutOfBoundsException("The grid has a size of (" + this.cols + " x " + this.rows + "). The requested index of (" + col + " x " + row + ") is out of bounds.");
        }
        return this.grid.get(row).get(col);
    }

    @Override
    public List<ElkNode> getRow(int row) throws IndexOutOfBoundsException {
        if (row >= this.rows) {
            throw new IndexOutOfBoundsException("The grid has a size of (" + this.cols + " x " + this.rows + "). The requested row " + row + ") is out of bounds.");
        }
        return this.grid.get(row);
    }

    @Override
    public List<ElkNode> getColumn(int col) throws IndexOutOfBoundsException {
        if (col >= this.cols) {
            throw new IndexOutOfBoundsException("The grid has a size of (" + this.cols + " x " + this.rows + "). The requested column " + col + ") is out of bounds.");
        }
        ArrayList<ElkNode> resultList = new ArrayList<ElkNode>();
        int i = 0;
        while (i < this.rows) {
            resultList.add(this.grid.get(i).get(col));
            ++i;
        }
        return resultList;
    }

    @Override
    public int getColumns() {
        return this.cols;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public void setGridSize(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.grid = new ArrayList<List<ElkNode>>(rows);
        int i = 0;
        while (i < rows) {
            this.grid.add(new ArrayList());
            int j = 0;
            while (j < cols) {
                this.grid.get(i).add(null);
                ++j;
            }
            ++i;
        }
    }

    public EList<ElkEdge> getOutgoingEdges() {
        return this.node.getOutgoingEdges();
    }

    public EList<ElkEdge> getIncomingEdges() {
        return this.node.getIncomingEdges();
    }

    public double getHeight() {
        return this.node.getHeight();
    }

    public void setHeight(double value) {
        this.node.setHeight(value);
    }

    public double getWidth() {
        return this.node.getWidth();
    }

    public void setWidth(double value) {
        this.node.setWidth(value);
    }

    public double getX() {
        return this.node.getX();
    }

    public void setX(double value) {
        this.node.setX(value);
    }

    public double getY() {
        return this.node.getY();
    }

    public void setY(double value) {
        this.node.setY(value);
    }

    public void setDimensions(double width, double height) {
        this.node.setDimensions(width, height);
    }

    public void setLocation(double x, double y) {
        this.node.setLocation(x, y);
    }

    public EList<ElkLabel> getLabels() {
        return this.node.getLabels();
    }

    public String getIdentifier() {
        return this.node.getIdentifier();
    }

    public void setIdentifier(String value) {
        this.node.setIdentifier(value);
    }

    public EMap<IProperty<?>, Object> getProperties() {
        return this.node.getProperties();
    }

    public EClass eClass() {
        return this.node.eClass();
    }

    public Resource eResource() {
        return this.node.eResource();
    }

    public EObject eContainer() {
        return this.node.eContainer();
    }

    public EStructuralFeature eContainingFeature() {
        return this.node.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.node.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.node.eContents();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.node.eAllContents();
    }

    public boolean eIsProxy() {
        return this.node.eIsProxy();
    }

    public EList<EObject> eCrossReferences() {
        return this.node.eCrossReferences();
    }

    public Object eGet(EStructuralFeature feature) {
        return this.node.eGet(feature);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.node.eGet(feature, resolve);
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.node.eSet(feature, newValue);
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.node.eIsSet(feature);
    }

    public void eUnset(EStructuralFeature feature) {
        this.node.eUnset(feature);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.node.eInvoke(operation, arguments);
    }

    public EList<Adapter> eAdapters() {
        return this.node.eAdapters();
    }

    public boolean eDeliver() {
        return this.node.eDeliver();
    }

    public void eSetDeliver(boolean deliver) {
        this.node.eSetDeliver(deliver);
    }

    public void eNotify(Notification notification) {
        this.node.eNotify(notification);
    }

    public <T> IPropertyHolder setProperty(IProperty<? super T> property, T value) {
        return this.node.setProperty(property, value);
    }

    public <T> T getProperty(IProperty<T> property) {
        return (T)this.node.getProperty(property);
    }

    public boolean hasProperty(IProperty<?> property) {
        return this.node.hasProperty(property);
    }

    public IPropertyHolder copyProperties(IPropertyHolder holder) {
        return this.node.copyProperties(holder);
    }

    public Map<IProperty<?>, Object> getAllProperties() {
        return this.node.getAllProperties();
    }

    public EList<ElkPort> getPorts() {
        return this.node.getPorts();
    }

    public EList<ElkNode> getChildren() {
        return this.node.getChildren();
    }

    public ElkNode getParent() {
        return this.node.getParent();
    }

    public void setParent(ElkNode value) {
        this.node.setParent(value);
    }

    public EList<ElkEdge> getContainedEdges() {
        return this.node.getContainedEdges();
    }

    public boolean isHierarchical() {
        return this.node.isHierarchical();
    }
}

