/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.internal.session.factory.SessionFactoryDescriptor;
import org.eclipse.sirius.business.internal.session.factory.SessionFactoryRegistry;

public final class SessionFactoryService {
    public static final SessionFactoryService INSTANCE = new SessionFactoryService();

    public SessionFactory getSessionFactory() {
        SessionFactoryDescriptor sessionFactoryDescriptor;
        SessionFactory result = null;
        List<SessionFactoryDescriptor> uiSessionFactoryDescriptors = SessionFactoryRegistry.getRegisteredExtensions();
        if (!uiSessionFactoryDescriptors.isEmpty() && (sessionFactoryDescriptor = this.getFirstMostOverrider(uiSessionFactoryDescriptors)) != null) {
            result = sessionFactoryDescriptor.getSessionFactory();
        }
        return result;
    }

    private SessionFactoryDescriptor getFirstMostOverrider(List<SessionFactoryDescriptor> sessionFactoryDescriptors) {
        ArrayList<String> overriddenSessionFactoryIDs = new ArrayList<String>();
        SessionFactoryDescriptor firstMostOverridingSessionFactoryDescriptor2 = null;
        for (SessionFactoryDescriptor firstMostOverridingSessionFactoryDescriptor2 : sessionFactoryDescriptors) {
            String overrideValue = firstMostOverridingSessionFactoryDescriptor2.getOverrideValue();
            if (overrideValue == null) continue;
            overriddenSessionFactoryIDs.add(overrideValue);
        }
        for (SessionFactoryDescriptor firstMostOverridingSessionFactoryDescriptor2 : sessionFactoryDescriptors) {
            if (overriddenSessionFactoryIDs.contains(firstMostOverridingSessionFactoryDescriptor2.getId())) continue;
            return firstMostOverridingSessionFactoryDescriptor2;
        }
        return firstMostOverridingSessionFactoryDescriptor2;
    }
}

