/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.sirius.tools.internal.resource.InMemoryResourceFactoryImpl;
import org.eclipse.sirius.tools.internal.resource.InMemoryURIConverterImpl;

public class InMemoryResourceImpl
extends BinaryResourceImpl
implements Resource {
    private URIConverter uriConverter;

    public InMemoryResourceImpl(URI uri) {
        super(uri);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.addInMemoryURIHandler();
        super.doLoad(inputStream, options);
    }

    public void save(Map<?, ?> options) throws IOException {
        this.addInMemoryURIHandler();
        super.save(options);
    }

    protected URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new InMemoryURIConverterImpl();
        }
        return this.uriConverter;
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        super.doSave(outputStream, options);
        if (outputStream instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)outputStream;
            byte[] buffer = byteArrayOutputStream.toByteArray();
            URI uri = this.getURI();
            InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.put(uri, buffer);
        }
    }

    protected void doUnload() {
        super.doUnload();
        URI uri = this.getURI();
        InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.remove(uri);
    }

    private void addInMemoryURIHandler() {
        URIHandler uriHandler;
        EList uriHandlers = this.getResourceSet().getURIConverter().getURIHandlers();
        if (!uriHandlers.contains(uriHandler = this.getURIConverter().getURIHandler(this.getURI()))) {
            uriHandlers.add(0, uriHandler);
        }
    }
}

